<?php
$default_align = 'center';
$clients = $widget->get_setting('clients', []);
if(empty($clients)) return;
// Arrows
$arrows = $widget->get_setting('arrows');
$widget->add_render_attribute('arrows', [
    'class' => [
        'cms-swiper-buttons d-flex gap-10 flex-auto',
        finanzia_add_hidden_device_controls_render($settings, 'arrows_')
    ]
]);
$arrows_classes = [
    'cms-carousel-button text-19',
    'box-67 circle',
    'text-'.$widget->get_setting('arrow_color','primary'),
    'bg-'.$widget->get_setting('arrow_bg_color','grey'),
    'text-hover-'.$widget->get_setting('arrow_hover_color','white'),
    'bg-hover-'.$widget->get_setting('arrow_bg_hover_color','accent')
];
$arrows_classes_prev = finanzia_nice_class(array_merge(['cms-carousel-button-prev prev'],$arrows_classes));
$arrows_classes_next = finanzia_nice_class(array_merge(['cms-carousel-button-next next'],$arrows_classes));

// Dots
$dots = $widget->get_setting('dots');
$widget->add_render_attribute('dots', [
    'class' => [
        'cms-carousel-dots cms-carousel-dots-bullets',
        'gap-10 flex-basic',
        finanzia_add_hidden_device_controls_render($settings, 'dots_')
    ],
    'style' => [
        '--cms-dots-color:var(--cms-grey);',
        '--cms-dots-hover-color:var(--cms-accent);'
    ]
]);
// Media
$thumbnail_custom_dimension = [
    'width'  => !empty($settings['image_custom_dimension']['width']) ? $settings['image_custom_dimension']['width'] : 150,
    'height' => !empty($settings['image_custom_dimension']['height']) ? $settings['image_custom_dimension']['height'] : 60
];
// attribute
$widget->add_render_attribute('wrap', [
    'class' => [
        'cms-clients',
        'cms-clients-'.$settings['layout'],
        'relative'
    ]
]);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <div class="cms-carousel swiper relative">
        <div class="swiper-wrapper">
            <?php
            foreach ($clients as $key => $client) {
                $client['image_size'] = $settings['image_size'];
                $client['image_custom_dimension'] = $thumbnail_custom_dimension;
                // Link
                $link_key = $widget->get_repeater_setting_key( 'link', 'cms_client_link', $key );
                $widget->add_link_attributes( $link_key, $client['link'] );
                $widget->add_render_attribute($link_key, [
                    'class' => [
                        'client-item swiper-slide',
                        'p-tb-50 p-lr-20 text-center',
                        'd-flex align-items-center justify-content-center',
                        'bdr-r-1 bdr-divider'
                    ],
                    'title' => $client['name']
                ]);
                ?>
                <a <?php etc_print_html($widget->get_render_attribute_string( $link_key )); ?>><?php
                    finanzia_elementor_image_render($client,[
                        'name'           => 'image',
                        'image_size_key' => 'image',
                        'img_class'      => 'swiper-nav-vert',
                        'custom_size'    => $thumbnail_custom_dimension,
                        'before'         => '',
                        'after'          => ''
                    ]);
                ?></a>
            <?php } ?>
        </div>
    </div>
    <div class="cms-swiper-buttons-dots d-flex gap-20 align-items-end justify-content-between empty-none pt-40"><?php
        // Dots
        if ($dots == 'yes') { ?>
            <div <?php etc_print_html($widget->get_render_attribute_string('dots')); ?>></div>
        <?php }
        // Arrows
        if ($arrows == 'yes'){ ?>
            <div <?php etc_print_html($widget->get_render_attribute_string('arrows')); ?>><?php 
                finanzia_elementor_icon_render(
                    [], 
                    [
                        'library' => 'svg',
                        'value'   => [
                            'id'  => '',
                            'url' => get_template_directory().'/assets/svgs/core/arrow-left.svg'
                        ]
                    ], 
                    [
                        'class'     => $arrows_classes_prev,
                        'icon_size' => 19
                    ], 
                    'div'
                );
                finanzia_elementor_icon_render(
                    [], 
                    [
                        'library' => 'svg',
                        'value'   => [
                            'id'  => '',
                            'url' => get_template_directory().'/assets/svgs/core/arrow-right.svg'
                        ]
                    ], 
                    [
                        'class'     => $arrows_classes_next,
                        'icon_size' => 19
                    ], 
                    'div'
                );
            ?></div>
        <?php } 
    ?></div>
</div>