<?php
$widget->add_inline_editing_attributes( 'title' );
$widget->add_inline_editing_attributes( 'text' );
$widget->add_inline_editing_attributes( 'link_text' );
$widget->add_inline_editing_attributes( 'link2_text' );
$page_link = $widget->get_setting('page_link','');

$widget->add_render_attribute('title', [
	'class' => ['cms-title cms-heading text-26 pb-35 mt-n5','empty-none']
]);
$widget->add_render_attribute('text', [
	'class' => ['cms-desc','empty-none', 'mt-n7']
]);
//Button
$page_link = $widget->get_setting('page_link','');
switch ($settings['link_type']) {
	case 'page':
		$url  = !empty($page_link) ? get_permalink($page_link) : '#';
		break;
	
	default:
		$url = $widget->get_setting('custom_link', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'link_text', [
	'class' => [
		'btn btn-lg btn-accent text-white btn-hover-primary text-hover-white',
		'cms-hover-move-icon-up'
	],
	'href'	=> $url
]);
//Button2
$link2_page = $widget->get_setting('link2_page','');
switch ($settings['link2_type']) {
	case 'page':
		$url  = !empty($link2_page) ? get_permalink($link2_page) : '#';
		break;
	
	default:
		$url = $widget->get_setting('link2_custom', ['url' => '#'])['url'];
		break;
}
$widget->add_render_attribute( 'link2_text', [
	'class' => [
		'cms-link',
		'cms-hover-move-icon-up'
	],
	'href'	=> $url
]);
// Chart 
$charts = $widget->get_settings('cms_chart');
$chart_dimensions = $widget->get_settings('cms_chart_dimensions')['size'];
$chart_dimensions_size = !empty($chart_dimensions) ? $chart_dimensions : 330;
$chart_cutout = $widget->get_settings('cms_chart_cutout')['size'];
$chart_cutout_size = !empty($chart_cutout) ? $chart_cutout : '50%';
$html_id = etc_get_element_id($settings);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('title'));?>><?php etc_print_html($settings['title']) ?></div>
<div class="d-flex gutter-30">
	<div class="cms-chart-content col-6 col-mobile-12">
		<div <?php etc_print_html($widget->get_render_attribute_string('text'));?>><?php echo nl2br($settings['text']) ?></div>
		<?php if(!empty($settings['link_text']) || !empty($settings['link2_text'])){ ?>
		<div class="cms-buttons d-flex align-items-center gap-30 pt-35">
			<a <?php etc_print_html( $widget->get_render_attribute_string( 'link_text' ) ); ?>>
				<?php 
					// text
					echo esc_html( $settings['link_text'] );
					// icon
				?>
				<span class="text-10 lh-0"><?php include get_template_directory() . '/assets/svgs/core/arrow-right.svg'; ?></span>
			</a>
			<a <?php etc_print_html( $widget->get_render_attribute_string( 'link2_text' ) ); ?>>
				<?php 
					// text
					echo esc_html( $settings['link2_text'] );
					// icon
				?>
				<span class="text-10 lh-0"><?php include get_template_directory() . '/assets/svgs/core/arrow-right.svg'; ?></span>
			</a>
		</div>
		<?php } ?>
	</div>
	<div class="col-6 col-mobile-12 pt-50 pt-mobile-20">
		<?php finanzia_chart_data_settings($widget, $settings, [
			'chart_dimensions' => $chart_dimensions_size,
			'chart_mode'       => $widget->get_setting('cms_chart_mode'),
			'chart_cutout'	   => $chart_cutout_size,
			'wrap_class'	   => 'm-lr-auto cms-sticky'	
		]); ?>
	</div>
</div>