<?php
// Sources
$source    = $widget->get_setting('source',[]);
$orderby   = $widget->get_setting('orderby','date');
$order     = $widget->get_setting('order','desc');
$limit     = $widget->get_setting('limit', 4);

$tax = [];
foreach ($source as $category){
    $category_arr = explode('|', $category);
    $tax[] = $category_arr[0];
}
// Main Post Query
$main_posts = etc_get_posts_of_grid('post', [
    'post_type'                  => 'post',   
    'source'                     => $source,
    'orderby'                    => $orderby,
    'order'                      => $order,
    'limit'                      => '1',
    'tax'                        => $tax
]);
// Second Post Query
$second_posts = etc_get_posts_of_grid('post', 
    [
        'post_type' => 'post',   
        'source'    => $source,
        'orderby'   => $orderby,
        'order'     => $order,
        'limit'     => $limit - 1,
        'tax'       => $tax
    ], 
    [] , 
    [
        'offset'    => 1
    ]
);
// Wrap
$widget->add_render_attribute('wrap', [
    'class' => [
        'cms-eblog cms-eblog-'.$settings['layout'],
        'd-flex'
    ]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
    'class' => [
        'cms-heading empty-none',
        'text-'.$widget->get_setting('heading_color','heading'),
        'flex-basic m-tb-n10'
    ]
]);
// Link
?>
<div class="d-flex gap-30 justify-content-between pb-70 mb-70 pb-tablet-40 mb-tablet-40 bdr-b-1 bdr-divider">
    <h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
    <div class="flex-auto"><?php finanzia_elementor_link_render($widget, $settings, [
        'mode'      => 'link',
        'text_icon' => finanzia_svgs_icon([
            'icon'  => 'core/long-arrow-right',
            'class' => 'text-17',
            'echo'  => false
        ]),
        'class'            => 'cms-underline m-tb-n5 text-15 font-700 cms-link', 
        'text_color'       => 'accent',
        'text_color_hover' => 'accent',
    ]); ?></div>
</div>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
    <div class="cms-main-posts col-7 col-mobile-extra-12 hover-image-zoom-out pr-70 pr-tablet-40 pr-mobile-extra-0 pb-mobile-extra-40">
        <div class="cms-sticky bg-white cms-hover-shadow-1 cms-transition">
            <?php // Content
            foreach ($main_posts['posts'] as $post):
                finanzia_elementor_post_thumbnail_render($settings, [
                    'post_id'       => $post->ID,
                    'custom_size'   => ['width' => 660, 'height' => 382],
                    'img_class'     => 'img-cover',
                    'as_background' => false,
                    'max_height'    => true,
                    'before'        => '<div class="cms-main-img overflow-hidden">',
                    'after'         => '</div>'
                ]);
            ?>
                <div class="cms--content p-40 p-lr-smobile-20">
                    <div class="cms-post-meta cms-archive-meta gap-10 pb-15 mt-n5 text-13 d-flex align-items-center"><?php 
                        // Tag
                        finanzia_the_terms($post->ID, 'post_tag', '', 'tag-thumb-link cms-radius-13 text-13 lh-1 p-tb-5 p-lr-10', ['before' => '<div class="meta-item post-tag d-flex gap-5 text-13">', 'after' => '</div>']);
                        // Date
                        echo get_the_date('', $post->ID);
                    ?></div>
                    <h3 class="cms-heading text-line-4 text-26 lh-1307 text-accent text-hover-primary">
                        <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a>
                    </h3>
                    <div class="text-line-3 text-15 m-tb-n5 pt-15"><?php 
                        printf('%s', $post->post_excerpt);
                    ?></div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
    <div class="cms-second-posts col-5 col-mobile-extra-12">
        <?php // Content
            $second_post_classes = ['cms-content d-flex gap-40 gap-tablet-20 gap-mobile-extra-40 gap-smobile-20 align-items-center hover-image-zoom-out'];
            $count_post = (count($second_posts['posts']) - 1);
            foreach ($second_posts['posts'] as $key => $post): 
                if($key == $count_post){ $second_post_classes[] = 'last-item';}
        ?>
                <div class="<?php echo finanzia_nice_class($second_post_classes); if($key != $count_post){ echo ' mb-40 pb-40 bdr-b-1 bdr-divider';}?>">
                    <?php 
                        finanzia_elementor_post_thumbnail_render($settings, [
                            'post_id'       => $post->ID,
                            'custom_size'   => ['width' => 220, 'height' => 147],
                            'img_class'     => 'img-cover',
                            'max_height'    => true,    
                            'before'        => '<div class="flex-auto flex-smobile-full relative overflow-hidden">',
                            'after'         => '</div>'
                        ]);
                    ?>
                    <div class="flex-basic flex-tablet-full flex-mobile-extra-basic flex-smobile-full">
                        <?php 
                            // Tag
                            finanzia_the_terms($post->ID, 'post_tag', '', 'tag-thumb-link cms-radius-13 text-13 lh-1 p-tb-5 p-lr-10', ['before' => '<div class="meta-item post-tag d-flex gap-5 text-13 pb-15">', 'after' => '</div>']);
                        ?>
                        <h5 class="cms-heading text-19 text-line-3 text-accent text-hover-primary">
                            <a href="<?php echo esc_url(get_permalink( $post->ID )); ?>"><?php echo get_the_title($post->ID); ?></a>
                        </h5>
                        <div class="text-13 pt-10"><?php echo get_the_date('', $post->ID); ?></div>
                    </div>
                </div>
        <?php endforeach; ?>
    </div>
</div>