<?php 
// Post thumnail as banner
$settings['banner']['id'] = !empty($settings['banner']['id']) ? $settings['banner']['id'] : get_post_thumbnail_id();
//wrap
$widget->add_render_attribute('wrap',[
	'class' => [
		'cms-ebanner', 
		'cms-ebanner-'.$settings['layout'],
		'cms-maps-pointer',
        'cms-pointers',
        'relative',
        'd-inline-block'
	]
]);
// Pointer
// Items
$active_pointer = $settings['active_pointer'];
$cms_pointers = $widget->get_setting('cms_pointers', []);
?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php
		finanzia_elementor_image_render($settings,[
			'name'                => 'banner',
			'custom_size'         => ['width' => 840, 'height' => 582],
			'img_class'			  => ''
		]);
	?>
	<?php
        foreach ($cms_pointers as $key => $cms_pointer):
        $is_active = ( $key + 1 ) === $active_pointer ? true : false;
        $desc     = $cms_pointer['desc'];
        //elementor-repeater-item-
        $item_key = $widget->get_repeater_setting_key( 'item', 'cms_banner', $key );
        $widget->add_render_attribute( $item_key, [
            'id'    => 'cms-pointer-item-'.$cms_pointer['_id'],
            'class' => array_filter([ 
                'cms-pointer-item absolute cms-touchedside',
                'elementor-repeater-item-'.$cms_pointer['_id'],
                'cms-hover-active',
                $is_active ? 'active' : '',
                'pointer-top'
            ]),
            'data-active' => $is_active,
        ] );
        // Map Content
        $content_key = $widget->get_repeater_setting_key( 'content', 'cms_banner', $key );
        $widget->add_render_attribute($content_key,[
            'class' => [
                'cms-pointer-content bg-white d-flex no-wrap cms-shadow-1 cms--touchedside',
                empty($cms_pointer['banner']['id']) ? 'no-banner' : ''
            ]
        ]);
    ?>
        <div <?php etc_print_html($widget->get_render_attribute_string($item_key)); ?>>
            <div class="cms-pointer cms-ripple">
            	<div class="cms--ripple text-accent"></div>
                <div class="cms--pointer cms-circle"></div>
            </div>
            <div <?php etc_print_html($widget->get_render_attribute_string($content_key)); ?>>
                <?php 
                    finanzia_elementor_image_render($cms_pointer,[
                        'name'           => 'banner',
                        'image_size_key' => '',
                        'img_class'      => 'img-cover',
                        'size'           => 'custom',
                        'custom_size'    => ['width' => 130, 'height' => 160],
                        'default'        => false,
                        'before'         => '<div class="flex-auto max-w" style="--max-w:130px;">',
                        'after'          => '</div>'    
                    ]);
                ?>
                <div class="cms-pointer--content flex-basic p-30 p-lr-smobile-20 max-w" style="--max-w:240px;">
                    <h2 class="text-19 font-500 text-line-1"><?php echo esc_html($cms_pointer['title']); ?></h2>
                    <div class="address text-14 pt-10 pb-10"><?php echo esc_html($cms_pointer['desc']); ?></div>
                    <?php 
                    	// Link
		            	finanzia_elementor_link_render($widget, $cms_pointer, [
							'name' 		=> 'link1_',
							'text_icon'	=> finanzia_svgs_icon([
								'icon'  => 'core/long-arrow-right',
								'class' => 'text-17 order-first',
								'echo'	=> false
							]),
							'color'	   => false,	
							'loop'     => true,
							'loop_key' => $key,
							'class'    => 'cms-link text-accent text-hover-primary text-15 font-700 cms-hover-move-icon-right'
						]);
                    ?>
                </div>
            </div>
        </div>
    <?php  endforeach; ?>
</div>