<?php
$html_id            = etc_get_element_id( $settings );
$active_section     = $widget->get_settings('active_section', 1);
$accordions         = $widget->get_settings('cms_accordion');
// wrap
$widget->add_render_attribute('wrap', [
	'class' => [
		'cms-accordion',
		'cms-accordion-'.$settings['layout']
	]
]);
// Large Heading
$widget->add_inline_editing_attributes( 'heading_text', 'none' );
$widget->add_render_attribute( 'heading_text', [
	'class' => [
		'cms-heading cms-nl2br empty-none',
		'text-'.$widget->get_setting('heading_color','heading'),
		'text-26',
		'm-tb-n7 pb-30'
	]
]);
// Description
$widget->add_inline_editing_attributes( 'description_text' );
$widget->add_render_attribute( 'description_text', [
	'class' => array_filter([
		'cms-desc cms-nl2br empty-none',
		'text-'.$widget->get_setting('description_color','body'),
		'text-17 m-tb-n7'
	])
]);
// Element Heading
if(!empty($settings['heading_text']) || !empty($settings['description_text'])) {
?>
	<h2 <?php etc_print_html( $widget->get_render_attribute_string( 'heading_text' ) ); ?>><?php echo nl2br( $settings['heading_text'] ); ?></h2>
	<div <?php etc_print_html( $widget->get_render_attribute_string( 'description_text' ) ); ?>><?php echo nl2br( $settings['description_text'] ); ?></div>
	<div class="pb" style="--pb:50px;--pb-tablet:40px;"></div>
<?php } ?>
<div <?php etc_print_html($widget->get_render_attribute_string('wrap')); ?>>
	<?php 
		$count = 0;
		foreach ( $accordions as $key => $value ):
			$count ++;
			$is_active = ( $key + 1 ) == $active_section;
			$_id        = 'cms-accordion-'.$value['_id'];
			$ac_title   = isset( $value['ac_title'] ) ? $value['ac_title'] : '';
			$ac_content = isset( $value['ac_content'] ) ? $value['ac_content'] : '';
			$ac_document_text = isset( $value['ac_document_text'] ) ? $value['ac_document_text'] : '';
			$ac_document = isset( $value['ac_document']['url'] ) ? $value['ac_document']['url'] : '';
			// item
			$item_key = $widget->get_repeater_setting_key( 'item_key', 'cms_accordion', $key );
			$widget->add_render_attribute( $item_key, [
				'class' => [ 
					'cms-accordion-item',
					$is_active ? 'active' : '',
					'bdr-t-1 bdr-'.$widget->get_setting('border_color', 'divider')
				]
			]);
			// item title
			$item_title_key = $widget->get_repeater_setting_key( 'item_title', 'cms_accordion', $key );
			$widget->add_render_attribute( $item_title_key, [
				'class' => [ 
					'cms-accordion-title',
					$is_active ? 'active' : '',
					'd-flex gap-30 gap-smobile-10 align-items-start',
					'cms-hover-change',
					'text-'.$widget->get_setting('title_color','accent'),
					'text-hover-'.$widget->get_setting('title_active_color','accent'),
					'text-active-'.$widget->get_setting('title_active_color','accent'),
					'plus-minus',
					'p-tb'
				],
				'data-target' => '#'.$_id,
				'style' => '--p-tb:25px;'
			]);
			// title
			$title_key = $widget->get_repeater_setting_key( 'ac_title', 'cms_accordion', $key );
			$widget->add_render_attribute( $title_key, [
				'class' => [ 
					'cms-accordion-title-text',
					'flex-basic',
					'text-19 font-700',
					'm-tb-n7'
				]
			] );
			// content
			$content_key = $widget->get_repeater_setting_key( 'ac_content', 'cms_accordion', $key );
			$widget->add_render_attribute( $content_key, [
				'id'    => $_id,
				'class' => [ 
					'cms-accordion-content',
					'text-'.$widget->get_setting('content_color','body'),
					'mt-n7',
					'pt-5 pb-25'
				]
			] );
			if($count == count($accordions)){
				$widget->add_render_attribute( $item_key, [
					'class' => [
						'bdr-b-1 bdr-'.$widget->get_setting('border_color', 'divider')
					]
				]);
			}
			if ( $is_active ) {
				$widget->add_render_attribute( $content_key, 'style', 'display:block;' );
			}
			else{
				$widget->add_render_attribute( $content_key, 'style', 'display:none;' );
			}
		?>
		<div <?php etc_print_html( $widget->get_render_attribute_string( $item_key ) ); ?>>
		    <div <?php etc_print_html( $widget->get_render_attribute_string( $item_title_key ) ); ?>>
		    	<span <?php etc_print_html( $widget->get_render_attribute_string( $title_key ) ); ?>><?php echo esc_html( $ac_title ); ?></span>
		    	<?php finanzia_svgs_icon([
						'icon'   => 'core/minus-plus',
						'class'  => finanzia_nice_class([
							'cms-acc-icon cms-transition text-12 box-25 m-tb-n7',
							'text-'.$widget->get_setting('explain_icon_color','accent')
						])
		    	]) ?>
		    </div>
		    <div <?php etc_print_html( $widget->get_render_attribute_string( $content_key ) ); ?>>
				<?php 
					// text
					echo wpautop( $ac_content );
					// download 
				if(!empty($ac_document_text) && !empty($ac_document)){
				?>
					<a href="<?php echo esc_url($value['ac_document']['url']); ?>" class="btn btn-accent text-white btn-hover-primary text-hover-white" target="_blank"><?php etc_print_html($ac_document_text); ?></a>
				<?php } ?>
			</div>
		</div>
		<?php
		endforeach;
	?>
</div>