(function($) {
    var WidgetCMSProcess = function($scope, $) {
        let els = $scope.find('.cms-eprocess');
        const fromTop = 310;
        const toTop = -390;
        $.each(els, (i, el) => {
            el = $(el);
            let bgCoverScrollTrack = el.find('.cms-eprocess-right');
            let bgCoverScrollThumb = el.find('.cms-bg-cover-wrapper');
            let bgCovers = el.find('.cms-bg-cover');
            bgCoverScrollThumb.height(bgCovers.outerHeight());
            bgCovers.css('opacity', 0);
            $(bgCovers[0]).css('opacity', 1);

            el.scroller({
                sensitivity: 0,
                callback: event => {
                    let { $element, isInViewport, isDisappearing, intersectionScrollDirection, scrollPercentage } = event;
                    if (isInViewport) {
                        $element.scroller('onWindowScroll');
                        $element.scroller('onWindowResize');
                    } else {
                        $element.scroller('offWindowScroll');
                        $element.scroller('offWindowResize');
                    }
                },
                onWindowScroll: () => {
                    setProcesses(el);
                },
                onWindowResize: () => {
                    bgCoverScrollThumb.height(bgCovers.outerHeight());
                    setProcesses(el);
                },
            });
        });

        function getProcessing(el) {
            el = $(el);
            if (el.length == 0) {
                return false;
            }

            const elOffset = el[0].getBoundingClientRect();
            if (elOffset.top > fromTop) {
                return 0;
            } else if (elOffset.top <= fromTop && elOffset.top >= toTop) {
                if (elOffset.top >= 0) {
                    return (fromTop - elOffset.top) / (fromTop + Math.abs(toTop)) * 100;
                } else {
                    return (Math.abs(elOffset.top) + fromTop) / (fromTop + Math.abs(toTop)) * 100;
                }
            } else {
                return 100;
            }
        }

        function setProcess(scrollBarTrack, scrollbarThumb, processing, callback) {
            processing = parseInt(processing);
            let scrollBarTrackHeight = scrollBarTrack.outerHeight();
            let scrollbarThumbHeight = scrollbarThumb.outerHeight();
            scrollbarThumb.css('top', `${(scrollBarTrackHeight - scrollbarThumbHeight) * processing / 100}px`);
            if (typeof callback == 'function') {
                callback(scrollBarTrack, scrollbarThumb, processing);
            }
        }

        function setProcesses(el) {
            let scrollbar = el.find('.cms--eprocess-scrollbar');
            let scrollbarTrack = scrollbar.find('.cms--eprocess-scrollbar-track');
            let scrollbarThumb = scrollbar.find('.cms--eprocess-scrollbar-thumb');
            let bgCoverScrollTrack = el.find('.cms-eprocess-right');
            let bgCoverScrollThumb = el.find('.cms-bg-cover-wrapper');

            let processing = getProcessing(el);
            setProcess(scrollbarTrack, scrollbarThumb, processing);
            setProcess(bgCoverScrollTrack, bgCoverScrollThumb, processing, animateBgCovers);
        }

        function animateBgCovers(scrollBarTrack, scrollbarThumb, processing) {
            let bgCovers = scrollbarThumb.find('.cms-bg-cover');
            if (processing == 0) {
                bgCovers.css('opacity', 0);
                $(bgCovers[0]).css('opacity', 1);
            } else {
                const avg = 100 / bgCovers.length;
                const intersectionProcess = avg / 2;

                // first bg cover
                if (processing < avg - intersectionProcess) {
                    $(bgCovers[0]).css('opacity', 1);
                } else if (processing >= avg - intersectionProcess && processing <= avg) {
                    $(bgCovers[0]).css('opacity', (avg - processing) / intersectionProcess);
                } else if (processing > avg) {
                    $(bgCovers[0]).css('opacity', 0);
                }

                // last bg cover
                if (processing < avg * (bgCovers.length - 1) - intersectionProcess) {
                    $(bgCovers[bgCovers.length - 1]).css('opacity', 0);
                } else if (processing >= avg * (bgCovers.length - 1) - intersectionProcess && processing <= avg * (bgCovers.length - 1)) {
                    $(bgCovers[bgCovers.length - 1]).css('opacity', (processing - avg * (bgCovers.length - 1) + intersectionProcess) / intersectionProcess);
                } else if (processing > avg * (bgCovers.length - 1)) {
                    $(bgCovers[bgCovers.length - 1]).css('opacity', 1);
                }

                // other bg cover
                for (let i = 1; i < bgCovers.length - 1; i++) {
                    let bgCover = $(bgCovers[i]);
                    if (processing >= avg * i - intersectionProcess && processing <= avg * i) {
                        bgCover.css('opacity', (processing - avg * i + intersectionProcess) / intersectionProcess);
                    } else if (processing > avg * i && processing < avg * (i + 1) - intersectionProcess) {
                        bgCover.css('opacity', 1);
                    } else if (processing >= avg * (i + 1) - intersectionProcess && processing <= avg * (i + 1)) {
                        bgCover.css('opacity', (avg * (i + 1) - processing) / intersectionProcess);
                    } else if (processing > avg * (i + 1)) {
                        bgCover.css('opacity', 0);
                    }
                }
            }
        }
    };
    // Make sure you run this code under Elementor.
    $(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/cms_process.default', WidgetCMSProcess);
    });
})(jQuery);