(function($) {
    var WidgetCMSAccordionSticky = function($scope, $) {
        let els = $scope.find('.cms-accordion-sticky');
        let totalHeight = 0;
        let maxHeight = 0;
        let minHeight = 0;
        $.each(els, (i, el) => {
            el = $(el);
            const section = el.parents('.e-con').first();
            const sectionOffset = section[0].getBoundingClientRect();
            const elOffset = el[0].getBoundingClientRect();
            const pointer = $('<div>');
            pointer.css({
                position: 'sticky',
                top: Math.abs(Math.abs(elOffset.top) - Math.abs(sectionOffset.top)),
                width: '100%',
            });
            el.children().appendTo(pointer);
            el.append(pointer);
            const accordionItems = el.find('.cms-accordion-item:not(.cms-accordion-item-heading)');
            const accordionItemHeading = el.find('.cms-accordion-item-heading');
            $.each(accordionItems, function(accordionItemIndex, accordionItem) {
                accordionItem = $(accordionItem);
                const accordionItemParent = accordionItem.parent();
                const accordionItemTitle = accordionItem.find('.cms-accordion-title');
                totalHeight += accordionItemParent.outerHeight();
                maxHeight = accordionItemParent.outerHeight();
                minHeight = parseInt(accordionItemTitle.css('font-size')) + parseInt(accordionItem.css('padding-top')) + parseInt(accordionItem.css('padding-bottom'));
                accordionItemParent.css('max-height', minHeight);
            });
            el.css('height', totalHeight + maxHeight + 300);
            accordionItemHeading.height(maxHeight);

            pointer.scroller({
                sensitivity: 0,
                callback: event => {
                    let { $element, isInViewport, isDisappearing, intersectionScrollDirection, scrollPercentage } = event;
                    if (isInViewport) {
                        $element.scroller('onWindowScroll');
                        $element.scroller('onWindowResize');
                    } else {
                        $element.scroller('offWindowScroll');
                        $element.scroller('offWindowResize');
                    }
                },
                onWindowScroll: () => {
                    setPosition(el);
                },
                onWindowResize: () => {
                    setPosition(el);
                },
            });
        });

        function getProcessing(el) {
            el = $(el);
            if (el.length == 0) {
                return false;
            }

            const accordionItemHeading = el.find('.cms-accordion-item-heading');
            const elOffset = el[0].getBoundingClientRect();
            const fromTop = 100;
            const toTop = (el.outerHeight() - accordionItemHeading.outerHeight() - 900) * -1;
            let processing = 0;
            if (elOffset.top > fromTop) {
                processing = 0;
            } else if (elOffset.top <= fromTop && elOffset.top >= toTop) {
                if (elOffset.top >= 0) {
                    processing = (fromTop - elOffset.top) / (fromTop + Math.abs(toTop)) * 100;
                } else {
                    processing = (Math.abs(elOffset.top) + fromTop) / (fromTop + Math.abs(toTop)) * 100;
                }
            } else {
                processing = 100;
            }

            return processing;
        }

        function setPosition(el) {
            const accordionItems = el.find('.cms-accordion-item:not(.cms-accordion-item-heading)');
            const accordionItemHeading = el.find('.cms-accordion-item-heading');
            const processing = getProcessing(el);
            const avg = 100 / accordionItems.length;
            for (let i = 0; i < accordionItems.length; i++) {
                accordionItem = $(accordionItems[i]);
                const accordionItemParent = accordionItem.parent();
                const prevAccordionItem = $(accordionItems[i - 1]);
                let prevAccordionItemParent = prevAccordionItem.parent();
                if (i == 0) {
                    prevAccordionItemParent = accordionItemHeading;
                }
                if (processing >= avg * i && processing < avg * (i + 1)) {
                    const height = (processing - avg * i) / avg * maxHeight;
                    if (height > maxHeight) {
                        accordionItemParent.css('max-height', maxHeight);
                    } else {
                        accordionItemParent.css('max-height', height + minHeight);
                    }
                    prevAccordionItemParent.css('max-height', (1 - (processing - avg * i) / avg) * maxHeight);
                    prevAccordionItemParent.css('height', (1 - (processing - avg * i) / avg) * maxHeight);
                    if (maxHeight - height < 20) {
                        accordionItemParent.css('max-height', maxHeight);
                        prevAccordionItemParent.css('max-height', 0);
                        prevAccordionItemParent.css('height', 0);
                    }
                }
            }
        }
    };
    // Make sure you run this code under Elementor.
    $(window).on('elementor/frontend/init', function() {
        elementorFrontend.hooks.addAction('frontend/element_ready/cms_theme_accordion_sticky.default', WidgetCMSAccordionSticky);
    });
})(jQuery);