<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Repeater;
if (!function_exists('finanzia_widget_cms_video_player_register_controls')) {
    add_action('etc_widget_cms_video_player_register_controls', 'finanzia_widget_cms_video_player_register_controls', 10, 1);
    function finanzia_widget_cms_video_player_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_video_player/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_video_player/layout/2.webp'
                        ],
                        '-single-service' => [
                            'label' => esc_html__( 'Single Service', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_video_player/layout/single-service.webp'
                        ],
                        '-video-bg' => [
                            'label' => esc_html__( 'Background Video', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_video_player/layout/video-bg.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // video_player Section Start
        $widget->start_controls_section(
            'section_video_player',
            [
                'label' => esc_html__('Video Content', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'video_link',
                [
                    'label'              => esc_html__( 'Video URL', 'finanzia' ),
                    'subtitle'           => esc_html__('Video url from  YouTube/Vimeo/Dailymotion','finanzia'),
                    'type'               => Controls_Manager::TEXTAREA,
                    'default'            => 'https://www.youtube.com/watch?v=iYf3OgEdGmo',
                    'frontend_available' => true,
                    'label_block'        => true
                ]
            );
            /*$widget->add_control(
                'video_link_popup',
                [
                    'label'              => esc_html__( 'Video Popup URL', 'finanzia' ),
                    'subtitle'           => esc_html__('Video url from  YouTube/Vimeo/Dailymotion','finanzia'),
                    'description'        => esc_html__('Leave empty to use default Video URL above','finanzia'),
                    'type'               => Controls_Manager::TEXTAREA,
                    'default'            => 'https://www.youtube.com/watch?v=iYf3OgEdGmo',
                    'frontend_available' => true,
                    'label_block'        => true
                ]
            );*/
            $widget->add_control(
                'video_icon',
                [
                    'label'   => esc_html__( 'Video Icon', 'finanzia' ),
                    'type'    => Controls_Manager::ICONS,
                    'skin'    => 'inline',
                    'default' => [
                        'value'   => [
                            'url' => get_template_directory().'/assets/svgs/core/play.svg'
                        ],
                        'library' => 'svg'
                    ],
                    'condition' => [
                        'video_link!' => ''
                    ],
                    'label_block' => false
                ]
            );
            $widget->add_control(
                'video_text',
                [
                    'label'    => esc_html__( 'Video Text', 'finanzia' ),
                    'type'     => Controls_Manager::TEXTAREA,
                    'default'  => '',
                    'condition' => [
                        'layout!'     => ['1'],
                        'video_link!' => ''
                    ],
                    'label_block' => false
                ]
            );
            $widget->add_control(
                'image',
                [
                    'label'   => esc_html__( 'Video Banner', 'finanzia' ),
                    'type'    => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ],
                    'label_block' => false,
                    'condition'   => [
                        'layout!'     => ['1','3'],
                        'video_link!' => ''
                    ]
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'      => 'image',
                    'label'     => esc_html__('Banner Size','finanzia'),
                    'default'   => 'custom',
                    'condition' => [
                        'layout!'     => ['1','3'] ,
                        'video_link!' => '',
                        'image[url]!' => ''
                    ]
                ]
            );
        $widget->end_controls_section();
        
        // Content settings
        $widget->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );
            // Small Heading
            $widget->add_control(
                'smallheading_text',
                [
                    'label'       => esc_html__( 'Small Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is Small Heading',
                    'placeholder' => esc_html__( 'Enter your small heading', 'finanzia' ),
                    'label_block' => true,
                    'condition' => [
                        'layout' => ['5']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'smallheading_color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['5'],
                    'smallheading_text!' => ''
                ]
            ]);
            // Large Heading
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is Heading',
                    'placeholder' => esc_html__( 'Enter your heading', 'finanzia' ),
                    'label_block' => true,
                    'condition' => [
                        'layout' => ['1','3','5','-single-service']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'heading_color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['1','3','5','-single-service'],
                    'heading_text!' => ''
                ]
            ]);
            // Description Bold
            $widget->add_control(
                'desc_bold',
                [
                    'label'       => esc_html__( 'Description Bold', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true,
                    'condition' => [
                        'layout' => ['-single-service']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'desc_bold_color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['-single-service'],
                    'desc_bold!' => ''
                ]
            ]);
            // Description
            $widget->add_control(
                'description_text',
                [
                    'label'       => esc_html__( 'Description', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true,
                    'condition' => [
                        'layout' => ['3','-single-service']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'description_color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['3','5','-single-service'],
                    'description_text!' => ''
                ]
            ]);
            $widget->add_control(
                'description2_text',
                [
                    'label'       => esc_html__( 'Description #2', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true,
                    'condition' => [
                        'layout' => ['-single-service']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'description2_color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['-single-service'],
                    'description2_text!' => ''
                ]
            ]);
            // Link #1
            finanzia_elementor_link_settings($widget, [
                'name'    => 'link1_',
                'mode'    => 'btn',  
                'group'   => false,
                'condition' => [
                    'layout' => ['3']
                ],
                'color_label' => esc_html__('Button','finanzia')
            ]);
            // Link #2
            finanzia_elementor_link_settings($widget, [
                'name'    => 'link2_',
                'mode'    => 'btn',  
                'group'   => false,
                'condition' => [
                    'layout' => ['3']
                ],
                'color_label' => esc_html__('Button','finanzia')
            ]);
        $widget->end_controls_section();
        // Style Tab
        $widget->start_controls_section(
            'section_settings',
            [
                'label' => esc_html__('Video Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_SETTINGS,
                'condition' => [
                    'layout' => ['3','-video-bg']
                ]
            ]
        );
            $widget->add_control(
                'lightbox',
                [
                    'label'              => esc_html__( 'Lightbox', 'finanzia' ),
                    'type'               => Controls_Manager::SWITCHER,
                    //'label_off'        => esc_html__( 'Hide', 'finanzia' ),
                    //'label_on'         => esc_html__( 'Show', 'finanzia' ),
                    'default'            => 'yes',
                    'return_value'       => 'yes',
                    'frontend_available' => true
                ]
            );
            $widget->add_responsive_control(
                'video_height',
                [
                    'label'   => esc_html__( 'Video Height', 'finanzia' ),
                    'type'    => Controls_Manager::SLIDER,
                    'default' => [
                        'size' => '720',
                        'unit' => 'px' 
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .cms-evideo-playback' => 'height: {{SIZE}}{{UNIT}};',
                        //'{{WRAPPER}} .cms-evideo-playback iframe' => 'min-height: {{SIZE}}{{UNIT}};',
                    ],
                    'size_units' => [ 'px', 'vh'],
                    'range' => [
                        'px' => [
                            'min' => 100,
                            'max' => 2000,
                        ],
                        'vh' => [
                            'min' => 20,
                            'max' => 100,
                        ],
                    ],
                    'condition'          => [
                        'lightbox!' => 'yes'
                    ],
                ]
            );
            $widget->add_control(
                'autoplay',
                [
                    'label'              => esc_html__( 'Autoplay', 'finanzia' ),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                    'condition'          => [
                        'lightbox!' => 'yes'
                    ],
                ]
            );
            $widget->add_control(
                'mute',
                [
                    'label'              => esc_html__( 'Mute', 'finanzia' ),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                    'condition'          => [
                        'lightbox!' => 'yes'
                    ],
                ]
            );

            $widget->add_control(
                'loop',
                [
                    'label'              => esc_html__( 'Loop', 'finanzia' ),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => 'yes',
                    'frontend_available' => true,
                    'condition'          => [
                        'lightbox!' => 'yes'
                    ],
                ]
            );
            $widget->add_control(
                'controls',
                [
                    'label'              => esc_html__( 'Player Controls', 'finanzia' ),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => '',
                    'frontend_available' => true,
                    'condition'          => [
                        'lightbox!' => 'yes'
                    ],
                ]
            );
            $widget->add_control(
                'video_fit',
                [
                    'label'              => esc_html__( 'Video Fit?', 'finanzia' ),
                    'type'               => Controls_Manager::SWITCHER,
                    'default'            => '',
                    'frontend_available' => true,
                    'condition'          => [
                        'lightbox!' => 'yes'
                    ],
                ]
            );
            $widget->add_control(
                'video_scale',
                [
                    'label'              => esc_html__( 'Video Scale?', 'finanzia' ),
                    'type'               => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'max'  => 5,
                            'min'  => 0.5,
                            'step' => 0.01,
                        ]
                    ],
                    'selectors' => [
                        '{{WRAPPER}} iframe.yt-video' => 'scale:{{SIZE}};'
                    ],
                    'condition'          => [
                        'video_fit!' => 'yes'
                    ],
                ]
            );
        $widget->end_controls_section();
        // Style Tab
        $widget->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'stroke_color',
                'label'    => esc_html__( 'Stroke Color', 'finanzia' ),
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'stroke_color_hover',
                'label'    => esc_html__( 'Stroke Color', 'finanzia' ),
            ]);
            //
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'video_bg_color',
                'label'    => esc_html__( 'Video Background Color', 'finanzia' ),
                'condition'=> [
                    'layout!' => ['1']
                ] 
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'video_text_color',
                'label'    => esc_html__( 'Video Text Color', 'finanzia' ),
                'separator' => 'before',
                'condition'=> [
                    'layout!' => ['1']
                ]
            ]);
        $widget->end_controls_section();
    }
}
