<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Group_Control_Image_Size;

if (!function_exists('finanzia_widget_cms_theme_teams_register_controls')) {
    add_action('etc_widget_cms_theme_teams_register_controls', 'finanzia_widget_cms_theme_teams_register_controls', 10, 1);
    function finanzia_widget_cms_theme_teams_register_controls($widget)
    {
        // Layout Tab Start
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
        $widget->add_control(
            'layout',
            [
                'label'   => esc_html__( 'Templates', 'finanzia' ),
                'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                'options' => [
                    '1' => [
                        'label' => esc_html__( 'Layout 1', 'finanzia' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_theme_teams/layout/1.webp'
                    ],
                    '2' => [
                        'label' => esc_html__( 'Layout 2', 'finanzia' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_theme_teams/layout/2.webp'
                    ]
                ],
                'default'   => '1'
            ]
        );

        $widget->end_controls_section();
        // List Section Start
        $widget->start_controls_section(
            'list_section',
            [
                'label' => esc_html__('Teams Settings', 'finanzia'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
            $teams = new Repeater();
                $teams->add_control(
                    'image',
                    [
                        'label'   => esc_html__('Image', 'finanzia'),
                        'type'    => Controls_Manager::MEDIA,
                        'default' => [
                            'url' => Utils::get_placeholder_image_src(),
                        ],
                        'label_block' => false
                    ]
                );
                $teams->add_control(
                    'name',
                    [
                        'label'   => esc_html__('Name', 'finanzia'),
                        'type'    => Controls_Manager::TEXT,
                        'default' => esc_html__('Name', 'finanzia'),
                    ]
                );
                $teams->add_control(
                    'position',
                    [
                        'label'   => esc_html__('Position', 'finanzia'),
                        'type'    => Controls_Manager::TEXT,
                        'default' => esc_html__('Position', 'finanzia'),
                    ]
                );
                $teams->add_control(
                    'description',
                    [
                        'label'       => esc_html__('Description', 'finanzia'),
                        'type'        => Controls_Manager::TEXTAREA,
                        'default'     => '',
                        'label_block' => false 
                    ]
                );
                $teams->add_control(
                    'link',
                    [
                        'label'       => esc_html__( 'Link', 'finanzia' ),
                        'type'        => Controls_Manager::URL,
                        'default' => [
                            'url'         => '',
                            'is_external' => true,
                            'nofollow'    => true,
                        ],
                        'separator' => 'after',
                        'classes'   => 'cms-eseparator'
                    ]
                );
                // Social
                for ($i = 1; $i <= 4; $i++) {
                    $args = [
                        'label'       => esc_html__( "Social Icon", 'finanzia' ).' #'.$i,
                        'type'        => Controls_Manager::ICONS,
                        'skin'        => 'inline',
                        'label_block' => false,
                        'separator'   => 'before',
                        'classes'     => 'cms-eseparator'
                    ];
                    $args_link = [
                        'label'       => esc_html__( "Social Link", 'finanzia' ), //{$i}
                        'type'        => Controls_Manager::URL,
                        'placeholder' => 'https://your-link.com',
                        'options'     => [ 'url', 'is_external', 'nofollow' ]
                    ];
                    if($i == 1){
                        $args['default'] = [
                            'value'   => [
                                'url' => get_template_directory().'/assets/svgs/core/facebook.svg'
                            ],
                            'library' => 'svg'
                        ];
                        $args_link['default'] = [
                            'url'         => 'https://facebook.com/cmssuperheroes',
                            'is_external' => true,
                            'nofollow'    => true,
                        ];
                    }
                    elseif($i == 2){
                        $args['default'] = [
                            'value'   => [
                                'url' => get_template_directory().'/assets/svgs/core/twitter.svg'
                            ],
                            'library' => 'svg'
                        ];
                        $args_link['default'] = [
                            'url'         => 'https://twitter.com/',
                            'is_external' => true,
                            'nofollow'    => true,
                        ];
                    }
                    elseif($i == 3){
                        $args['default'] = [
                            'value'   => [
                                'url' => get_template_directory().'/assets/svgs/core/instagram.svg'
                            ],
                            'library' => 'svg'
                        ];
                        $args_link['default'] = [
                            'url'         => 'https://instagram.com/',
                            'is_external' => true,
                            'nofollow'    => true,
                        ];
                    }
                    elseif($i == 4){
                        $args['default'] = [
                            'value'   => [
                                'url' => get_template_directory().'/assets/svgs/core/linkedin.svg'
                            ],
                            'library' => 'svg'
                        ];
                        $args_link['default'] = [
                            'url'         => 'https://linkedin.com/',
                            'is_external' => true,
                            'nofollow'    => true,
                        ];
                    }
                    $teams->add_control(
                        "social_icon_{$i}",
                        $args
                    );
                    $teams->add_control(
                        "social_link_{$i}",
                        $args_link
                    );
                }
            $widget->add_control(
                'teams',
                [
                    'label'   => esc_html__('Add member', 'finanzia'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $teams->get_controls(),
                    'default' => [
                        [
                            'image' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'name' => esc_html__('Name', 'finanzia'),
                            'position' => esc_html__('Position', 'finanzia')
                        ],
                        [
                            'image' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'name' => esc_html__('Name', 'finanzia'),
                            'position' => esc_html__('Position', 'finanzia')
                        ],
                        [
                            'image' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'name' => esc_html__('Name', 'finanzia'),
                            'position' => esc_html__('Position', 'finanzia')
                        ],
                    ],
                    'title_field' => '{{{ name }}}',
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'image',
                    'label'   => esc_html__('Avatar Size','finanzia'),
                    'default' => 'custom'
                ]
            );
        $widget->end_controls_section();
        // Heading
        $widget->start_controls_section(
            'cta_section',
            [
                'label'     => esc_html__('Heading Settings', 'finanzia'),
                'tab'       => Controls_Manager::TAB_CONTENT
            ]
        );  
            // Title
            $widget->add_control(
                'small_title',
                [
                    'label'       => esc_html__( 'Small Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is Small Heading',
                    'placeholder' => esc_html__( 'Enter your small title', 'finanzia' )
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'smalltitle_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'small_title!' => ''
                ]
            ]);
            // Title
            $widget->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is Heading',
                    'placeholder' => esc_html__( 'Enter your title', 'finanzia' )
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'title_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'title!' => ''
                ]
            ]);
            // Description   
            $widget->add_control(
                'text',
                [
                    'label'       => esc_html__( 'Description', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' )
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'text_color',
                'label'     => esc_html__( 'Description Color', 'finanzia' ),
                'condition' => [
                    'text!'  => ''
                ]
            ]);
            // Button
            finanzia_elementor_link_settings($widget, [
                'name'        => 'btn_',
                'mode'        => 'btn',
                'color_label' => esc_html__('Button', 'finanzia'),
                'text'        => 'Click Here #1',
                'group'       => false,
                'label'       => esc_html__('Button Settings','finanzia'),
                'condition'   => [
                    'show_cta' => 'yes',
                ]
            ]);
            finanzia_elementor_link_settings($widget, [
                'name'        => 'btn2_',
                'mode'        => 'btn',
                'color_label' => esc_html__('Button', 'finanzia'),
                'text'        => 'Click Here #2',
                'group'       => false,
                'label'       => esc_html__('Button Settings','finanzia'),
                'condition'   => [
                    'show_cta' => 'yes',
                ]
            ]);
        $widget->end_controls_section();
    }
}