<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
if (!function_exists('finanzia_widget_cms_theme_service_scroll_register_controls')) {
    add_action('etc_widget_cms_theme_service_scroll_register_controls', 'finanzia_widget_cms_theme_service_scroll_register_controls', 10, 1);
    function finanzia_widget_cms_theme_service_scroll_register_controls($widget)
    {
        // Layout Settings
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia' ),
                'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__('Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_theme_service_scroll/layout/1.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();

        // Post term options
        $post_term_options = etc_get_grid_term_options('cms-service');

        // Content Tab Start

        // Source Section Start
        $widget->start_controls_section(
            'source_section',
            [
                'label' => esc_html__('Source', 'finanzia'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'source',
            [
                'label' => esc_html__('Select Categories', 'finanzia'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $post_term_options,
            ]
        );
        $widget->add_control(
            'orderby',
            [
                'label'   => esc_html__('Order By', 'finanzia'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date'   => esc_html__('Date', 'finanzia'),
                    'ID'     => esc_html__('ID', 'finanzia'),
                    'author' => esc_html__('Author', 'finanzia'),
                    'title'  => esc_html__('Title', 'finanzia'),
                    'rand'   => esc_html__('Random', 'finanzia'),
                ],
            ]
        );
        $widget->add_control(
            'order',
            [
                'label'   => esc_html__('Sort Order', 'finanzia'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'desc' => esc_html__('Descending', 'finanzia'),
                    'asc'  => esc_html__('Ascending', 'finanzia'),
                ],
            ]
        );
        $widget->add_control(
            'limit',
            [
                'label'   => esc_html__('Total items', 'finanzia'),
                'type'    => Controls_Manager::NUMBER,
                'default' => 3,
            ]
        );
        $widget->end_controls_section();
        // Heading Section Start
        $widget->start_controls_section(
            'heading_section',
            [
                'label' => esc_html__('Heading Settings', 'finanzia'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'smallheading_text',
                [
                    'label'       => esc_html__( 'Small Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true,
                    'condition'   => [
                        'layout'  => ['1']  
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'smallheading_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout'             => ['1'],
                    'smallheading_text!' => ''
                ]
            ]);
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is the heading',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true,
                    'condition'   => [
                        'layout'  => ['1']  
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'heading_color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout'        => ['1'],
                    'heading_text!' => ''
                ]
            ]);
            // Description #1
            $widget->add_control(
                'desc',
                [
                    'label'       => esc_html__( 'Description #1', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Lorem Ipsum is simply dummy text of the printing and typesetting story. Lorem Ipsum has been the story standard dummy text ever since', 
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'rows'        => 10,
                    'show_label'  => true,
                    'condition' => [
                        'layout' => ['1']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'desc_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['1'],
                    'desc!'  => ''
                ]
            ]);
            // Description #2
            $widget->add_control(
                'desc2',
                [
                    'label'       => esc_html__( 'Description #2', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour', 
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'rows'        => 10,
                    'show_label'  => true,
                    'condition' => [
                        'layout' => ['1']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'desc2_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['1'],
                    'desc2!' => ''
                ]
            ]);
            // Button #1
            finanzia_elementor_link_settings($widget, [
                'name'        => 'link1_',
                'mode'        => 'btn',
                'group'       => false,
                'label'       => esc_html__('Button Settings', 'finanzia'),
                'color_label' => esc_html__('Button','finanzia'),
                'condition'   => [
                    'layout' => ['1']
                ]
            ]);
        $widget->end_controls_section();
        // Display Section Start
        $widget->start_controls_section(
            'display_section',
            [
                'label' => esc_html__('Content Display', 'finanzia'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(), 
                [
                    'name'      => 'thumbnail',
                    'default'   => 'medium',
                    'separator' => 'after'
                ]
            );
            $widget->add_control(
                'num_line',
                [
                    'label'       => esc_html__('Excerpt Length', 'finanzia'),
                    'description' => esc_html__('Enter number of line you want to show, max is 10', 'finanzia'),
                    'type'        => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 10,
                        ]
                    ],
                    /*'default' => [
                        'size' => '',
                    ],*/
                    'separator'   => 'before',
                ]
            );

            $widget->add_control(
                'readmore_text',
                [
                    'label'       => esc_html__('Readmore Text', 'finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'placeholder' => esc_html__('Read More','finanzia'),
                ]
            );
        $widget->end_controls_section();
    }
}
