<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
if (!function_exists('finanzia_widget_cms_text_scroll_register_controls')) {
    add_action('etc_widget_cms_text_scroll_register_controls', 'finanzia_widget_cms_text_scroll_register_controls', 10, 1);
    function finanzia_widget_cms_text_scroll_register_controls($widget)
    {
        // Layout Settings
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_text_scroll/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_text_scroll/layout/2.webp'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_text_scroll/layout/4.webp'
                        ],
                        '5' => [
                            'label' => esc_html__( 'Layout 5', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_text_scroll/layout/5.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Text Settings
        $widget->start_controls_section(
            'text_secsion',
            [
                'label' => esc_html__('Text Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );
            $text = new Repeater();
            $text->add_control(
                'text',
                [
                    'label'       => esc_html__('Text', 'finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Your Text'
                ]
            );
            $text->add_control(
                'banner1',
                [
                    'label'       => esc_html__('Banner', 'finanzia'),
                    'type'        => Controls_Manager::MEDIA,
                    //'default'     => []
                ]
            );
            // Start List
            $widget->add_control(
                'cms_texts',
                [
                    'label'   => esc_html__('Scoll Texts', 'finanzia'),
                    'type'    => \Elementor\Controls_Manager::REPEATER,
                    'fields'  => $text->get_controls(),
                    'default' => [
                        [
                            'text'   => 'Evaluation,'
                        ],
                        [
                            'text'   => 'Fabrication,'
                        ],
                        [
                            'text'   => 'and Continued Patient Care.'
                        ]
                    ],
                    'title_field' => '{{{ text }}}',
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'banner1',
                    'label'   => esc_html__('Banner Size','finanzia'),
                    'default' => 'full',
                    //'exclude' => ['thumbnail','trp-custom-language-flag','woocommerce_gallery_thumbnail']
                ]
            );
        $widget->end_controls_section();
        // style
        $widget->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Style', 'finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'text_color',
                'label'    => esc_html__( 'Text Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-text-scroll' => 'color: {{VALUE}};',
                ]
            ]);
            $widget->add_control(
                'shape',
                [
                    'label'       => esc_html__('Shape', 'finanzia'),
                    'type'        => Controls_Manager::MEDIA,
                    //'default'     => []
                ]
            );
        $widget->end_controls_section();
    }
}