<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;
if (!function_exists('finanzia_widget_cms_text_animate_register_controls')) {
    add_action('etc_widget_cms_text_animate_register_controls', 'finanzia_widget_cms_text_animate_register_controls', 10, 1);
    function finanzia_widget_cms_text_animate_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_text_animate/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_text_animate/layout/2.webp'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_text_animate/layout/3.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Heading Content
        $widget->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Content Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            // Small Text
            $widget->add_control(
                'small_text',
                [
                    'label'       => esc_html__( 'Small Text', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Lorem Ipsum is simply dummy',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true,
                    'condition' => [
                        'layout' => ['2']
                    ]
                ]
            );
            $widget->add_control(
                'small_animate_type',
                [
                    'label' => esc_html__('Animate Type','finanzia'),
                    'type'  => Controls_Manager::SELECT,
                    'default' => 'cms-split--text',
                    'options' => [
                        'cms-split--text'                => esc_html__('Animate Split Text', 'finanzia'),
                        'cms-scroll-zoom-out-in'         => esc_html__('Zoom Out In', 'finanzia'),
                        'cms-scroll-slide-bottom-to-top' => esc_html__('Slide Bottom to Top', 'finanzia')
                    ],
                    'condition' => [
                        'layout' => ['2'],
                        'small_text!' => ''
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'small_text_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['2'],
                    'small_text!' => ''
                ]
            ]);
            $widget->add_control(
                'small_animated_color',
                [
                    'label'       => esc_html__( 'Animated Color', 'finanzia' ),
                    'type'        => Controls_Manager::COLOR,
                    'label_block' => false,
                    'condition' => [
                        'layout' => ['2'],
                        'small_text!' => ''
                    ]
                ]
            );
            // Text
            $widget->add_control(
                'text',
                [
                    'label'       => esc_html__( 'Text', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Lorem Ipsum is simply dummy text of the printing and typesetting story. Lorem Ipsum has been the storys standard dummy text ever since the 1500s, when an unknown printer took a galley of type and scrambled it to make a type specimen book.',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true,
                    'condition' => [
                        'layout' => ['1', '2']
                    ]
                ]
            );
            $widget->add_control(
                'text_animate_type',
                [
                    'label' => esc_html__('Animate Type','finanzia'),
                    'type'  => Controls_Manager::SELECT,
                    'default' => '',
                    'options' => [
                        ''                               => esc_html__('Default', 'finanzia'),
                        'cms-split--text'                => esc_html__('Animate Split Text', 'finanzia'),
                        'cms-scroll-zoom-out-in'         => esc_html__('Zoom Out In', 'finanzia'),
                        'cms-scroll-slide-bottom-to-top' => esc_html__('Slide Bottom to Top', 'finanzia')
                    ],
                    'condition' => [
                        'layout' => ['1', '2','3'],
                        'text!' => ''
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'text_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'text!' => ''
                ]
            ]);
            $widget->add_control(
                'animated_color',
                [
                    'label'       => esc_html__( 'Animated Color', 'finanzia' ),
                    'type'        => Controls_Manager::COLOR,
                    'label_block' => false
                ]
            );
            // Layout 3
            $content3 = new Repeater();
                $content3->add_control(
                    'text',
                    [
                        'label'       => esc_html__( 'Text', 'finanzia' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'default'     => 'Lorem Ipsum is simply dummy text of the printing and typesetting story.',
                        'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                        'label_block' => true,
                    ]
                );
            $widget->add_control(
                'contents',
                [
                    'label'   => esc_html__('Contents', 'finanzia'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $content3->get_controls(),
                    'default' => [
                        [
                            'text' => '#1 Lorem Ipsum is simply dummy text of the printing and typesetting story.'
                        ],
                        [
                            'text' => '#2 Lorem Ipsum is simply dummy text of the printing and typesetting story.'
                        ],
                        [
                            'text' => '#3 Lorem Ipsum is simply dummy text of the printing and typesetting story.'
                        ]
                    ],
                    'title_field' => '{{{ text }}}',
                    'label_block' => true,
                    'condition' => [
                        'layout' => ['3']
                    ]
                ]
            );
        $widget->end_controls_section();
        // Banner
        $widget->start_controls_section(
            'section_background',
            [
                'label' => esc_html__('Background Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['3']
                ]
            ]
        );
            $widget->add_control(
                'bg_img',
                [
                    'label'   => esc_html__( 'Background Image', 'finanzia' ),
                    'type'    => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
