<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Repeater;
if (!function_exists('finanzia_widget_cms_testimonials_register_controls')) {
    add_action('etc_widget_cms_testimonials_register_controls', 'finanzia_widget_cms_testimonials_register_controls', 10, 1);
    function finanzia_widget_cms_testimonials_register_controls($widget)
    {
        // Layout Tab Start
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
        $widget->add_control(
            'layout_mode',
            [
                'label'   => esc_html__( 'Layout Mode', 'finanzia' ),
                'type'    => Controls_Manager::SELECT,
                'options' => [
                    'grid'     => esc_html__('Grid','finanzia'),
                    'carousel' => esc_html__('Carousel', 'finanzia')
                ],
                'default' => 'carousel',
                'condition' => [
                    'layout!' => ['-stories']
                ]
            ]
        );
        $widget->add_control(
            'layout',
            [
                'label'   => esc_html__( 'Templates', 'finanzia' ),
                'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                'default' => '1',
                'options' => [
                    '1' => [
                        'label' => esc_html__( 'Layout 1', 'finanzia' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_testimonials/layout/1.webp'
                    ],
                    '2' => [
                        'label' => esc_html__( 'Layout 2', 'finanzia' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_testimonials/layout/2.webp'
                    ],
                    '3' => [
                        'label' => esc_html__( 'Layout 3', 'finanzia' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_testimonials/layout/3.webp'
                    ]
                ]
            ]
        );
        $widget->end_controls_section();
        // List
        $widget->start_controls_section(
            'list_section',
            [
                'label' => esc_html__('Testimonials', 'finanzia'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
            // Heading
            $widget->add_control(
                'eheading',
                [
                    'label'     => esc_html__('Heading', 'finanzia'),
                    'type'      => Controls_Manager::TEXTAREA,
                    'default'   => 'Your Heading',
                    'condition' => [
                        'layout' => ['1','2']
                    ]
                ]
            );
            // Testimonials
            $repeater = new Repeater();
            $repeater->add_control(
                'image',
                [
                    'label'   => esc_html__('Avatar', 'finanzia'),
                    'type'    => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                    'label_block' => false
                ]
            );
            $repeater->add_control(
                'name',
                [
                    'label' => esc_html__('Name', 'finanzia'),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('Author Name', 'finanzia'),
                ]
            );
            $repeater->add_control(
                'position',
                [
                    'label' => esc_html__('Position', 'finanzia'),
                    'type' => Controls_Manager::TEXT,
                    'default' => esc_html__('Position', 'finanzia'),
                ]
            );
            $repeater->add_control(
                'description',
                [
                    'label' => esc_html__('Description', 'finanzia'),
                    'type' => Controls_Manager::TEXTAREA,
                    'default' => esc_html__('Testimonial Description', 'finanzia'),
                ]
            );
            $widget->add_control(
                'testimonials',
                [
                    'label' => esc_html__('Testimonials', 'finanzia'),
                    'type' => \Elementor\Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'image' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'name'        => esc_html__('Testimonial Name', 'finanzia'),
                            'position'    => esc_html__('Testimonial Position', 'finanzia'),
                            'description' => esc_html__('#1 Testimonial Description. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', 'finanzia'),
                        ],
                        [
                            'image' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'name'        => esc_html__('Testimonial Name #2', 'finanzia'),
                            'position'    => esc_html__('Testimonial Position #2', 'finanzia'),
                            'description' => esc_html__('#2 Testimonial Description. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', 'finanzia'),
                        ],
                        [
                            'image' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'name'        => esc_html__('Testimonial Name #3', 'finanzia'),
                            'position'    => esc_html__('Testimonial Position #3', 'finanzia'),
                            'description' => esc_html__('#3 Testimonial Description. It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.', 'finanzia'),
                        ],
                    ],
                    'title_field' => '{{{ name }}}',
                    'label_block' => true
                ]
            );
        $widget->end_controls_section();
        finanzia_elementor_icon_image_settings($widget, [
            'label'      => esc_html__('Parallax Icon/Image', 'finanzia'),
            'tab'        => Controls_Manager::TAB_SETTINGS,
            'label_type' => esc_html__('Type','finanzia'),
            'type'       => '',
            'condition'  => [
                'layout' => '1'
            ]
        ]);
        // Carousel Settings
        finanzia_elementor_carousel_settings($widget, [
            'condition' =>[
                'layout_mode' => 'carousel'
            ],
            'slides_to_show'   => 1,
            'slides_to_scroll' => 1 
        ]);
        // Grid Settings
        finanzia_elementor_grid_columns_settings($widget, [
            'condition' => [
                'layout_mode' => 'grid'
            ],
            'divider' => false,
            'gap'     => true  
        ]);
        // Style
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'desc_color',
                'label'    => esc_html__( 'Description Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'author_color',
                'label'    => esc_html__( 'Author Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'author_pos_color',
                'label'    => esc_html__( 'Position Color', 'finanzia' )
            ]);
            // Arrows
            finanzia_elementor_colors_opts($widget,[
                'name'        => 'arrow_color',
                'label'       => esc_html__( 'Arrow Color', 'finanzia' ),
                'description' => esc_html__('Arrows Settings', 'finanzia'),
                'classes'     => 'cms-description-as-label',
                'condition'   =>[
                    'layout_mode' => 'carousel'
                ]  
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'        => 'arrow_bg_color',
                'label'       => esc_html__( 'Arrow Background Color', 'finanzia' ),
                'condition'   =>[
                    'layout_mode' => 'carousel'
                ]  
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'        => 'arrow_hover_color',
                'label'       => esc_html__( 'Arrow hover Color', 'finanzia' ),
                'condition'   =>[
                    'layout_mode' => 'carousel'
                ]  
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'        => 'arrow_bg_hover_color',
                'label'       => esc_html__( 'Arrow Background Hover Color', 'finanzia' ),
                'condition'   =>[
                    'layout_mode' => 'carousel'
                ]  
            ]);
        $widget->end_controls_section();
    }
}
