<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Group_Control_Image_Size;

if (!function_exists('finanzia_widget_cms_teams_register_controls')) {
    add_action('etc_widget_cms_teams_register_controls', 'finanzia_widget_cms_teams_register_controls', 10, 1);
    function finanzia_widget_cms_teams_register_controls($widget)
    {
        // Layout Tab Start
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
        $widget->add_control(
            'layout_mode',
            [
                'label' => esc_html__( 'Layout Mode', 'finanzia' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'carousel' => esc_html__( 'Carousel', 'finanzia' ),
                    'grid'     => esc_html__( 'Grid', 'finanzia' ),
                ],
                'default' => 'carousel',
            ]
        );
        $widget->add_control(
            'layout',
            [
                'label'   => esc_html__( 'Templates', 'finanzia' ),
                'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                'options' => [
                    '1' => [
                        'label' => esc_html__( 'Layout 1', 'finanzia' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_teams/layout/1.webp'
                    ],
                    '2' => [
                        'label' => esc_html__( 'Layout 2', 'finanzia' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_teams/layout/2.webp'
                    ],
                    '3' => [
                        'label' => esc_html__( 'Layout 3', 'finanzia' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_teams/layout/3.webp'
                    ]
                ],
                'default'   => '1'
            ]
        );

        $widget->end_controls_section();
        // List Section Start
        $widget->start_controls_section(
            'list_section',
            [
                'label' => esc_html__('Teams Settings', 'finanzia'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
            $repeater = new Repeater();
            $repeater->add_control(
                'image',
                [
                    'label'   => esc_html__('Image', 'finanzia'),
                    'type'    => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src(),
                    ],
                ]
            );
            $repeater->add_control(
                'name',
                [
                    'label'   => esc_html__('Name', 'finanzia'),
                    'type'    => Controls_Manager::TEXT,
                    'default' => esc_html__('Name', 'finanzia'),
                ]
            );
            $repeater->add_control(
                'position',
                [
                    'label'   => esc_html__('Position', 'finanzia'),
                    'type'    => Controls_Manager::TEXT,
                    'default' => esc_html__('Position', 'finanzia'),
                ]
            );
            $repeater->add_control(
                'description',
                [
                    'label'       => esc_html__('Description', 'finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => '',
                    'label_block' => true,
                    'class'       => 'fuckc cccc',  
                    'label_class'       => 'fuckc cccc'  
                ]
            );
            $repeater->add_control(
                'link',
                [
                    'label'       => esc_html__( 'Link', 'finanzia' ),
                    'type'        => Controls_Manager::URL,
                    'default' => [
                        'url' => '',
                        'is_external' => true,
                        'nofollow' => true,
                    ],
                    'separator' => 'after',
                ]
            );
            for ($i = 1; $i <= 4; $i++) {
                $args = [
                    'label'       => esc_html__( "Social Icon", 'finanzia' ), //{$i}
                    'type'        => Controls_Manager::ICONS,
                    'skin'        => 'inline',
                    'label_block' => false,
                ];
                $args_link = [
                    'label'       => esc_html__( "Social Link", 'finanzia' ), //{$i}
                    'type'        => \Elementor\Controls_Manager::URL,
                    'placeholder' => 'https://your-link.com',
                    'options'     => [ 'url', 'is_external', 'nofollow' ],
                    'separator' => 'after',
                ];
                if($i == 1){
                    $args['default'] = [
                        'value'   => [
                            'url' => get_template_directory().'/assets/svgs/core/facebook.svg'
                        ],
                        'library' => 'svg'
                    ];
                    $args_link['default'] = [
                        'url'         => 'https://facebook.com/cmssuperheroes',
                        'is_external' => true,
                        'nofollow'    => true,
                    ];
                }
                elseif($i == 2){
                    $args['default'] = [
                        'value'   => [
                            'url' => get_template_directory().'/assets/svgs/core/twitter.svg'
                        ],
                        'library' => 'svg'
                    ];
                    $args_link['default'] = [
                        'url'         => 'https://twitter.com/',
                        'is_external' => true,
                        'nofollow'    => true,
                    ];
                }
                elseif($i == 3){
                    $args['default'] = [
                        'value'   => [
                            'url' => get_template_directory().'/assets/svgs/core/instagram.svg'
                        ],
                        'library' => 'svg'
                    ];
                    $args_link['default'] = [
                        'url'         => 'https://instagram.com/',
                        'is_external' => true,
                        'nofollow'    => true,
                    ];
                }
                elseif($i == 4){
                    $args['default'] = [
                        'value'   => [
                            'url' => get_template_directory().'/assets/svgs/core/linkedin.svg'
                        ],
                        'library' => 'svg'
                    ];
                    $args_link['default'] = [
                        'url'         => 'https://linkedin.com/',
                        'is_external' => true,
                        'nofollow'    => true,
                    ];
                }
                $repeater->add_control(
                    "social_icon_{$i}",
                    $args
                );
                $repeater->add_control(
                    "social_link_{$i}",
                    $args_link
                );
            }
            $widget->add_control(
                'teams',
                [
                    'label' => esc_html__('Add member', 'finanzia'),
                    'type' => \Elementor\Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'image' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'name' => esc_html__('Name', 'finanzia'),
                            'position' => esc_html__('Position', 'finanzia'),
                            'link' => [
                                'url' => '#',
                                'is_external' => true,
                                'nofollow' => true,
                            ],
                        ],
                        [
                            'image' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'name' => esc_html__('Name', 'finanzia'),
                            'position' => esc_html__('Position', 'finanzia'),
                            'link' => [
                                'url' => '#',
                                'is_external' => true,
                                'nofollow' => true,
                            ],
                        ],
                        [
                            'image' => [
                                'url' => Utils::get_placeholder_image_src(),
                            ],
                            'name' => esc_html__('Name', 'finanzia'),
                            'position' => esc_html__('Position', 'finanzia'),
                            'link' => [
                                'url' => '#',
                                'is_external' => true,
                                'nofollow' => true,
                            ],
                        ],
                    ],
                    'title_field' => '{{{ name }}}',
                ]
            );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'image',
                    'label'   => esc_html__('Avatar Size','finanzia'),
                    'default' => 'custom'
                ]
            );
        $widget->end_controls_section();
        // Call To Action
        $widget->start_controls_section(
            'cta_section',
            [
                'label'     => esc_html__('CTA Settings', 'finanzia'),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['3']
                ]
            ]
        );  
            // Show / Hide
            $widget->add_control(
                'show_cta',
                [
                    'label'       => esc_html__( 'Show CTA?', 'finanzia' ),
                    'type'        => Controls_Manager::SWITCHER,
                    'default'     => 'no'
                ]
            );
            // Title
            $widget->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is Heading',
                    'placeholder' => esc_html__( 'Enter your title', 'finanzia' ),
                    'condition'   => [
                        'show_cta' => 'yes'
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'title_color',
                'label'     => esc_html__( 'Title Color', 'finanzia' ),
                'condition' => [
                    'show_cta' => 'yes',
                    'title!' => ''
                ]
            ]);
            // Description   
            $widget->add_control(
                'text',
                [
                    'label'       => esc_html__( 'Description', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'condition'   => [
                        'show_cta' => 'yes',
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'text_color',
                'label'     => esc_html__( 'Description Color', 'finanzia' ),
                'condition' => [
                    'show_cta' => 'yes',
                    'text!'  => ''
                ]
            ]);
            // Button
            finanzia_elementor_link_settings($widget, [
                'name'  => 'btn_',
                'text'  => 'Join our Team',
                'group' => false,
                'label' => esc_html__('Button Settings','finanzia'),
                'condition' => [
                    'show_cta' => 'yes',
                ]
            ]);
            // Email
            finanzia_elementor_link_settings($widget, [
                'name'  => 'email_',
                'group' => false,
                'text'  => 'Finanzia@cmsheroes.com',
                'label' => esc_html__('Email Settings','finanzia'),
                'condition' => [
                    'show_cta' => 'yes',
                ]
            ]);
        $widget->end_controls_section();
        
        // Carousel Settings
        finanzia_elementor_carousel_settings($widget,[
            'condition' => [
                'layout_mode' => ['carousel']
            ]
        ]);
        // Grid Settings
        $widget->start_controls_section(
            'grid_section',
            [
                'label'     => esc_html__('Grid Settings', 'finanzia'),
                'tab'       => Controls_Manager::TAB_SETTINGS,
                'condition' => [
                    'layout_mode' => 'grid'
                ]
            ]
        );
            $widget->add_responsive_control(
                'col',
                [
                    'label'        => esc_html__('Columns', 'finanzia'),
                    'type'         => Controls_Manager::SELECT,
                    'default'      => '',
                    'default_args' => [
                        'tablet' => '',
                        'mobile' => ''
                    ],
                    'options' => [
                        '' => esc_html__('Default', 'finanzia'),
                        '1' => '1',
                        '2' => '2',
                        '3' => '3',
                        '4' => '4',
                        '6' => '6',
                    ],
                    'separator' => 'after'
                ]
            );
        $widget->end_controls_section();
    }
}