<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Utils;
// use for tab content
use Elementor\Modules\NestedElements\Base\Widget_Nested_Base;
use Elementor\Modules\NestedElements\Controls\Control_Nested_Repeater;

if (!function_exists('wastia_widget_cms_tabs_register_controls')) {
    add_action('etc_widget_cms_tabs_register_controls', 'wastia_widget_cms_tabs_register_controls', 10, 1);
    function wastia_widget_cms_tabs_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_tabs/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_tabs/layout/2.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Tab Content
        $widget->start_controls_section(
            'section_content',
            [
                'label' => esc_html__('Tab Contents', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'active_tab',
                [
                    'label'     => esc_html__( 'Active Tab', 'finanzia' ),
                    'type'      => Controls_Manager::NUMBER,
                    'default'   => 1,
                    'min'       => 0,
                    'max'       => 50,
                    'separator' => 'after',
                ]
            );
            $repeater = new Repeater();
                $repeater->add_control(
                    'tab_title',
                    [
                        'label'       => esc_html__( 'Tab Title', 'finanzia' ),
                        'default'     => esc_html__( 'Title', 'finanzia' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'label_block' => true,
                    ]
                );
                $repeater->add_control(
                    'tab_title_icon',
                    [
                        'label'       => esc_html__( 'Title Icon', 'finanzia' ),
                        'type'        => Controls_Manager::ICONS,
                        'skin'        => 'inline',
                        'label_block' => false,
                        'condition'   => [
                            'tab_title!' => ''
                        ]
                    ]
                );
                // Tab Content
                $repeater->add_control(
                    'tab_content_banner',
                    [
                        'label'       => esc_html__( 'Content Banner', 'finanzia' ),
                        'type'        => Controls_Manager::MEDIA,
                        'default'     => [
                            'url' => Utils::get_placeholder_image_src()
                        ],
                        'label_block' => false,
                        'condition'   => [
                            'tab_title!' => ''
                        ],
                        'separator' => 'before',
                        'classes'   => 'cms-eseparator'
                    ]
                );
                $repeater->add_control(
                    'tab_content_icon',
                    [
                        'label'       => esc_html__( 'Content Icon', 'finanzia' ),
                        'type'        => Controls_Manager::ICONS,
                        'skin'        => 'inline',
                        'label_block' => false,
                        'condition'   => [
                            'tab_title!' => ''
                        ]
                    ]
                );
                $repeater->add_control(
                    'tab_content_title',
                    [
                        'label'       => esc_html__( 'Content Title', 'finanzia' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'default'     => 'Enter Your Title',
                        'label_block' => true,
                        'condition'   => [
                            'tab_title!' => ''
                        ]
                    ]
                );
                $repeater->add_control(
                    'tab_content_desc',
                    [
                        'label'       => esc_html__( 'Content Description', 'finanzia' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'default'     => 'Enter your Description. Lorem Ipsum is simply dummy text of the printing and typesetting story. Lorem Ipsum has been the story standard dummy text',
                        'label_block' => true,
                        'condition'   => [
                            'tab_title!' => ''
                        ]
                    ]
                );
                // Feature
                $repeater->add_control(
                    'tab_content_feature',
                    [
                        'label'       => esc_html__('Features', 'finanzia'),
                        'type'        => Elementor_Theme_Core::REPEATER_CONTROL,
                        'label_block' => true,
                        'separator'   => 'before',
                        'controls'    => array(
                            array(
                                'name'    => 'title',
                                'label'   => esc_html__('Feature Text', 'finanzia' ),
                                'type'    => Controls_Manager::TEXTAREA,
                                'default' => 'Your feature text'
                            )
                        )
                    ]
                );
                // Link #1
                finanzia_elementor_link_settings($repeater, [
                    'name'    => 'link1_',
                    'group'   => false,
                    'color'   => false,
                    'type' => [
                        'cms-service' => esc_html__('Service', 'finanzia'),
                        'cms-industry' => esc_html__('Industry', 'finanzia')
                    ]
                ]);
            
            $widget->add_control(
                'cms_tabs',
                [
                    'label'       => esc_html__('Tabs List', 'finanzia'),
                    'label_block' => true,
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater->get_controls(),
                    'default'     => [
                        [
                            'tab_title'         => 'Your Tabs #1',
                            'tab_content_title' => 'Your Title #1',
                            'tab_content_desc'  => 'Your Description. Lorem Ipsum is simply dummy text of the printing and typesetting story. Lorem Ipsum has been the story standard dummy text'
                        ],
                        [
                            'tab_title'         => 'Your Tabs #2',
                            'tab_content_title' => 'Your Title #2',
                            'tab_content_desc'  => 'Your Description. Lorem Ipsum is simply dummy text of the printing and typesetting story. Lorem Ipsum has been the story standard dummy text',
                        ]
                    ],
                    'title_field' => '{{{ tab_title }}}',
                    'condition'   => [
                        'layout' => ['1']
                    ]
                ]
            );
            // Layout 2
            $repeater2 = new Repeater();
                $repeater2->add_control(
                    'tab_title',
                    [
                        'label'       => esc_html__( 'Tab Title', 'finanzia' ),
                        'default'     => esc_html__( 'Title', 'finanzia' ),
                        'type'        => Controls_Manager::TEXTAREA,
                        'label_block' => false,
                    ]
                );
                $repeater2->add_control(
                    'tab_title_icon',
                    [
                        'label'       => esc_html__( 'Title Icon', 'finanzia' ),
                        'type'        => Controls_Manager::ICONS,
                        'skin'        => 'inline',
                        'label_block' => false,
                        'condition'   => [
                            'tab_title!' => ''
                        ]
                    ]
                );
                $repeater2->add_control(
                    'tab_content_banner',
                    [
                        'label'       => esc_html__( 'Banner', 'finanzia' ),
                        'type'        => Controls_Manager::MEDIA,
                        'default'     => [
                            'url' => Utils::get_placeholder_image_src()
                        ],
                        'label_block' => false,
                        'condition'   => [
                            'tab_title!' => ''
                        ],
                        'separator' => 'before',
                        'classes'   => 'cms-eseparator'
                    ]
                );
                $repeater2->add_control(
                    'tab_content_feature',
                    [
                        'label'       => esc_html__('Features', 'finanzia'),
                        'type'        => Elementor_Theme_Core::REPEATER_CONTROL,
                        'label_block' => true,
                        'separator'   => 'before',
                        'controls'    => array(
                            array(
                                'name'    => 'title',
                                'label'   => esc_html__('Feature Text', 'finanzia' ),
                                'type'    => Controls_Manager::TEXTAREA,
                                'default' => 'Your feature text'
                            )
                        )
                    ]
                );
            $widget->add_control(
                'cms_tabs2',
                [
                    'label'       => esc_html__('Tabs List', 'finanzia'),
                    'label_block' => true,
                    'type'        => Controls_Manager::REPEATER,
                    'fields'      => $repeater2->get_controls(),
                    'default'     => [
                        [
                            'tab_title'         => 'Your Tabs #1'
                           
                        ],
                        [
                            'tab_title'         => 'Your Tabs #2',
                        ],
                        [
                            'tab_title'         => 'Your Tabs #3',
                        ]
                    ],
                    'title_field' => '{{{ tab_title }}}',
                    'condition'   => [
                        'layout' => ['2']
                    ]
                ]
            );
        $widget->end_controls_section();
        // Style
        $widget->start_controls_section(
            'section_style',
            [
                'label' => esc_html__('Tab Style', 'finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'tab_title_color',
                'label' => esc_html__( 'Tab Title Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'tab_title_color_hover',
                'label' => esc_html__( 'Tab Title Color Hover', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'tab_title_bg_color',
                'label' => esc_html__( 'Tab Title Background Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'tab_title_bg_color_hover',
                'label' => esc_html__( 'Tab Title Background Color Hover', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'content_title_color',
                'label'     => esc_html__( 'Content Title Color', 'finanzia' ),
                'separator' => 'before'
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'content_text_color',
                'label' => esc_html__( 'Content Text Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'link_text_color',
                'label'     => esc_html__( 'Link Text Color', 'finanzia' ),
                'separator' => 'before'
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'link_bg_color',
                'label' => esc_html__( 'Link Background Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'link_text_color_hover',
                'label' => esc_html__( 'Link Text Hover Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'link_bg_color_hover',
                'label' => esc_html__( 'Link Background Hover Color', 'finanzia' )
            ]);
        $widget->end_controls_section();
    }
}
