<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
if (!function_exists('finanzia_widget_cms_service_carousel_register_controls')) {
    add_action('etc_widget_cms_service_carousel_register_controls', 'finanzia_widget_cms_service_carousel_register_controls', 10, 1);
    function finanzia_widget_cms_service_carousel_register_controls($widget)
    {
        // Post term options
        $post_term_options = etc_get_grid_term_options('cms-service');
        // Layout Settings
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia' ),
                'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__('Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '2',
                    'options' => finanzia_elementor_post_layouts()
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start
        // Source Section Start
        $widget->start_controls_section(
            'source_section',
            [
                'label' => esc_html__('Source', 'finanzia'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'source',
            [
                'label' => esc_html__('Select Categories', 'finanzia'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $post_term_options,
            ]
        );
        $widget->add_control(
            'orderby',
            [
                'label' => esc_html__('Order By', 'finanzia'),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date' => esc_html__('Date', 'finanzia'),
                    'ID' => esc_html__('ID', 'finanzia'),
                    'author' => esc_html__('Author', 'finanzia'),
                    'title' => esc_html__('Title', 'finanzia'),
                    'rand' => esc_html__('Random', 'finanzia'),
                ],
            ]
        );
        $widget->add_control(
            'order',
            [
                'label' => esc_html__('Sort Order', 'finanzia'),
                'type' => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'desc' => esc_html__('Descending', 'finanzia'),
                    'asc' => esc_html__('Ascending', 'finanzia'),
                ],
            ]
        );
        $widget->add_control(
            'limit',
            [
                'label' => esc_html__('Total items', 'finanzia'),
                'type' => Controls_Manager::NUMBER,
                'default' => '6',
            ]
        );
        $widget->end_controls_section();
        // Source Section End
        // Display Section Start
        $widget->start_controls_section(
            'display_section',
            [
                'label' => esc_html__('Content Display', 'finanzia'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'thumbnail',
                    'default' => 'medium',
                ]
            );
            $widget->add_control(
                'num_line',
                [
                    'label'       => esc_html__('Excerpt Length', 'finanzia'),
                    'description' => esc_html__('Enter number of line you want to show, max is 10', 'finanzia'),
                    'type'        => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 10,
                        ]
                    ],
                    'default' => [
                        'size' => '',
                    ],
                    'separator'   => 'before',
                ]
            );

            $widget->add_control(
                'readmore_text',
                [
                    'label'       => esc_html__('Readmore Text', 'finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'placeholder' => esc_html__('Read More','finanzia'),
                ]
            );
        $widget->end_controls_section();
        // Display Section End
        // Heading Section Start
        $widget->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('Heading Content', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['1']
                ]
            ]
        );
            $widget->add_control(
                'smallheading_text',
                [
                    'label'       => esc_html__( 'Small Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true,
                    'separator'   => 'after'
                ]
            );
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is the heading',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true
                ]
            );
        $widget->end_controls_section();
        // Carousel Section Start
        finanzia_elementor_carousel_settings($widget);
        // Heading style
        $widget->start_controls_section(
            'heading_section_style',
            [
                'label' => esc_html__('Heading Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout' => ['1']
                ]
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'smallheading_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-smallheading' => 'color: {{VALUE}};',
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'heading_color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-heading, {{WRAPPER}} .cms-heading a' => 'color: {{VALUE}};',
                ]
            ]);
        $widget->end_controls_section();
    }
}
