<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;
if (!function_exists('finanzia_widget_cms_quickcontact_register_controls')) {
    add_action('etc_widget_cms_quickcontact_register_controls', 'finanzia_widget_cms_quickcontact_register_controls', 10, 1);
    function finanzia_widget_cms_quickcontact_register_controls($widget)
    {
        // Layout Settings
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__( 'Layout', 'finanzia' ),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_responsive_control(
                'align',
                [
                    'label'        => esc_html__( 'Alignment', 'finanzia' ),
                    'type'         => Controls_Manager::CHOOSE,
                    'options'      => [
                        'start'    => [
                            'title' => esc_html__( 'Left', 'finanzia' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center'  => [
                            'title' => esc_html__( 'Center', 'finanzia' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'end'   => [
                            'title' => esc_html__( 'Right', 'finanzia' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__( 'Justified', 'finanzia' ),
                            'icon'  => 'eicon-text-align-justify',
                        ],
                    ]
                ]
            );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_quickcontact/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_quickcontact/layout/2.webp'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_quickcontact/layout/3.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();

        // Title Section Start
        $widget->start_controls_section(
            'title_section',
            [
                'label'     => esc_html__('Title', 'finanzia'),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['1','3']
                ]
            ]
        );
            $widget->add_control(
                'title',
                [
    				'label'       => '',
    				'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Quick Contact',  
    				'placeholder' => esc_html__('Enter your title', 'finanzia')
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'title_color',
                'label'     => esc_html__( 'Title Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-title' => 'color: {{VALUE}};',
                ]
            ]);
        $widget->end_controls_section();
        // Desc Section Start
        $widget->start_controls_section(
            'desc_section',
            [
                'label' => esc_html__('Description', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['3']
                ]
            ]
        );
            $widget->add_control(
                'desc',
                [
                    'label'       => '',
                    'default'     => 'If you have any questions or need help, feel free to contact with our team.',
                    'type'        => Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__('Enter your text', 'finanzia')
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'desc_color',
                'label'     => esc_html__( 'Description Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-desc' => 'color: {{VALUE}};',
                ]
            ]);
        $widget->end_controls_section();
        
        // Email Section Start
        $widget->start_controls_section(
            'email_section',
            [
                'label' => esc_html__('Email', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['1','2','3']
                ]
            ]
        );
            $widget->add_control(
                'email_title',
                [
                    'label'       => esc_html__('Email Title','finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Email:'  
                ]
            );
            $widget->add_control(
                'email',
                [
    				'label'       => '',
    				'type'        => Controls_Manager::TEXTAREA,
    				'default'     => 'Finanzia@cmsheroes.com',
                    'placeholder' => 'Finanzia@cmsheroes.com'
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'icon_email_color',
                'label'     => esc_html__( 'Icon Email Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'email_color',
                'label'     => esc_html__( 'Email Color', 'finanzia' )
            ]);
             finanzia_elementor_colors_opts($widget,[
                'name'     => 'email_color_hover',
                'label'     => esc_html__( 'Email Hover Color', 'finanzia' )
            ]);
        $widget->end_controls_section();
        // Phone Section Start
        $widget->start_controls_section(
            'phone_section',
            [
                'label' => esc_html__('Phone Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'layout'  => ['1','2','3']
                ]
            ]
        );
            $widget->add_control(
                'phone_title',
                [
                    'label'       => esc_html__('Phone Title','finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Phone:',
                    'label_block' => false
                ]
            );
            $widget->add_control(
                'phone',
                [
    				'label'       => esc_html__('Phone Number','finanzia'),
    				'type'        => Controls_Manager::TEXT,
    				'default'     => '02 01061245741',
                    'placeholder' => '02 01061245741'
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'icon_phone_color',
                'label' => esc_html__('Icon Phone Color', 'finanzia')
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'phone_color',
                'label' => esc_html__('Phone Color', 'finanzia')
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'phone_color_hover',
                'label' => esc_html__('Phone Hover Color', 'finanzia')
            ]);
        $widget->end_controls_section();
        // Time Section Start
        $widget->start_controls_section(
            'time_section',
            [
                'label' => esc_html__('Time Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition'=> [
                    'layout' => ['3']
                ]
            ]
        );
            $widget->add_control(
                'time_title',
                [
                    'label'       => esc_html__('Time Title','finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Mon - Fri:',
                    'label_block' => false
                ]
            );
            $widget->add_control(
                'time',
                [
                    'label'       => esc_html__('Time','finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '8AM - 5PM',
                    'label_block' => false
                ]
            );
            $widget->add_control(
                'exclude_time',
                [
                    'label'       => esc_html__('Exclude Time','finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '*Excludes Holidays',
                    'label_block' => false,
                    'condition'   => [
                        'layout' => ['3']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'icon_time_color',
                'label' => esc_html__('Icon Time Color', 'finanzia'),
                'selector' => [
                    '{{WRAPPER}} .cms-time .cms-icon-color' => 'color: {{VALUE}};',
                ],
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'time_color',
                'label' => esc_html__('Time Color', 'finanzia'),
                'selector' => [
                    '{{WRAPPER}} .cms-time' => 'color: {{VALUE}};',
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'time_color_hover',
                'label' => esc_html__('Time Hover Color', 'finanzia'),
                'selector' => [
                    '{{WRAPPER}} .cms-time:hover' => 'color: {{VALUE}};',
                ]
            ]);
        $widget->end_controls_section();
        // Address Section Start
        $widget->start_controls_section(
            'address_section',
            [
                'label' => esc_html__('Address', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['1','2','3']
                ]
            ]
        );
            $widget->add_control(
                'address_title',
                [
                    'label'       => esc_html__('Address Title','finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Location',
                    'label_block' => false  
                ]
            );
            $widget->add_control(
                'address',
                [
                    'label'       => '',
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => '2307 Beverley Rd Brooklyn, New York 11226 United States.',
                    'placeholder' => esc_html__('Enter your address', 'finanzia')
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'icon_address_color',
                'label'     => esc_html__( 'Icon Address Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'address_color',
                'label'     => esc_html__( 'Address Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'address_color_hover',
                'label'     => esc_html__( 'Address Hover Color', 'finanzia' )
            ]);
        $widget->end_controls_section();
        // icon Section Start
        $widget->start_controls_section(
            'section_icon',
            [
                'label' => esc_html__('Social Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['1','2','3']
                ]
            ]
        );
            $widget->add_control(
                'social_title',
                [
                    'label'       => esc_html__('Social Title','finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Social Media',
                    'label_block' => false  
                ]
            );
            $repeater = new Repeater();

            $repeater->add_control(
                'social_icon',
                [
                    'label'   => esc_html__( 'Icon', 'finanzia' ),
                    'type'    => Controls_Manager::ICONS,
                    'default' => [
                        'value'   => 'fab fa-facebook',
                        'library' => 'fa-brand',
                    ],
                    'fa4compatibility' => 'icon_active',
                ]
            );

            $repeater->add_control(
                'title',
                [
                    'label'   => esc_html__( 'Title', 'finanzia' ),
                    'type'    => Controls_Manager::TEXT,
                    'default' => 'Social Title',
                ]
            );

            $repeater->add_control(
                'link',
                [
                    'label'   => esc_html__( 'Link', 'finanzia' ),
                    'type'    => Controls_Manager::URL,
                    'default' => [
                        'is_external' => 'true'
                    ],
                    'placeholder' => esc_html__( 'https://your-link.com', 'finanzia' ),
                ]
            );

            $repeater->add_control(
                'item_icon_color',
                [
                    'label'   => esc_html__( 'Color', 'finanzia' ),
                    'type'    => Controls_Manager::SELECT,
                    'default' => 'default',
                    'options' => [
                        'default' => esc_html__( 'Official Color', 'finanzia' ),
                        'custom'  => esc_html__( 'Custom', 'finanzia' ),
                    ],
                ]
            );

            $repeater->add_control(
                'item_icon_primary_color',
                [
                    'label' => esc_html__( 'Background Color', 'finanzia' ),
                    'type' => Controls_Manager::COLOR,
                    'condition' => [
                        'item_icon_color' => 'custom',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} {{CURRENT_ITEM}}' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $repeater->add_control(
                'item_icon_secondary_color',
                [
                    'label' => esc_html__( 'Icon Color', 'finanzia' ),
                    'type' => Controls_Manager::COLOR,
                    'condition' => [
                        'item_icon_color' => 'custom',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} {{CURRENT_ITEM}} .cms-icon' => 'color: {{VALUE}};',
                        '{{WRAPPER}} {{CURRENT_ITEM}} .cms-icon svg' => 'fill: {{VALUE}};',
                    ],
                ]
            );

            $widget->add_control(
                'icons',
                [
                    'label' => esc_html__('Icons', 'finanzia'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'social_icon' => [
                                'value'   => [
                                    'url' => get_template_directory().'/assets/svgs/core/facebook.svg'
                                ],
                                'library' => 'svg',
                            ],
                            'title' => 'Facebook',
                            'link' => [
                                'is_external' => true,
                                'url' => 'https://facebook.com'
                            ]
                        ],
                        [
                            'social_icon' => [
                                'value'   => [
                                    'url' => get_template_directory().'/assets/svgs/core/twitter.svg'
                                ],
                                'library' => 'svg',
                            ],
                            'title' => 'Twitter',
                            'link' => [
                                'is_external' => true,
                                'url' => 'https://twitter.com'
                            ]
                        ],
                        [
                            'social_icon' => [
                                'value'   => [
                                    'url' => get_template_directory().'/assets/svgs/core/linkedin.svg'
                                ],
                                'library' => 'svg',
                            ],
                            'title' => 'LinkedIn',
                                'link' => [
                                    'is_external' => true,
                                    'url' => 'https://linkedin.com'
                                ]
                        ],
                    ],
                    //'title_field' => '{{{ "<i class=\"" + social_icon.value + "\"></i>" + " " + title }}}',
                    'title_field' => '{{{ elementor.helpers.renderIcon( this, social_icon, {}, "i", "panel" ) || \'<i class="{{ social_icon.value }}" aria-hidden="true"></i>\' }}} {{{ title }}}',
                ]
            );
            // Social Style
            $widget->add_control(
                'gap',
                [
                    'label'        => esc_html__( 'Gap', 'finanzia' ),
                    'type'         => Controls_Manager::SELECT,
                    'options'      => ['' => esc_html__('Default','finanzia'), 'none'=>0, 10=>10,15=>15,20=>20,30=>30,40=>40],
                    'default'      => '' 
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'icon_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-social-item .cms-icon' => 'color: {{VALUE}};',
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'icon_hover_color',
                'label'     => esc_html__( 'Hover Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-social-item:hover .cms-icon' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .cms-social-item:hover svg' => 'fill: {{VALUE}};',
                ]
            ]);
            $widget->add_control(
                'hover_animation',
                [
                    'label' => esc_html__( 'Hover Animation', 'finanzia' ),
                    'type' => Controls_Manager::HOVER_ANIMATION,
                ]
            );
            $widget->add_control(
                'show_title',
                [
                    'label'        => esc_html__( 'Show Title', 'finanzia' ),
                    'type'         => \Elementor\Controls_Manager::SWITCHER,
                    'label_on'     => esc_html__( 'Show', 'finanzia' ),
                    'label_off'    => esc_html__( 'Hide', 'finanzia' ),
                    'return_value' => 'yes',
                    'default'      => 'no',
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'social_title_color',
                'label'     => esc_html__( 'Title Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-social-item .cms-stitle' => 'color: {{VALUE}};'
                ],
                'condition' => [
                    'show_title' => 'yes',
                ]
            ]);
            finanzia_add_hidden_device_controls($widget, [
                'prefix'    => 'social_title_',
                'condition' => [
                    'show_title' => 'yes',
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'bg_color',
                'label'     => esc_html__( 'Background Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'bg_hover_color',
                'label'     => esc_html__( 'Background Hover Color', 'finanzia' )
            ]);
        $widget->end_controls_section();
        // Style Section
        $widget->start_controls_section(
            'show_hide_title_section',
            [
                'label' => esc_html__('Title Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
	        finanzia_add_hidden_device_controls($widget, [
                'prefix' => 'title_',
            ]);
        $widget->end_controls_section();
        $widget->start_controls_section(
            'show_hide_text_section',
            [
                'label'     => esc_html__('Text Settings', 'finanzia'),
                'tab'       => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout' => ['2']
                ]
            ]
        );
            finanzia_add_hidden_device_controls($widget, [
                'prefix' => 'text_',
            ]);
        $widget->end_controls_section(); 
    }
}
