<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;

if (!function_exists('finanzia_widget_cms_progress_register_controls')) {
    add_action('etc_widget_cms_progress_register_controls', 'finanzia_widget_cms_progress_register_controls', 10, 1);
    function finanzia_widget_cms_progress_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_progress/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_progress/layout/2.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Progressbar Section Start
        $widget->start_controls_section(
                'section_progressbar',
                [
                    'label' => esc_html__('Progressbar Content', 'finanzia'),
                    'tab'   => Controls_Manager::TAB_CONTENT
                ]
            );

            $progressbar = new Repeater();

            $progressbar->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXT,
                    'placeholder' => esc_html__( 'Enter your title', 'finanzia' ),
                    'default'     => 'Your Title',
                    'label_block' => true,
                ]
            );
            $progressbar->add_control(
                'percent',
                [
                    'label'       => esc_html__( 'Value', 'finanzia' ),
                    'type'        => Controls_Manager::SLIDER,
                    'default'     => [
                        'size' => 80
                    ],
                    'label_block' => true,
                ]
            );
            $progressbar->add_control(
                'prefix',
                [
                    'label'       => esc_html__( 'Prefix', 'finanzia' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '',
                    'label_block' => false,
                ]
            );
            $progressbar->add_control(
                'suffix',
                [
                    'label'       => esc_html__( 'Suffix', 'finanzia' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '%',
                    'label_block' => false,
                ]
            );
            $progressbar->add_control(
                'height',
                [
                    'label'       => esc_html__( 'Progress bar height', 'finanzia' ),
                    'type'        => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 6,
                            'max' => 500,
                        ]
                    ],
                    'default'     => [
                        'unit' => 'px',
                    ],
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($progressbar,[
                'name'  => 'color',
                'label' => esc_html__('Color', 'finanzia' )
            ]);
            $widget->add_control(
                'progressbar_list',
                [
                    'label'   => esc_html__('List', 'finanzia'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $progressbar->get_controls(),
                    'default' => [
                        [
                            'title'   => 'Your Title #1',
                            'percent' => [
                                'size' => 95
                            ],
                            'height' => [
                                'size' => 319
                            ],
                            'color' => 'primary-lighten'
                        ],
                        [
                            'title'   => 'Your Title #2',
                            'percent' => [
                                'size' => 88
                            ],
                            'height'  => [
                                'size' => 298
                            ],
                            'color' => 'green'
                        ],
                        [
                            'title'   => 'Your Title #3',
                            'percent' => [
                                'size' => 99
                            ],
                            'height' => [
                                'size' => 334
                            ],
                            'color' => 'light-green'
                        ],
                        [
                            'title'   => 'Your Title #4',
                            'percent' => [
                                'size' => 85
                            ],
                            'height' => [
                                'size' => 262
                            ],
                            'color' => 'purple'
                        ]
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $widget->end_controls_section();
        // Grid Column
        finanzia_elementor_grid_columns_settings($widget, [
            'condition' => ['layout' => '2'],
            'tab'       => Controls_Manager::TAB_CONTENT
        ]);
    }
}
