<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;

if (!function_exists('finanzia_widget_cms_process_slider_register_controls')) {
    add_action('etc_widget_cms_process_slider_register_controls', 'finanzia_widget_cms_process_slider_register_controls', 10, 1);
    function finanzia_widget_cms_process_slider_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_process_slider/layout/1.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Process Section Start
        $widget->start_controls_section(
                'section_process',
                [
                    'label' => esc_html__('Process Content', 'finanzia'),
                    'tab'   => Controls_Manager::TAB_CONTENT
                ]
            );

            $process = new Repeater();
            // Title
            $process->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Process Title', 'finanzia' ),
                    'default'     => esc_html__( 'Process Title', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            $process->add_control(
                'banner',
                [
                    'label'   => esc_html__( 'Banner', 'finanzia' ),
                    'type'    => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ],
                    'selectors' => [
                        '{{WRAPPER}} {{CURRENT_ITEM}}' => '--cms-bg-lazyload:url({{URL}})'
                    ],
                ]
            );
            // Process Lists
            $widget->add_control(
                'process_list',
                [
                    'label'   => esc_html__('Process List', 'finanzia'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $process->get_controls(),
                    'default' => [
                        [
                            'title' => 'Process title #1',
                        ],
                        [
                            'title' => 'Process title #2',
                        ],
                        [
                            'title' => 'Process title #3',
                        ],
                    ],
                    'title_field' => '{{{ title }}}'
                ]
            );
            // // Style
            // $widget->add_control(
            //     'banner',
            //     [
            //         'label'   => esc_html__( 'Banner', 'finanzia' ),
            //         'type'    => Controls_Manager::MEDIA,
            //         'default' => [
            //             'url' => Utils::get_placeholder_image_src()
            //         ],
            //         'selectors' => [
            //             '{{WRAPPER}}' => '--cms-bg-lazyload:url({{URL}});'
            //         ]
            //     ]
            // );
            finanzia_elementor_colors_opts($widget,[
                'name'  => 'ptitle_color',
                'label' => esc_html__( 'Title Color', 'finanzia' ),
                'separator' => 'before'
            ]);
        $widget->end_controls_section();
    }
}
