<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
if (!function_exists('finanzia_widget_cms_page_title_register_controls')) {
    add_action('etc_widget_cms_page_title_register_controls', 'finanzia_widget_cms_page_title_register_controls', 10, 1);
    function finanzia_widget_cms_page_title_register_controls($widget)
    {
        // Layout Tab Start

        // Layout Section Start
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control('header_transparent', [
                'label'              => esc_html__('Header Transparent', 'finanzia'),
                'type'               => Controls_Manager::SWITCHER,
                'default'            => '',
                'prefix_class'       => 'cms-eptitle-header-transparent-',
                'description'        => esc_html__('Add more top space when have Header Transparent','finanzia')   
            ]);
            $widget->add_responsive_control(
                'content_width',
                [
                    'label' => esc_html__('Content Width', 'finanzia'),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min'  => 510, 
                            'max'  => 1280,
                            'step' => 10
                        ]
                    ]
                ]
            );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__('Templates', 'finanzia'),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '-blog',
                    'options' => [
                        '-blog' => [
                            'label' => esc_html__('Blog', 'finanzia'),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_page_title/layout/blog.webp'
                        ],
                        '1' => [
                            'label' => esc_html__('Layout 1', 'finanzia'),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_page_title/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__('Layout 2', 'finanzia'),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_page_title/layout/2.webp'
                        ],
                        '3' => [
                            'label' => esc_html__('Layout 3', 'finanzia'),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_page_title/layout/3.webp'
                        ],
                        '4' => [
                            'label' => esc_html__('Layout 4', 'finanzia'),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_page_title/layout/4.webp'
                        ],
                        '5' => [
                            'label' => esc_html__('Layout 5', 'finanzia'),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_page_title/layout/5.webp'
                        ],
                        '6' => [
                            'label' => esc_html__('Layout 6', 'finanzia'),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_page_title/layout/6.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Icon Section Start
        $widget->start_controls_section(
            'page_title_section',
            [
                'label' => esc_html__('Content Setting', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'small_title',
            [
                'label'       => esc_html__('Small Title', 'finanzia'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => '',
                'placeholder' => esc_html__('Enter your small title', 'finanzia'),
                'label_block' => true,
                'condition' => [
                    'layout' => ['1','2','3','4','6','-blog']
                ]
            ]
        );
        $widget->add_control(
            'title',
            [
                'label'       => esc_html__('Title', 'finanzia'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => '',
                'placeholder' => esc_html__('Enter your title', 'finanzia'),
                'label_block' => true,
                'condition'   => [
                    'layout!' => ['5']
                ]
            ]
        );
        $widget->add_control(
            'description',
            [
                'label'       => esc_html__('Description', 'finanzia'),
                'type'        => Controls_Manager::TEXTAREA,
                'default'     => '',
                'placeholder' => esc_html__('Enter your description', 'finanzia'),
                'rows'        => 10,
                'show_label'  => true,
                'condition'   => [
                    'layout' => ['1','2','3']
                ]
            ]
        );
        $widget->end_controls_section();
        // Button
        $widget->start_controls_section(
            'section_btn',
            [
                'label' => esc_html__('Button Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'layout' => ['1','2','3']
                ]
            ]
        );
            finanzia_elementor_link_settings($widget, [
                'name'        => 'link1_',
                'mode'        => 'btn',
                'group'       => false,
                'label'       => esc_html__('Button #1 Settings', 'finanzia'),
                'color_label' => esc_html__('Button', 'finanzia')
            ]);
            // Button #2
            finanzia_elementor_link_settings($widget, [
                'name'        => 'link2_',
                'mode'        => 'btn',
                'group'       => false,
                'label'       => esc_html__('Button #2 Settings', 'finanzia'),
                'color_label' => esc_html__('Button', 'finanzia')
            ]);
        $widget->end_controls_section();
        // Video
        $widget->start_controls_section(
            'section_video',
            [
                'label' => esc_html__('Video Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'layout' => ['1','2','3']
                ]
            ]
        );
            $widget->add_control(
                'video_link',
                [
                    'label'       => esc_html__( 'Video URL', 'finanzia' ),
                    'subtitle'    => esc_html__('Video url from  YouTube/Vimeo/Dailymotion','finanzia'),
                    'description' => 'https://www.youtube.com/watch?v=iYf3OgEdGmo',
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'default'     => '',
                    'label_block' => true
                ]
            );
            $widget->add_control(
                'video_icon',
                [
                    'label'   => esc_html__( 'Video Icon', 'finanzia' ),
                    'type'    => \Elementor\Controls_Manager::ICONS,
                    'skin'    => 'inline',
                    'default' => [
                        'library' => 'svg',
                        'value'   => [
                            'id' => '',
                            'url' => get_template_directory().'/assets/svgs/core/play.svg'
                        ]
                    ],
                    'condition' => [
                        'video_link!' => ''
                    ],
                    'label_block' => false
                ]
            );
            $widget->add_control(
                'video_text',
                [
                    'label'    => esc_html__( 'Video Text', 'finanzia' ),
                    'type'     => \Elementor\Controls_Manager::TEXTAREA,
                    'default'  => '',
                    'condition' => [
                        'video_link!' => ''
                    ],
                    'label_block' => false
                ]
            );
        $widget->end_controls_section();
        // Background 
        $widget->start_controls_section(
            'section_background',
            [
                'label' => esc_html__('Background Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );
            $widget->add_control(
                'bg_image',
                [
                    'label'       => esc_html__('Background Image', 'finanzia'),
                    'type'        => Controls_Manager::MEDIA,
                    'default'     => [
                        'url' => Utils::get_placeholder_image_src()
                    ]
                ]
            );
            $widget->add_control(
                'bg_overlay',
                [
                    'label'        => esc_html__('Gradient Overlay', 'finanzia'),
                    'type'         => Controls_Manager::SELECT,
                    'options'      => finanzia_elementor_gradient_opts(),
                    'default'      => 'dark-above-img2',
                    'condition'    => [
                        'layout!' => ['-blog']
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
