<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
if(!function_exists('finanzia_widget_cms_newsletter_register_controls')){
	add_action('etc_widget_cms_newsletter_register_controls', 'finanzia_widget_cms_newsletter_register_controls', 10, 1);
	function finanzia_widget_cms_newsletter_register_controls($widget){
		// Layout Settings
		$widget->start_controls_section(
			'layout_section',
			[
				'label' => esc_html__('Layout', 'finanzia' ),
                'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
			]
		);
            $widget->add_responsive_control(
                'align',
                [
                    'label'        => esc_html__( 'Alignment', 'finanzia' ),
                    'type'         => Controls_Manager::CHOOSE,
                    'options'      => [
                        'start'    => [
                            'title' => esc_html__( 'Left', 'finanzia' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center'  => [
                            'title' => esc_html__( 'Center', 'finanzia' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'end'   => [
                            'title' => esc_html__( 'Right', 'finanzia' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__( 'Justified', 'finanzia' ),
                            'icon'  => 'eicon-text-align-justify',
                        ],
                    ]
                ]
            );
			$widget->add_control(
				'layout',
                [
					'label'   => esc_html__('Templates', 'finanzia' ),
					'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
					'default' => '1',
					'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_newsletter/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_newsletter/layout/2.webp'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_newsletter/layout/3.webp'
                        ],
                        '-custom' => [
                            'label' => esc_html__( 'HTML Forms', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_newsletter/layout/custom.webp'
                        ]
                    ]
	            ]
			);
		$widget->end_controls_section();
        // Heading Setting
        $widget->start_controls_section(
            'title_section',
            [
                'label' => esc_html__('Heading', 'finanzia' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'title',
                [
                    'label'       => esc_html__('Title', 'finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Newsletter',
                    'placeholder' => esc_html__('Enter your text', 'finanzia'),
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'title_color',
                'label'     => esc_html__( 'Title Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-title' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'title!' => ''
                ]
            ]);
            $widget->add_control(
                'description',
                [
                    'label'       => esc_html__( 'Description', 'finanzia' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Description', 'finanzia' ),
                    'label_block' => true,
                    'default'     => 'Sign up for story alerts, deals, news and insights from us.'
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'desc_color',
                'label'     => esc_html__( 'Description Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-desc' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'description!' => ''
                ]
            ]);
        $widget->end_controls_section();
        // Form Settings
        $widget->start_controls_section(
        	'form_section',
            [
            	'label'    => esc_html__( 'Form Settings', 'finanzia' ),
                'tab'      => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'layout_form',
                [
                    'label' => esc_html__('Newsletter Form Layout', 'finanzia'),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        ''       => esc_html__('Default', 'finanzia'),
                        'custom' => esc_html__('Custom', 'finanzia')
                    ]
                ]
            );

            $widget->add_control(
                'form_id',
                [
                    'label' => esc_html__('Choose Form ID', 'finanzia'),
                    'type'  => Controls_Manager::SELECT,
                    'options' => [
                        '1' => '1',
                        '2' => '2',
                        '3' => '3',
                        '4' => '4',
                        '5' => '5',
                        '6' => '6',
                        '7' => '7',
                        '8' => '8',
                        '9' => '9',
                        '10' => '10'
                    ],
                    'default' => '1',
                    'condition' => [
                        'layout_form' => 'custom'
                    ],
                    'description' => sprintf(esc_html__('%sClick Here%s to add your custom form. More about its, please read %s Document here%s','finanzia'), '<a href="' . esc_url( admin_url( 'admin.php?page=newsletter_subscription_forms' ) ) . '" target="_blank">','</a>', '<a href="'.esc_url('https://www.thenewsletterplugin.com/documentation/subscription/subscription-form-shortcodes/').'"  target="_blank">','</a>')
                ]
            );

        	$widget->add_control(
        		'show_name',
                [
                	'label'       => esc_html__( 'Show Field Name', 'finanzia' ),
                    'type'        => \Elementor\Controls_Manager::SELECT,
                    'options'     => [
                        ''    =>  esc_html__('Default','finanzia'),
                        'yes' =>  esc_html__('Yes','finanzia'),
                        'no'  =>  esc_html__('No','finanzia'),
                    ],
                    'condition' => [
                        'layout_form!' => 'custom'
                    ]
                ]
        	);
        	$widget->add_control(
        		'name_text',
                [
                	'label'       => esc_html__( 'Name Text', 'finanzia' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'placeholder' => esc_html__( 'Enter placeholder text', 'finanzia' ),
                    'label_block' => true,
                    'condition'   => [
                        'show_name' => ['','yes']
                    ],
                    'condition' => [
                        'layout_form' => ''
                    ]
                ]
        	);
        	$widget->add_control(
        		'email_text',
                [
                	'label'       => esc_html__( 'Email Text', 'finanzia' ),
                    'type'        => \Elementor\Controls_Manager::TEXT,
                    'placeholder' => esc_html__( 'Enter placeholder text', 'finanzia' ),
                    'label_block' => true,
                    'condition' => [
                        'layout_form' => ''
                    ]
                ]
        	);
        	$widget->add_control(
        		'button_text',
                [
                	'label'       => esc_html__( 'Button Text', 'finanzia' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__( 'Enter button text', 'finanzia' ),
                    'label_block' => true,
                    'condition' => [
                        'layout_form' => ''
                    ]
                ]
        	);
            // By subscribing, you accept the Privacy Policy
            $widget->add_control(
                'privacy_policy_page',
                [
                    'label'        => esc_html__('Privacy Policy Page', 'finanzia'),
                    'type'         => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type'    => [
                    'page'
                    ],
                    'return_value' => 'ID',
                    'multiple'     => false,
                    'condition'    => [
                        'layout' => ['1','2'],
                    ],
                    'label_block' => true,
                    'separator'   => 'before'
                ]
            );
            $widget->add_control(
                'privacy_policy_text',
                [
                    'label'       => esc_html__( 'Privacy Policy Description', 'finanzia' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'placeholder' => esc_html__('By subscribing, you accept the', 'finanzia' ),
                    'default'     => 'By subscribing, you accept the',
                    'condition' => [
                        'privacy_policy_page!' => '',
                        'layout' => ['1','2']
                    ]
                ]
            );
            $widget->add_control(
                'privacy_policy_link_text',
                [
                    'label'       => esc_html__( 'Privacy Policy Text', 'finanzia' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'description' => esc_html__('Default is title of page', 'finanzia' ),
                    'placeholder' => esc_html__('Privacy Policy', 'finanzia' ),
                    'condition' => [
                        'privacy_policy_page!' => '',
                        'layout' => ['1','2']
                    ]
                ]
            );
        $widget->end_controls_section();
	}
}
?>