<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;
if (!function_exists('finanzia_widget_cms_lists_register_controls')) {
    add_action('etc_widget_cms_lists_register_controls', 'finanzia_widget_cms_lists_register_controls', 10, 1);
    function finanzia_widget_cms_lists_register_controls($widget)
    {
        // Layout Tab Start
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab' => Controls_Manager::TAB_LAYOUT,
            ]
        );
        $widget->add_control(
            'layout',
            [
                'label'   => esc_html__( 'Templates', 'finanzia' ),
                'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                'default' => '1',
                'options' => [
                    '1' => [
                        'label' => esc_html__( 'Layout 1', 'finanzia' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_lists/layout/1.webp'
                    ],
                    '2' => [
                        'label' => esc_html__( 'Layout 2', 'finanzia' ),
                        'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_lists/layout/2.webp'
                    ]
                ]
            ]
        );
        $widget->end_controls_section();
        // Heading Content
        $widget->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('Heading Content', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['2']
                ]
            ]
        );
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is the heading',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'heading_color',
                'label'    => esc_html__( 'Color', 'finanzia' )
            ]);
        $widget->end_controls_section();
        // List
        $widget->start_controls_section(
            'list_section',
            [
                'label' => esc_html__('Lists Settings', 'finanzia'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
            // Lists #1
            $lists = new Repeater();
                // Icon
                finanzia_elementor_icon_image_settings($lists,[
                    'group' => false
                ]);
                // Link & Text
                finanzia_elementor_link_settings($lists, [
                    'type' => [
                        'cms-industry' => esc_html__('Industry', 'finanzia')
                    ],
                    'color' => false
                ]);
            $widget->add_control(
                'lists',
                [
                    'label'   => esc_html__('Lists #1', 'finanzia'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $lists->get_controls(),
                    'default' => [
                        [
                            'link_text' => 'Your Title #1'
                        ],
                        [
                            'link_text' => 'Your Title #2'
                        ],
                        [
                            'link_text' => 'Your Title #3'
                        ]
                    ],
                    'title_field' => '{{{ link_text }}}',
                    'label_block' => true
                ]
            );
            // Lists #1
            $lists2 = new Repeater();
                // Icon
                finanzia_elementor_icon_image_settings($lists2,[
                    'group' => false
                ]);
                // Link & Text
                finanzia_elementor_link_settings($lists2, [
                    'type' => [
                        'cms-industry' => esc_html__('Industry', 'finanzia')
                    ],
                    'color' => false
                ]);
            $widget->add_control(
                'lists2',
                [
                    'label'   => esc_html__('Lists #2', 'finanzia'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $lists2->get_controls(),
                    'default' => [
                        [
                            'link_text' => 'Your Title #1'
                        ],
                        [
                            'link_text' => 'Your Title #2'
                        ],
                        [
                            'link_text' => 'Your Title #3'
                        ]
                    ],
                    'title_field' => '{{{ link_text }}}',
                    'label_block' => true,
                    'condition'   => [
                        'layout' => ['2']
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
