<?php
use Elementor\Controls_Manager;
if(!function_exists('finanzia_widget_cms_language_switcher_register_controls')){
	add_action('etc_widget_cms_language_switcher_register_controls', 'finanzia_widget_cms_language_switcher_register_controls', 10, 1);
	function finanzia_widget_cms_language_switcher_register_controls($widget){
		// Layout Settings
		$widget->start_controls_section(
			'layout_section',
			[
				'label' => esc_html__('Layout', 'finanzia' ),
                'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
			]
		);

			$widget->add_control(
				'layout',
                [
                	'label' => esc_html__('Templates', 'finanzia' ),
	                'type' => Elementor_Theme_Core::LAYOUT_CONTROL,
	                'default' => '1',
	                'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_language_switcher/layout/1.jpg'
                        ]
                    ]
	            ]
			);
		$widget->end_controls_section();
		// Settings
		$widget->start_controls_section(
			'setting_section',
            [
            	'label'    => esc_html__('Settings', 'finanzia'),
                'tab'      => \Elementor\Controls_Manager::TAB_CONTENT
            ]
		);
			$widget->add_control(
				'show_flag',
                [
                 	'label'   => esc_html__('Show Flag','finanzia'),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        ''    => esc_html__('Default','finanzia'),
                        'yes' => esc_html__('Yes', 'finanzia'),
                        'no'  => esc_html__('No', 'finanzia')
                    ]
                ]
			);
			$widget->add_control(
				'show_name',
                [
                	'label'   => esc_html__('Show Name','finanzia'),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        ''    => esc_html__('Default','finanzia'),
                        'yes' => esc_html__('Yes', 'finanzia'),
                        'no'  => esc_html__('No', 'finanzia')
                    ]
                ]
			);
			$widget->add_control(
				'name_as',
                [
                	'label'   => esc_html__('Name As','finanzia'),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        ''      => esc_html__('Default','finanzia'),
                        'full'  => esc_html__('Full', 'finanzia'),
                        'short' => esc_html__('Short', 'finanzia')
                    ],
                    'condition' => [
                        'show_name' => ['yes']
                    ] 
                ]
			);
            $widget->add_control(
            	'dropdown_pos',
                [
                	'label'   => esc_html__('Dropdown Position','finanzia'),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => [
                        ''       => esc_html__('Default','finanzia'),
                        'top'    => esc_html__('Top', 'finanzia'),
                        'bottom' => esc_html__('Bottom', 'finanzia')
                    ]
                ]                
            );
		$widget->end_controls_section();
        // Style
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .current-language' => 'color: {{VALUE}};',
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'color_hover',
                'label'    => esc_html__( 'Color Hover & Active', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .current-language:hover' => 'color: {{VALUE}};',
                ]
            ]);
        $widget->end_controls_section();
	}
}
?>