<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
if (!function_exists('finanzia_widget_cms_industry_carousel_register_controls')) {
    add_action('etc_widget_cms_industry_carousel_register_controls', 'finanzia_widget_cms_industry_carousel_register_controls', 10, 1);
    function finanzia_widget_cms_industry_carousel_register_controls($widget)
    {
        // Post term options
        $post_term_options = etc_get_grid_term_options('cms-industry');
        // Layout Settings
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia' ),
                'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__('Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => finanzia_elementor_post_layouts()
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start
        // Source Section Start
        $widget->start_controls_section(
            'source_section',
            [
                'label' => esc_html__('Source', 'finanzia'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'source',
            [
                'label' => esc_html__('Select Categories', 'finanzia'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $post_term_options,
            ]
        );
        $widget->add_control(
            'orderby',
            [
                'label' => esc_html__('Order By', 'finanzia'),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date' => esc_html__('Date', 'finanzia'),
                    'ID' => esc_html__('ID', 'finanzia'),
                    'author' => esc_html__('Author', 'finanzia'),
                    'title' => esc_html__('Title', 'finanzia'),
                    'rand' => esc_html__('Random', 'finanzia'),
                ],
            ]
        );
        $widget->add_control(
            'order',
            [
                'label' => esc_html__('Sort Order', 'finanzia'),
                'type' => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'desc' => esc_html__('Descending', 'finanzia'),
                    'asc' => esc_html__('Ascending', 'finanzia'),
                ],
            ]
        );
        $widget->add_control(
            'limit',
            [
                'label' => esc_html__('Total items', 'finanzia'),
                'type' => Controls_Manager::NUMBER,
                'default' => '6',
            ]
        );
        $widget->end_controls_section();
        // Source Section End
        // Heading Content
        $widget->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('Heading Content', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
                'condition'   => [
                    'layout'  => ['4']  
                ]
            ]
        );
            $widget->add_control(
                'smallheading_text',
                [
                    'label'       => esc_html__( 'Small Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is Small Heading',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'smallheading_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-smallheading' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'smallheading_text!' => ''
                ]
            ]);
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is the heading',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'heading_color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'heading_text!' => ''
                ]
            ]);
            // Description #1
            $widget->add_control(
                'description_text',
                [
                    'label'       => esc_html__( 'Description #1', 'finanzia' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'default'     => 'Lorem Ipsum is simply dummy text of the printing and typesetting story. Lorem Ipsum has been the story standard dummy text ever since', 
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'rows'        => 10,
                    'show_label'  => true,
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'description_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'description_text!' => ''
                ]
            ]);
        $widget->end_controls_section();
        // Link #1
        $widget->start_controls_section('btn_section',[
            'label' => esc_html__('Button Settings', 'finanzia'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [
                'layout'      => ['4']
            ]
        ]);
            $widget->add_control(
                'btn_text',
                [
                    'label'       => esc_html__( 'Text', 'finanzia' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Click Here',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'separator'   => 'before',
                ]
            );
            $widget->add_control(
                'btn_type',
                [
                    'label'   => esc_html__('Type', 'finanzia'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'finanzia'),
                        'page'   => esc_html__('Page', 'finanzia'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'btn_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'btn_page',
                [
                    'label'   => esc_html__('Select Page', 'finanzia'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'return_value' => 'ID',
                    'multiple'  => false,
                    'condition' => [
                        'btn_text!' => '',
                        'btn_type' => 'page'
                    ],
                ]
            );
            $widget->add_control(
                'btn_custom',
                [
                    'label'       => esc_html__( 'Link Custom', 'finanzia' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'finanzia' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'btn_text!' => '',
                        'btn_type' => 'custom'
                    ]
                ]
            );
            // Link #1
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'btn_text_color',
                'label'     => esc_html__( 'Text Color', 'finanzia' ),
                'custom'    => false,
                'condition' => [
                    'btn_text!' => '',
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'btn_color',
                'label'     => esc_html__( 'Background Color', 'finanzia' ),
                'custom'    => false,
                'condition' => [
                    'btn_text!' => '',
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'   => 'btn_text_color_hover',
                'label'  => esc_html__( 'Text Color Hover', 'finanzia' ),
                'custom' => false,
                'condition' => [
                    'btn_text!' => '',
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'       => 'btn_color_hover',
                'label'      => esc_html__( 'Background Color Hover', 'finanzia' ),
                'custom'     => false,
                'condition' => [
                    'btn_text!' => '',
                ]
            ]);
        $widget->end_controls_section();
        // Display Section Start
        $widget->start_controls_section(
            'display_section',
            [
                'label' => esc_html__('Content Display', 'finanzia'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'thumbnail',
                    'default' => 'custom',
                ]
            );
            $widget->add_control(
                'num_line',
                [
                    'label'       => esc_html__('Excerpt Length', 'finanzia'),
                    'description' => esc_html__('Enter number of line you want to show, max is 10', 'finanzia'),
                    'type'        => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 10,
                        ]
                    ],
                    'default' => [
                        'size' => 3,
                    ],
                    'separator'   => 'before',
                ]
            );

            $widget->add_control(
                'readmore_text',
                [
                    'label'       => esc_html__('Readmore Text', 'finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'placeholder' => esc_html__('Read More','finanzia'),
                ]
            );
        $widget->end_controls_section();
        // Display Section End
        // Carousel Section Start
        finanzia_elementor_carousel_settings($widget);
    }
}
