<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Utils;
use Elementor\Repeater;
if (!function_exists('finanzia_widget_cms_headline_register_controls')) {
    add_action('etc_widget_cms_headline_register_controls', 'finanzia_widget_cms_headline_register_controls', 10, 1);
    function finanzia_widget_cms_headline_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_responsive_control(
                'align',
                [
                    'label'        => esc_html__( 'Alignment', 'finanzia' ),
                    'type'         => Controls_Manager::CHOOSE,
                    'options'      => [
                        'start'    => [
                            'title' => esc_html__( 'Left', 'finanzia' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center'  => [
                            'title' => esc_html__( 'Center', 'finanzia' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'end'   => [
                            'title' => esc_html__( 'Right', 'finanzia' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__( 'Justified', 'finanzia' ),
                            'icon' => 'eicon-text-align-justify',
                        ]
                    ]
                ]
            );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_headline/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_headline/layout/2.jpg'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // List Section Start
        $widget->start_controls_section(
            'list_section',
            [
                'label' => esc_html__('List', 'finanzia'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
            $repeater = new Repeater();
            $repeater->add_control(
                'text',
                [
                    'label'       => esc_html__('Text', 'finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Enter your headline text',
                    'label_block' => true
                ]
            );
            $widget->add_control(
                'headlines',
                [
                    'label'   => esc_html__('Headlines', 'finanzia'),
                    'type'    => \Elementor\Controls_Manager::REPEATER,
                    'fields'  => $repeater->get_controls(),
                    'default' => [
                        [
                            'text' => 'Free shipping on US orders $100+ & Free exchanges',
                        ],
                        [
                            'text' => 'Delivery time 2-3 working days',
                        ],
                        [
                            'text' => 'Free exchanges & free returns',
                        ]
                    ],
                    'title_field' => '{{{ text }}}',
                ]
            );
        $widget->end_controls_section();
        // Carousel Settings
        finanzia_elementor_carousel_settings($widget, [
            'hover_icon'       => true,
            'slides_to_show'   => 1,
            'slides_to_scroll' => 1,
            'show_dots'        => '', 
            'condition' => [
                'layout' => ['1']
            ]
        ]);
        // Grid Settings
        finanzia_elementor_grid_columns_settings($widget, [
            'condition' => [
                'layout' => ['2']
            ]
        ]);
        // Style
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .headline-item' => 'color: {{VALUE}};',
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'color_hover',
                'label'    => esc_html__( 'Color Hover & Active', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .headline-item:hover' => 'color: {{VALUE}};',
                ]
            ]);
        $widget->end_controls_section();
    }
}
?>