<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;
if (!function_exists('finanzia_widget_cms_heading_register_controls')) {
    add_action('etc_widget_cms_heading_register_controls', 'finanzia_widget_cms_heading_register_controls', 10, 1);
    function finanzia_widget_cms_heading_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/2.webp'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/3.webp'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/4.webp'
                        ],
                        '5' => [
                            'label' => esc_html__( 'Layout 5', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/5.webp'
                        ],
                        '6' => [
                            'label' => esc_html__( 'Layout 6', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/6.webp'
                        ],
                        '7' => [
                            'label' => esc_html__( 'Layout 7', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/7.webp'
                        ],
                        '8' => [
                            'label' => esc_html__( 'Layout 8', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/8.webp'
                        ],
                        '8-small' => [
                            'label' => esc_html__( 'Layout 8 (Small Heading)', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/8-small.webp'
                        ],
                        '9' => [
                            'label' => esc_html__( 'Layout 9', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/9.webp'
                        ],
                        '10' => [
                            'label' => esc_html__( 'Layout 10', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/10.webp'
                        ],
                        '11' => [
                            'label' => esc_html__( 'Layout 11', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/11.webp'
                        ],
                        '12' => [
                            'label' => esc_html__( 'Layout 12', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/12.webp'
                        ],
                        '13' => [
                            'label' => esc_html__( 'Layout 13', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/13.webp'
                        ],
                        '14' => [
                            'label' => esc_html__( 'Layout 14', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/14.webp'
                        ],
                        '-15' => [
                            'label' => esc_html__( 'Layout 15', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/15.webp'
                        ],
                        '-16' => [
                            'label' => esc_html__( 'Layout 16', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/16.webp'
                        ],
                        '-single-case' => [
                            'label' => esc_html__( 'Single Case', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/single-case.webp'
                        ],
                        '-single-case2' => [
                            'label' => esc_html__( 'Single Case #2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/single-case2.webp'
                        ],
                        '-single-industry' => [
                            'label' => esc_html__( 'Single Industry', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/single-industry.webp'
                        ],
                        '--single-story2' => [
                            'label' => esc_html__( 'Single Industry #2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_heading/layout/single-story2.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Heading Content
        $widget->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('Heading Content', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            finanzia_elementor_icon_image_settings($widget, [
                'group'     => false,
                'condition' => [
                    'layout' => ['9']
                ]
            ]);
            $widget->add_control(
                'smallheading_text',
                [
                    'label'       => esc_html__( 'Small Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true,
                    'condition'   => [
                        'layout'  => ['1','1-large','1-xlarge','2','3','4','5','11','14']  
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'smallheading_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout'             => ['1','1-large','1-xlarge','2','3','4','5','11','14'],
                    'smallheading_text!' => ''
                ]
            ]);
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is the heading',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true,
                    'condition'   => [
                        'layout'  => ['1','1-large','1-xlarge','2','3','4','5','6','7','8','8-small','9','10','11','12','13','14','15','16','-single-case','-single-case2','-single-industry','-single-story2']  
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'heading_color',
                'label'    => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout'        => ['1','1-large','1-xlarge','2','3','4','5','6','7','8','8-small','9','10','11','12','13','14','15','16','-single-case','-single-case2','-single-industry','-single-story2'],
                    'heading_text!' => ''
                ]
            ]);
            $widget->add_control(
                'heading_text2',
                [
                    'label'       => esc_html__( 'Heading #2', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is the heading #2',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => false,
                    'condition'   => [
                        'layout'  => ['8-small']  
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'heading2_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout'         => ['8-small'],
                    'heading_text2!' => ''
                ]
            ]);
            
            // Description #1
            $widget->add_control(
                'desc',
                [
                    'label'       => esc_html__( 'Description #1', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Lorem Ipsum is simply dummy text of the printing and typesetting story. Lorem Ipsum has been the story standard dummy text ever since', 
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'rows'        => 10,
                    'show_label'  => true,
                    'condition' => [
                        'layout' => ['2','3','4','6','7','8','8-small','9','10','11','13','15','16','-single-case','-single-case2','-single-industry','-single-story2']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'desc_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout' => ['2','3','4','6','7','8','8-small','9','10','11','13','15','16','-single-case','-single-case2','-single-industry','-single-story2'],
                    'desc!'  => ''
                ]
            ]);
            // Description #2
            $widget->add_control(
                'desc2',
                [
                    'label'       => esc_html__( 'Description #2', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour', 
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'rows'        => 10,
                    'show_label'  => true,
                    'condition' => [
                        'layout' => ['3','4','10','-single-case2']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'desc2_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout'            => ['3','4','10','-single-case2'],
                    'desc2!' => ''
                ]
            ]);
        $widget->end_controls_section();
        // Button #1
        finanzia_elementor_link_settings($widget, [
            'name'        => 'link1_',
            'mode'        => 'btn',
            'group'       => true,
            'label'       => esc_html__('Button #1 Settings', 'finanzia'),
            'color_label' => esc_html__('Button', 'finanzia'),
            'condition'   => [
                'layout' => ['2','3','4','5','6','7','8','9','8-small','9','10','11','12','15','16']
            ]
        ]);
        // Button #2
        finanzia_elementor_link_settings($widget, [
            'name'        => 'link2_',
            'mode'        => 'btn',
            'group'       => true,
            'label'       => esc_html__('Button #2 Settings', 'finanzia'),
            'color_label' => esc_html__('Button', 'finanzia'),
            'condition'   => [
                'layout' => ['2','3','4','7','8','9','8-small','9','10','11','16']
            ]
        ]);
        // Signature
        $widget->start_controls_section('signature_section',[
            'label' => esc_html__('Signature', 'finanzia'),
            'tab'   => Controls_Manager::TAB_CONTENT,
            'condition' => [
                'layout' => ['3','4','10','13','16']
            ]
        ]);
            $widget->add_control(
                'savatar',
                [
                    'label'   => esc_html__( 'Avatar', 'finanzia' ),
                    'type'    => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ],
                    'label_block' => false
                ]
            );
            $widget->add_control(
                'simage',
                [
                    'label'   => esc_html__( 'Signature Image', 'finanzia' ),
                    'type'    => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => get_template_directory_uri() . '/assets/images/signature.png'
                    ],
                    'label_block' => false
                ]
            );
            $widget->add_control(
                'sname',
                [
                    'label'       => esc_html__( 'Name', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Michael Brian',
                    'label_block' => false
                ]
            );
            $widget->add_control(
                'sposition',
                [
                    'label'       => esc_html__( 'Position', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'The Founder',
                    'label_block' => false
                ]
            );
        $widget->end_controls_section();
        // Progressbar Section Start
        $widget->start_controls_section(
                'section_progressbar',
                [
                    'label' => esc_html__('Progressbar Content', 'finanzia'),
                    'tab'   => Controls_Manager::TAB_CONTENT,
                    'condition' => [
                        'layout' => ['all']
                    ]
                ]
            );

            $progressbar = new Repeater();

            $progressbar->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXT,
                    'placeholder' => esc_html__( 'Enter your title', 'finanzia' ),
                    'default'     => esc_html__( 'My Skill', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            $progressbar->add_control(
                'percent',
                [
                    'label'       => esc_html__( 'Percentage', 'finanzia' ),
                    'type'        => Controls_Manager::SLIDER,
                    'default'     => [
                        'size' => 80,
                        'unit' => '%',
                    ],
                    'label_block' => true,
                ]
            );

            $widget->add_control(
                'progressbar_list',
                [
                    'label'   => esc_html__('List', 'finanzia'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $progressbar->get_controls(),
                    'default' => [
                        [
                            'title' => esc_html__('Fire Detection', 'finanzia'),
                            'percent' => [
                                'size' => 95,
                                'unit' => '%',
                            ],
                        ],
                        [
                            'title' => esc_html__('Alarm Systems', 'finanzia'),
                            'percent' => [
                                'size' => 88,
                                'unit' => '%',
                            ],
                        ],
                        [
                            'title' => esc_html__('CCTV & Video', 'finanzia'),
                            'percent' => [
                                'size' => 99,
                                'unit' => '%',
                            ],
                        ],
                        [
                            'title' => esc_html__('Access control', 'finanzia'),
                            'percent' => [
                                'size' => 85,
                                'unit' => '%',
                            ],
                        ]
                    ],
                    'title_field' => '{{{ title }}}',
                ]
            );
        $widget->end_controls_section();
        // Features
        $widget->start_controls_section('features_section',[
            'label' => esc_html__('Features Settings', 'finanzia'),
            'tab'   => Controls_Manager::TAB_CONTENT
        ]);
            
            // For layout 3
            $features_3 = new Repeater();
                $features_3->add_control(
                    'icon',
                    [
                        'label'       => esc_html__( 'Icon', 'finanzia' ),
                        'default'     => [],
                        'type'        => Controls_Manager::ICONS,
                        'skin'        => 'inline',
                        'label_block' => false
                    ]
                );
                $features_3->add_control(
                    'title',
                    [
                        'label'       => esc_html__( 'Title', 'finanzia' ),
                        'default'     => 'Your Title',
                        'type'        => Controls_Manager::TEXT,
                        'label_block' => true
                    ]
                );
                $features_3->add_control(
                    'description',
                    [
                        'label'       => esc_html__( 'Description', 'finanzia' ),
                        'default'     => 'Lorem Ipsum is simply dummy text of the printing and typesetting story.',
                        'type'        => Controls_Manager::TEXTAREA,
                        'label_block' => true
                    ]
                );
            // Feature Options
            $widget->add_control(
                'show_feature',
                [
                    'label'     => esc_html__('Show Feature', 'finanzia'),
                    'type'      => Controls_Manager::SWITCHER,
                    'default'   => 'yes',
                    'condition' =>[
                        'layout'  => ['3','6','7','8-small','9','10','11']
                    ]
                ]
            );
            $widget->add_control(
                'feature_description',
                [
                    'label'       => esc_html__( 'Description', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour', 
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'rows'        => 10,
                    'show_label'  => true,
                    'condition' => [
                        'layout'       => ['3'],
                        'show_feature' => 'yes'
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'feature_description_color',
                'label'     => esc_html__( 'Color', 'finanzia' ),
                'condition' => [
                    'layout'               => ['3'],
                    'show_feature'         => 'yes',
                    'feature_description!' => ''
                ]
            ]);
            // Feature for layout 3
            $widget->add_control(
                'cms_feature',
                [
                    'label'   => esc_html__('Features List', 'finanzia'),
                    'type'    => Controls_Manager::REPEATER,
                    'fields'  => $features_3->get_controls(),
                    'default' => [
                        [
                            'icon'        => [],
                            'title'       => 'Feature Title #1',
                            'description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting story.'
                        ],
                        [
                            'icon'        => [],
                            'title'       => 'Feature Title #2',
                            'description' => 'Lorem Ipsum is simply dummy text of the printing and typesetting story.'
                        ]
                    ],
                    'title_field' => '{{{ title }}}',
                    'condition' => [
                        'layout'       => ['3','6','7','8-small','9','10','11'],
                        'show_feature' => 'yes'
                    ],
                    'label_block' => true
                ]
            );
            //
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'feature_border_color',
                'label'    => esc_html__( 'Border Color', 'finanzia' ),
                'condition' => [
                    'layout'       => ['3','6','8-small','9'],
                    'show_feature' => 'yes'
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'feature_icon_bg_color',
                'label'    => esc_html__( 'Default Icon Background Color', 'finanzia' ),
                'condition' => [
                    'layout'       => ['7'],
                    'show_feature' => 'yes'
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'feature_icon_color',
                'label'    => esc_html__( 'Icon Color', 'finanzia' ),
                'condition' => [
                    'layout'       => ['3','6','7','8-small','9','11'],
                    'show_feature' => 'yes'
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'feature_title_color',
                'label'    => esc_html__( 'Title Color', 'finanzia' ),
                'condition' => [
                    'layout'       => ['3','6','7','8-small','9','11'],
                    'show_feature' => 'yes'
                ]
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'feature_desc_color',
                'label'    => esc_html__( 'Description Color', 'finanzia' ),
                'condition' => [
                    'layout'       => ['3','6','7','8-small','9','11'],
                    'show_feature' => 'yes'
                ]
            ]);
        $widget->end_controls_section();
        // Style Content Alignment Start
        $widget->start_controls_section(
            'section_style_content',
            [
                'label' => esc_html__('Content Alignment', 'finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $widget->add_control(
                'align',
                [
                    'label'        => esc_html__( 'Alignment', 'finanzia' ),
                    'type'         => Controls_Manager::CHOOSE,
                    'options'      => [
                        'start'    => [
                            'title' => esc_html__( 'Left', 'finanzia' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center'  => [
                            'title' => esc_html__( 'Center', 'finanzia' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'end'   => [
                            'title' => esc_html__( 'Right', 'finanzia' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__( 'Justified', 'finanzia' ),
                            'icon' => 'eicon-text-align-justify',
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
