<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Group_Control_Image_Size;
if (!function_exists('finanzia_widget_cms_cta_register_controls')) {
    add_action('etc_widget_cms_cta_register_controls', 'finanzia_widget_cms_cta_register_controls', 10, 1);
    function finanzia_widget_cms_cta_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/2.webp'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/3.webp'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_cta/layout/4.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        
        // Content Section Start
        $widget->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );  
            // Title   
            $widget->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is Title',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'condition'   => [
                        'layout' => ['4']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'title_color',
                'label'     => esc_html__( 'Title Color', 'finanzia' ),
                'condition' => [
                    'title!'  => '',
                    'layout' => ['4']
                ]
            ]);
            // Description   
            $widget->add_control(
                'text',
                [
                    'label'       => esc_html__( 'Description', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Lorem Ipsum is simply dummy text of the printing and typesetting industry',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'condition'   => [
                        'layout' => ['1','2','3','4']
                    ]
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'      => 'text_color',
                'label'     => esc_html__( 'Description Color', 'finanzia' ),
                'condition' => [
                    'text!'  => '',
                    'layout' => ['1','2','3','4']
                ]
            ]);
            // Link
            finanzia_elementor_link_settings($widget, [
                'name'      => 'link_',
                'text'      => 'Click Here',
                'group'     => false,
                'condition' => [
                    'layout' => ['1','2'] 
                ]
            ]);
        $widget->end_controls_section();
        // Button
        finanzia_elementor_link_settings($widget, [
            'name'        => 'btn_',
            'group'       => true,
            'mode'        => 'btn',
            'label'       => esc_html__('Button Settings','finanzia'),
            'color_label' => esc_html__('Button','finanzia'),
            'condition'   => [
                'layout' => ['3','4']
            ]
        ]);
        // Email
        finanzia_elementor_link_settings($widget, [
            'name'        => 'email_',
            'group'       => true,
            'mode'        => '',
            'label'       => esc_html__('Email Settings','finanzia'),
            'condition'   => [
                'layout' => ['4']
            ]
        ]);
        
        // Style
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
            $widget->add_responsive_control(
                'align',
                [
                    'label'        => esc_html__( 'Alignment', 'finanzia' ),
                    'type'         => Controls_Manager::CHOOSE,
                    'responsive'   => true,
                    'options'      => [
                        'start'    => [
                            'title' => esc_html__( 'Left', 'finanzia' ),
                            'icon'  => 'eicon-text-align-left',
                        ],
                        'center'  => [
                            'title' => esc_html__( 'Center', 'finanzia' ),
                            'icon'  => 'eicon-text-align-center',
                        ],
                        'end'   => [
                            'title' => esc_html__( 'Right', 'finanzia' ),
                            'icon'  => 'eicon-text-align-right',
                        ],
                        'justify' => [
                            'title' => esc_html__( 'Justified', 'finanzia' ),
                            'icon' => 'eicon-text-align-justify',
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}
