<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;

if (!function_exists('finanzia_widget_cms_chart_line_register_controls')) {
    add_action('etc_widget_cms_chart_line_register_controls', 'finanzia_widget_cms_chart_line_register_controls', 10, 1);
    function finanzia_widget_cms_chart_line_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_chart_line/layout/1.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        $widget->start_controls_section(
            'chart_section',
            [
                'label' => esc_html__('Chart Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );

            $repeater = new Repeater();
            $repeater->add_control(
                'chart_title',
                [
                    'label'       => esc_html__('Title', 'finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Your Title'
                ]
            );
            $repeater->add_control(
                'chart_value',
                [
                    'label'       => esc_html__('Value', 'finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => '2000, 9000, 13000, 19000, 19000, 11000',
                    'description' => esc_html__('Each value separate by comma (,)','finanzia'),
                    'placeholder' => '2000, 9000, 13000, 19000, 19000, 11000'
                ]
            );
            $repeater->add_control(
                'chart_dash',
                [
                    'label'       => esc_html__('Line Dashed?', 'finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '0',
                    'description' => esc_html__('Each value separate by comma (,). Example: 2,4,6,8','finanzia'),
                    'placeholder' => '2,4,6,8'
                ]
            );
            $repeater->add_control(
                'chart_color',
                [
                    'label'   => esc_html__('Color', 'finanzia'),
                    'type'    => Controls_Manager::COLOR,
                    'default' => '#01A04C'
                ]
            );
            $widget->add_control(
                'cms_chart_labels',
                [
                    'label'       => esc_html__('Labels', 'finanzia'),
                    'type'        => Controls_Manager::TEXTAREA,
                    'description' => esc_html__('Each title separate by comma (,)','finanzia'),
                    'default'     => 'Apr, May, Jun, Jul, Aug, Sep',
                    'placeholder' => 'Apr, May, Jun, Jul, Aug, Sep'
                ]
            );
            $widget->add_control(
                'cms_chart_line',
                [
                    'label'  => esc_html__( 'Chart Items', 'finanzia' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'chart_title' => 'Product 1',
                            'chart_value' => '4000, 10000, 17000, 9500, 17000, 17000, 15000, 12000',
                            'chart_color' => '#01A04C',
                            'chart_dash'  => '0'  
                        ],
                        [
                            'chart_title' => 'Product 2',
                            'chart_value' => '8000, 5000, 14500, 11000, 23000, 17000, 20000',
                            'chart_color' => '#091019',
                            'chart_dash'  => '6'
                        ]
                    ],
                    'title_field' => '{{{ chart_value }}}',
                    'label_block' => true
                ]
            );
            $widget->add_control(
                'legend_display',
                [
                    'label'        => esc_html__( 'Show Legend', 'finanzia' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'return_value' => 'yes'
                ]
            );
            $widget->add_control(
                'legend_position',
                [
                    'label'   => esc_html__( 'Legend Position', 'finanzia' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => array(
                        'top'    => __('Top','finanzia'),
                        'right'  => __('Right','finanzia'),
                        'bottom' => __('Bottom','finanzia'),
                        'left'   => __('Left','finanzia')
                    ),
                    'default' => 'bottom',
                    'condition' => [
                        'legend_display' => 'yes'
                    ]
                ]
            );
            $widget->add_control(
                'title_display',
                [
                    'label'        => esc_html__( 'Show Title', 'finanzia' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'return_value' => 'yes'
                ]
            );
            $widget->add_control(
                'title_text',
                [
                    'label'   => esc_html__( 'Title', 'finanzia' ),
                    'type'    => Controls_Manager::TEXTAREA,
                    'default' => 'CMS Charts Line',
                    'condition' => [
                        'title_display' => 'yes'
                    ],
                    'label_block' => false
                ]
            );
            $widget->add_control(
                'title_position',
                [
                    'label'   => esc_html__( 'Title Position', 'finanzia' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => array(
                        'top'    => __('Top','finanzia'),
                        'right'  => __('Right','finanzia'),
                        'bottom' => __('Bottom','finanzia'),
                        'left'   => __('Left','finanzia')
                    ),
                    'default' => 'top',
                    'condition' => [
                        'title_display' => 'yes'
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}