<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;

if (!function_exists('finanzia_widget_cms_chart_bar_register_controls')) {
    add_action('etc_widget_cms_chart_bar_register_controls', 'finanzia_widget_cms_chart_bar_register_controls', 10, 1);
    function finanzia_widget_cms_chart_bar_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_chart_bar/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_chart_bar/layout/2.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Content Section Start
        $widget->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__('Content Settings', 'finanzia'),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['1']
                ]
            ]
        );  
            $widget->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Stats & Charts',
                    'placeholder' => esc_html__( 'Enter your title', 'finanzia' )
                ]
            );      
            $widget->add_control(
                'text',
                [
                    'label'       => esc_html__( 'Content', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Our mix of company-owned and contractor assets allows us to retain optimal levels of control whilst expanding our reach to over 96% of towns in Australia. With 40 years of LTL experience, we are now a trusted LTL freight provider for shippers of all sizes and commodity types.',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' )
                ]
            ); 
            $widget->add_control(
                'link_text',
                [
                    'label'       => esc_html__( 'Link Settings', 'finanzia' ),
                    'description' => esc_html__('Link Text', 'finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Click here', 'finanzia' ),
                    'label_block' => true
                ]
            );
            $widget->add_control(
                'link_type',
                [
                    'label'   => esc_html__('Link Type', 'finanzia'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'finanzia'),
                        'page'   => esc_html__('Page', 'finanzia'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'link_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'page_link',
                [
                    'label'   => esc_html__('Select Page', 'finanzia'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'link_text!' => '',
                        'link_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'custom_link',
                [
                    'label'       => esc_html__( 'Link', 'finanzia' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'finanzia' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'link_text!' => '',
                        'link_type' => 'custom'
                    ]
                ]
            );
            $widget->add_control(
                'link2_text',
                [
                    'label'       => esc_html__( 'Link #2 Settings', 'finanzia' ),
                    'description' => esc_html__('Link Text', 'finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '',
                    'placeholder' => esc_html__( 'Check All Services', 'finanzia' ),
                    'separator' => 'before'
                ]
            );
            $widget->add_control(
                'link2_type',
                [
                    'label'   => esc_html__('Link Type', 'finanzia'),
                    'type'    => Controls_Manager::SELECT,
                    'options' => [
                        'custom' => esc_html__('Custom', 'finanzia'),
                        'page'   => esc_html__('Page', 'finanzia'),
                    ],
                    'default' => 'custom',
                    'condition' => [
                        'link2_text!' => ''
                    ]
                ]
            );
            $widget->add_control(
                'link2_page',
                [
                    'label'   => esc_html__('Select Page', 'finanzia'),
                    'type'    => Elementor_Theme_Core::POSTS_CONTROL,
                    'post_type' => [
                        'page'
                    ],
                    'multiple'  => false,
                    'condition' => [
                        'link2_text!' => '',
                        'link2_type' => 'page'
                    ]
                ]
            );
            $widget->add_control(
                'link2_custom',
                [
                    'label'       => esc_html__( 'Link Custom', 'finanzia' ),
                    'type'        => Controls_Manager::URL,
                    'placeholder' => esc_html__( 'https://your-link.com', 'finanzia' ),
                    'default'     => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'link2_text!' => '',
                        'link2_type' => 'custom'
                    ]
                ]
            );
        $widget->end_controls_section();
        $widget->start_controls_section(
            'chart_section',
            [
                'label' => esc_html__('Chart Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );
            $widget->add_control(
                'chart1_title',
                [
                    'label'   => esc_html__('Title #1', 'finanzia'),
                    'type'    => Controls_Manager::TEXT
                ]
            );
            $widget->add_control(
                'chart1_color',
                [
                    'label'   => esc_html__('Color #1', 'finanzia'),
                    'type'    => Controls_Manager::COLOR
                ]
            );
            $widget->add_control(
                'chart2_title',
                [
                    'label'   => esc_html__('Title #2', 'finanzia'),
                    'type'    => Controls_Manager::TEXT
                ]
            );
            $widget->add_control(
                'chart2_color',
                [
                    'label'   => esc_html__('Color #2', 'finanzia'),
                    'type'    => Controls_Manager::COLOR
                ]
            );
            $widget->add_control(
                'chart3_title',
                [
                    'label'   => esc_html__('Title #3', 'finanzia'),
                    'type'    => Controls_Manager::TEXT
                ]
            );
            $widget->add_control(
                'chart3_color',
                [
                    'label'   => esc_html__('Color #3', 'finanzia'),
                    'type'    => Controls_Manager::COLOR
                ]
            );
            // Chart Settings
            $chart = new Repeater();
            $chart->add_control(
                'chart_title',
                [
                    'label' => esc_html__('Group Title', 'finanzia'),
                    'type' => Controls_Manager::TEXT
                ]
            );
            // chart item 1
            $chart->add_control(
                'chart1_value',
                [
                    'label' => esc_html__('Value', 'finanzia'),
                    'type'  => Controls_Manager::TEXT
                ]
            );
            // chart item 2
            $chart->add_control(
                'chart2_value',
                [
                    'label' => esc_html__('Value', 'finanzia'),
                    'type'  => Controls_Manager::TEXT
                ]
            );
            // chart item 3
            $chart->add_control(
                'chart3_value',
                [
                    'label' => esc_html__('Value', 'finanzia'),
                    'type'  => Controls_Manager::TEXT
                ]
            );
            $widget->add_control(
                'cms_chart',
                [
                    'label'  => esc_html__( 'Chart Items', 'finanzia' ),
                    'type'   => \Elementor\Controls_Manager::REPEATER,
                    'fields' => $chart->get_controls(),
                    'label_block' => true,
                    'default' => [
                        [
                            'chart_title'  => '2019',
                            'chart1_value' => 48,
                            'chart2_value' => 57,
                            'chart3_value' => 65,
                        ],
                        [
                            'chart_title'  => '2020',
                            'chart1_value' => 34,
                            'chart2_value' => 43,
                            'chart3_value' => 48,
                        ],
                        [
                            'chart_title'  => '2021',
                            'chart1_value' => 37,
                            'chart2_value' => 27,
                            'chart3_value' => 41,
                        ],
                        [
                            'chart_title'  => '2022',
                            'chart1_value' => 27,
                            'chart2_value' => 34,
                            'chart3_value' => 20,
                        ],
                        [
                            'chart_title'  => '2023',
                            'chart1_value' => 22,
                            'chart2_value' => 34,
                            'chart3_value' => 41,
                        ]
                    ],
                    'title_field' => '{{{ chart_title }}}',
                ]
            );
        $widget->end_controls_section();
        // Style
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Style Settings', 'finanzia' ),
                'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
            ]
        );
            $widget->add_control(
                'cms_chart_type',
                [
                    'label'   => esc_html__( 'Chart Type', 'finanzia' ),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => array(
                        ''          => __('Default','finanzia'),
                        'line'      => __('Line','finanzia'),
                        'bar'       => __('Vertical Bar','finanzia')    
                    )
                ]
            );
            $widget->add_control(
                'cms_chart_dimensions',
                [
                    'label'        => esc_html__( 'Chart Width', 'finanzia' ),
                    'type'         => \Elementor\Controls_Manager::SLIDER,
                    'control_type' => 'responsive',
                    'range' => [
                        'px' => [
                            'min' => 300,
                            'max' => 1280,
                        ]
                    ],
                    'default' => [
                        'size' => ''
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .cms-charts-wrap' => 'max-width:{{SIZE}}px;' //max-height:{{SIZE}}px;
                    ]
                ]
            );
            $widget->add_control(
                'cms_chart_dimensions_h',
                [
                    'label'        => esc_html__( 'Chart Height', 'finanzia' ),
                    'type'         => \Elementor\Controls_Manager::SLIDER,
                    'control_type' => 'responsive',
                    'range' => [
                        'px' => [
                            'min' => 300,
                            'max' => 1280,
                        ]
                    ],
                    'default' => [
                        'size' => 420
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .cms-charts-bar' => 'min-height:{{SIZE}}px;' //max-height:{{SIZE}}px;
                    ]
                ]
            );
            $widget->add_control(
                'legend_display',
                [
                    'label'   => esc_html__( 'Show Legend', 'finanzia' ),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => array(
                        'true'  => __('Yes','finanzia'),
                        'false' => __('No','finanzia')
                    ),
                    'default' => 'false'
                ]
            );
            $widget->add_control(
                'legend_position',
                [
                    'label'   => esc_html__( 'Legend Position', 'finanzia' ),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => array(
                        'top'    => __('Top','finanzia'),
                        'right'  => __('Right','finanzia'),
                        'bottom' => __('Bottom','finanzia'),
                        'left'   => __('Left','finanzia')
                    ),
                    'default' => 'top',
                    'condition' => [
                        'legend_display' => 'true'
                    ]
                ]
            );
            $widget->add_control(
                'title_display',
                [
                    'label'   => esc_html__( 'Show Title', 'finanzia' ),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => array(
                        '1'  => __('Yes','finanzia'),
                        '0' => __('No','finanzia')
                    ),
                    'default' => '0'
                ]
            );
            $widget->add_control(
                'title_text',
                [
                    'label'   => esc_html__( 'Title', 'finanzia' ),
                    'type'    => \Elementor\Controls_Manager::TEXTAREA,
                    'default' => 'Your Title',
                    'condition' => [
                        'title_display' => '1'
                    ]
                ]
            );
            $widget->add_control(
                'title_position',
                [
                    'label'   => esc_html__( 'Title Position', 'finanzia' ),
                    'type'    => \Elementor\Controls_Manager::SELECT,
                    'options' => array(
                        'top'    => __('Top','finanzia'),
                        'right'  => __('Right','finanzia'),
                        'bottom' => __('Bottom','finanzia'),
                        'left'   => __('Left','finanzia')
                    ),
                    'default' => 'top',
                    'condition' => [
                        'title_display' => '1'
                    ]
                ]
            );
        $widget->end_controls_section();
    }
}