<?php
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Repeater;

if (!function_exists('finanzia_widget_cms_chart_register_controls')) {
    add_action('etc_widget_cms_chart_register_controls', 'finanzia_widget_cms_chart_register_controls', 10, 1);
    function finanzia_widget_cms_chart_register_controls($widget)
    {
        // Layout
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_chart/layout/1.jpg'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_chart/layout/2.webp'
                        ],
                        '3' => [
                            'label' => esc_html__( 'Layout 3', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_chart/layout/3.webp'
                        ],
                        '4' => [
                            'label' => esc_html__( 'Layout 4', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_chart/layout/4.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Content Section Start
        $widget->start_controls_section(
            'content_section',
            [
                'label'     => esc_html__('Content Settings', 'finanzia'),
                'tab'       => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'layout' => ['1', '2', '4']
                ]
            ]
        );  
            $widget->add_control(
                'title',
                [
                    'label'       => esc_html__( 'Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Stats & Charts',
                    'placeholder' => esc_html__( 'Enter your title', 'finanzia' )
                ]
            );      
            $widget->add_control(
                'text',
                [
                    'label'       => esc_html__( 'Content', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'Our mix of company-owned and contractor assets allows us to retain optimal levels of control whilst expanding our reach to over 96% of towns in Australia. With 40 years of LTL experience, we are now a trusted LTL freight provider for shippers of all sizes and commodity types.',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' )
                ]
            ); 
            // Button #1
            finanzia_elementor_link_settings($widget, [
                'name'        => 'link1_',
                'mode'        => 'btn',
                'group'       => false,
                'label'       => esc_html__('Button #1 Settings', 'finanzia'),
                'color_label' => esc_html__('Button', 'finanzia')
            ]);
            // Button #2
            finanzia_elementor_link_settings($widget, [
                'name'        => 'link2_',
                'mode'        => 'btn',
                'group'       => false,
                'label'       => esc_html__('Button #2 Settings', 'finanzia'),
                'color_label' => esc_html__('Button', 'finanzia')
            ]);
        $widget->end_controls_section();
        $widget->start_controls_section(
            'chart_section',
            [
                'label' => esc_html__('Chart Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT
            ]
        );
            $repeater = new Repeater();
            $repeater->add_control(
                'chart_title',
                [
                    'label' => esc_html__('Title', 'finanzia'),
                    'type' => Controls_Manager::TEXT
                ]
            );
            $repeater->add_control(
                'chart_main_title',
                [
                    'label' => esc_html__('Main Title', 'finanzia'),
                    'type' => Controls_Manager::TEXT
                ]
            );
            $repeater->add_control(
                'chart_value',
                [
                    'label' => esc_html__('Value', 'finanzia'),
                    'type' => Controls_Manager::TEXT
                ]
            );
            $repeater->add_control(
                'chart_color',
                [
                    'label'   => esc_html__('Color', 'finanzia'),
                    'type'    => Controls_Manager::COLOR,
                    'default' => '#01A04C'
                ]
            );
            $widget->add_control(
                'cms_chart',
                [
                    'label'  => esc_html__( 'Chart Items', 'finanzia' ),
                    'type'   => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'chart_title'      => 'Retail',
                            'chart_main_title' => 'Retail & Consumer',
                            'chart_value'      => 40,
                            'chart_color'      => '#9bcb3b',
                        ],
                        [
                            'chart_title'      => 'Sciences',
                            'chart_main_title' => 'Sciences & Healthcare',
                            'chart_value'      => 20,
                            'chart_color'      => '#5553ce',
                        ],
                        [
                            'chart_title'      => 'Industrial',
                            'chart_main_title' => 'Industrial & Chemical',
                            'chart_value'      => 15,
                            'chart_color'      => '#f13a30',
                        ],
                        [
                            'chart_title'      => 'Power',
                            'chart_main_title' => 'Power Generation',
                            'chart_value'      => 15,
                            'chart_color'      => '#f8a137',
                        ],
                        [
                            'chart_title'      => 'Oil',
                            'chart_main_title' => 'Oil & Gas',
                            'chart_value'      => 10,
                            'chart_color'      => '#1875f0',
                        ]
                    ],
                    'title_field' => '{{{ chart_title }}} ({{{ chart_value }}})',
                ]
            );
            // Banner
            $widget->add_control(
                'banner',
                [
                    'label'   => esc_html__( 'Banner', 'finanzia' ),
                    'type'    => Controls_Manager::MEDIA,
                    'default' => [
                        'url' => Utils::get_placeholder_image_src()
                    ],
                    'condition' => [
                        'layout' => ['2','3']
                    ],
                    'label_block' => true
                ]
            );
            // Content
            $widget->add_control(
                'content',
                [
                    'label'   => esc_html__( 'Content', 'finanzia' ),
                    'type'    => Controls_Manager::TEXTAREA,
                    'default' => 'Lorem Ipsum is simply dummy text of the printing and typesetting story.',
                    'condition' => [
                        'layout' => ['3']
                    ]
                ]
            );
        $widget->end_controls_section();
        // Style
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__( 'Style Settings', 'finanzia' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
            $widget->add_control(
                'chart_rotate',
                [
                    'label' => esc_html__('Chart Rotate', 'finanzia'),
                    'type'  => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min'  => -360,
                            'max'  => 360,
                            'step' => 1
                        ]
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .cms-charts ' => 'transform:rotate({{SIZE}}deg);'
                    ]
                ]
            );
            $widget->add_control(
                'cms_chart_type',
                [
                    'label'   => esc_html__( 'Chart Type', 'finanzia' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => array(
                        ''          => __('Default','finanzia'),
                        'doughnut'  => __('Doughnut','finanzia'),
                        'pie'       => __('Pie','finanzia'),
                        'polarArea' => __('Polar Area','finanzia')
                    )
                ]
            );
            $widget->add_control(
                'cms_chart_mode',
                [
                    'label'        => esc_html__( 'Chart Mode', 'finanzia' ),
                    'type'         => Controls_Manager::SELECT,
                    'options'      => [
                        ''            => esc_html__('Default', 'finanzia'),
                        'circle'      => esc_html__('Circle', 'finanzia'),
                        'half-circle' => esc_html__('Half Circle', 'finanzia')
                    ],
                    'condition'    => [
                        'cms_chart_type' => ['doughnut','pie']
                    ]
                ]
            );
            $widget->add_control(
                'cms_chart_dimensions',
                [
                    'label'        => esc_html__( 'Chart Dimensions', 'finanzia' ),
                    'type'         => Controls_Manager::SLIDER,
                    'control_type' => 'responsive',
                    'range' => [
                        'px' => [
                            'min' => 100,
                            'max' => 1280,
                        ]
                    ],
                    'default' => [
                        'size' => ''
                    ]/*,
                    'selectors' => [
                        '{{WRAPPER}} .cms-charts-wrap' => 'max-width:{{SIZE}}px;' //max-height:{{SIZE}}px;
                    ]*/
                ]
            );
            $widget->add_control(
                'cms_chart_cutout',
                [
                    'label'        => esc_html__( 'Chart Cutout', 'finanzia' ),
                    'type'         => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 10,
                            'max' => 109,
                        ]
                    ],
                    'default' => [
                        'size' => ''
                    ]/*,
                    'selectors' => [
                        '{{WRAPPER}} .cms-charts-wrap' => 'max-width:{{SIZE}}px;' //max-height:{{SIZE}}px;
                    ]*/
                ]
            );
            $widget->add_control(
                'legend_display',
                [
                    'label'        => esc_html__( 'Show Legend', 'finanzia' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'return_value' => 'yes'
                ]
            );
            $widget->add_control(
                'legend_position',
                [
                    'label'   => esc_html__( 'Legend Position', 'finanzia' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => array(
                        'top'    => __('Top','finanzia'),
                        'right'  => __('Right','finanzia'),
                        'bottom' => __('Bottom','finanzia'),
                        'left'   => __('Left','finanzia')
                    ),
                    'default' => 'top',
                    'condition' => [
                        'legend_display' => 'yes'
                    ]
                ]
            );
            $widget->add_control(
                'title_display',
                [
                    'label'        => esc_html__( 'Show Title', 'finanzia' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'return_value' => 'yes'
                ]
            );
            $widget->add_control(
                'title_text',
                [
                    'label'   => esc_html__( 'Title', 'finanzia' ),
                    'type'    => Controls_Manager::TEXTAREA,
                    'default' => 'Your Title',
                    'condition' => [
                        'title_display' => 'yes'
                    ]
                ]
            );
            $widget->add_control(
                'title_position',
                [
                    'label'   => esc_html__( 'Title Position', 'finanzia' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => array(
                        'top'    => __('Top','finanzia'),
                        'right'  => __('Right','finanzia'),
                        'bottom' => __('Bottom','finanzia'),
                        'left'   => __('Left','finanzia')
                    ),
                    'default' => 'top',
                    'condition' => [
                        'title_display' => 'yes'
                    ]
                ]
            );
            $widget->add_control(
                'show_label',
                [
                    'label'        => esc_html__( 'Show Label', 'finanzia' ),
                    'type'         => Controls_Manager::SWITCHER,
                    'return_value' => 'yes',
                    'default'      => 'yes' 
                ]
            );
            // Background
            $widget->add_control(
                'bg_gradient',
                [
                    'label'   => esc_html__( 'Gradient Background', 'finanzia' ),
                    'type'    => Controls_Manager::SELECT,
                    'options' => finanzia_elementor_gradient_opts(),
                    'default' => 'dark-above-img6',
                    'condition' => [
                        'layout' => ['2','3']
                    ],
                    'separator' => 'before'
                ]
            );
        $widget->end_controls_section();
    }
}