<?php
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
if (!function_exists('finanzia_widget_cms_blog_carousel_register_controls')) {
    add_action('etc_widget_cms_blog_carousel_register_controls', 'finanzia_widget_cms_blog_carousel_register_controls', 10, 1);
    function finanzia_widget_cms_blog_carousel_register_controls($widget)
    {
        // Post term options
        $post_term_options = etc_get_grid_term_options('post');
        // Layout Settings
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia' ),
                'tab' => \Elementor\Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__('Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => finanzia_elementor_post_layouts()
                ]
            );
        $widget->end_controls_section();
        // Content Tab Start
        // Source Section Start
        $widget->start_controls_section(
            'source_section',
            [
                'label' => esc_html__('Source', 'finanzia'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $widget->add_control(
            'source',
            [
                'label' => esc_html__('Select Categories', 'finanzia'),
                'type' => Controls_Manager::SELECT2,
                'multiple' => true,
                'options' => $post_term_options,
            ]
        );
        $widget->add_control(
            'orderby',
            [
                'label' => esc_html__('Order By', 'finanzia'),
                'type' => Controls_Manager::SELECT,
                'default' => 'date',
                'options' => [
                    'date' => esc_html__('Date', 'finanzia'),
                    'ID' => esc_html__('ID', 'finanzia'),
                    'author' => esc_html__('Author', 'finanzia'),
                    'title' => esc_html__('Title', 'finanzia'),
                    'rand' => esc_html__('Random', 'finanzia'),
                ],
            ]
        );
        $widget->add_control(
            'order',
            [
                'label' => esc_html__('Sort Order', 'finanzia'),
                'type' => Controls_Manager::SELECT,
                'default' => 'desc',
                'options' => [
                    'desc' => esc_html__('Descending', 'finanzia'),
                    'asc' => esc_html__('Ascending', 'finanzia'),
                ],
            ]
        );
        $widget->add_control(
            'limit',
            [
                'label' => esc_html__('Total items', 'finanzia'),
                'type' => Controls_Manager::NUMBER,
                'default' => '6',
            ]
        );
        $widget->end_controls_section();
        // Source Section End
        // Display Section Start
        $widget->start_controls_section(
            'display_section',
            [
                'label' => esc_html__('Content Display', 'finanzia'),
                'tab' => Controls_Manager::TAB_SETTINGS,
            ]
        );
            $widget->add_group_control(
                Group_Control_Image_Size::get_type(),
                [
                    'name'    => 'thumbnail',
                    'default' => 'custom',
                ]
            );
            $widget->add_control(
                'num_line',
                [
                    'label'       => esc_html__('Excerpt Length', 'finanzia'),
                    'description' => esc_html__('Enter number of line you want to show, max is 10', 'finanzia'),
                    'type'        => Controls_Manager::SLIDER,
                    'range' => [
                        'px' => [
                            'min' => 1,
                            'max' => 10,
                        ]
                    ],
                    'default' => [
                        'size' => 3,
                    ],
                    'separator'   => 'before',
                ]
            );

            $widget->add_control(
                'readmore_text',
                [
                    'label'       => esc_html__('Readmore Text', 'finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'placeholder' => esc_html__('Read More','finanzia'),
                ]
            );
        $widget->end_controls_section();
        // Display Section End
        // Carousel Section Start
        finanzia_elementor_carousel_settings($widget);
    }
}
