<?php
use Elementor\Controls_Manager;
use Elementor\Repeater;
if (!function_exists('finanzia_widget_cms_accordion_register_controls')) {
    add_action('etc_widget_cms_accordion_register_controls', 'finanzia_widget_cms_accordion_register_controls', 10, 1);
    function finanzia_widget_cms_accordion_register_controls($widget)
    {
        // Layout Section Start 
        $widget->start_controls_section(
            'layout_section',
            [
                'label' => esc_html__('Layout', 'finanzia'),
                'tab'   => Controls_Manager::TAB_LAYOUT,
            ]
        );
            $widget->add_control(
                'layout',
                [
                    'label'   => esc_html__( 'Templates', 'finanzia' ),
                    'type'    => Elementor_Theme_Core::LAYOUT_CONTROL,
                    'default' => '1',
                    'options' => [
                        '1' => [
                            'label' => esc_html__( 'Layout 1', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_accordion/layout/1.webp'
                        ],
                        '2' => [
                            'label' => esc_html__( 'Layout 2', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_accordion/layout/2.webp'
                        ],
                        '-single-service' => [
                            'label' => esc_html__( 'Single Service', 'finanzia' ),
                            'image' => get_template_directory_uri() . '/elementor/templates/widgets/cms_accordion/layout/single-service.webp'
                        ]
                    ]
                ]
            );
        $widget->end_controls_section();
        // Heading Section Start
        $widget->start_controls_section(
            'section_heading',
            [
                'label' => esc_html__('Heading Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'smallheading_text',
                [
                    'label'       => esc_html__( 'Small Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is small heading',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true,
                    'condition'   => [
                        'layout' => ['1','2']
                    ]                    
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'smallheading_color',
                'label'     => esc_html__( 'Small Heading Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-smallheading' => 'color: {{VALUE}};',
                ],
                'separator'   => 'after',
                'condition'   => [
                    'smallheading_text!' => '',
                    'layout' => ['1','2']
                ]
            ]);
            $widget->add_control(
                'heading_text',
                [
                    'label'       => esc_html__( 'Heading', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'This is the heading',
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'label_block' => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'heading_color',
                'label'    => esc_html__( 'Heading Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-heading, {{WRAPPER}} .cms-heading a' => 'color: {{VALUE}};',
                ],
                'separator'   => 'after'
            ]);
            $widget->add_control(
                'description_text',
                [
                    'label'       => esc_html__( 'Description', 'finanzia' ),
                    'type'        => Controls_Manager::TEXTAREA,
                    'default'     => 'There are many variations of passages of Lorem Ipsum available, but the majority have suffered alteration in some form, by injected humour', 
                    'placeholder' => esc_html__( 'Enter your text', 'finanzia' ),
                    'rows'        => 10,
                    'show_label'  => true
                ]
            );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'description_color',
                'label'     => esc_html__( 'Description Color', 'finanzia' ),
                'selector' => [
                    '{{WRAPPER}} .cms-desc' => 'color: {{VALUE}};',
                ]
            ]);
            // Button #1
            finanzia_elementor_link_settings($widget, [
                'name'        => 'link1_',
                'mode'        => 'btn',
                'group'       => false,
                'label'       => esc_html__('Button #1 Settings', 'finanzia'),
                'color_label' => esc_html__('Button', 'finanzia'),
                'condition'   => [
                    'layout' => ['1','2']
                ]
            ]);
            // Button #2
            finanzia_elementor_link_settings($widget, [
                'name'        => 'link2_',
                'mode'        => 'btn',
                'group'       => false,
                'label'       => esc_html__('Button #2 Settings', 'finanzia'),
                'color_label' => esc_html__('Button', 'finanzia'),
                'condition'   => [
                    'layout' => ['1','2']
                ]
            ]);
        $widget->end_controls_section();
        // accordion Section Start
        $widget->start_controls_section(
            'section_cms_accordion',
            [
                'label' => esc_html__('Accordion Settings', 'finanzia'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
            $widget->add_control(
                'active_section',
                [
                    'label'     => esc_html__( 'Active section', 'finanzia' ),
                    'type'      => Controls_Manager::NUMBER,
                    'default'   => '1',
                    'min'       => '0',
                    'max'       => '50',
                    'separator' => 'after',
                ]
            );
            $repeater = new Repeater();
            $repeater->add_control(
                'ac_title',
                [
                    'label'       => esc_html__( 'Title', 'finanzia' ),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => 'Title',
                    'placeholder' => esc_html__( 'Enter your title', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'ac_content',
                [
                    'label'       => esc_html__( 'Content', 'finanzia' ),
                    'type'        => \Elementor\Controls_Manager::TEXTAREA,
                    'default'     => 'Item content. Click the edit button to change this text.',
                    'placeholder' => esc_html__( 'Enter your content', 'finanzia' ),
                    'label_block' => true,
                ]
            );
            // Button
            $repeater->add_control(
                'ac_document_text',
                [
                    'label'       => esc_html__('Document', 'finanzia'),
                    'type'        => Controls_Manager::TEXT,
                    'default'     => '',
                    'label_block' => true,
                ]
            );
            $repeater->add_control(
                'ac_document',
                [
                    'label'       => esc_html__('Upload Document', 'finanzia'),
                    'type'        => Controls_Manager::MEDIA,
                    'media_types' => ['image', 'video', 'application/pdf', 'application/doc', 'application/docx'],
                    'default'     => [
                        'url' => get_template_directory_uri() . '/assets/doc/CMS-Brochure.pdf',
                    ],
                    'condition' => [
                        'ac_document_text!' => ''
                    ],
                    'label_block' => false,
                    'skin'        => 'inline'  
                ]
            );
            $widget->add_control(
                'cms_accordion',
                [
                    'label' => esc_html__('List', 'finanzia'),
                    'type' => Controls_Manager::REPEATER,
                    'fields' => $repeater->get_controls(),
                    'default' => [
                        [
                            'ac_title'   => 'Title',
                            'ac_content' => 'Item content. Click the edit button to change this text.',
                        ],
                        [
                            'ac_title'   => 'Title',
                            'ac_content' => 'Item content. Click the edit button to change this text.',
                        ],
                    ],
                    'title_field' => '{{{ ac_title }}}',
                ]
            );
        $widget->end_controls_section(); // accordion Section End
        //  Style tab
        $widget->start_controls_section(
            'style_section',
            [
                'label' => esc_html__('Style Settings','finanzia'),
                'tab'   => Controls_Manager::TAB_STYLE
            ]
        );
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'border_color',
                'label'    => esc_html__( 'Border Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'title_color',
                'label'    => esc_html__( 'Title Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'title_active_color',
                'label'    => esc_html__( 'Title Active Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'content_color',
                'label'    => esc_html__( 'Content Color', 'finanzia' )
            ]);
            finanzia_elementor_colors_opts($widget,[
                'name'     => 'explain_icon_color',
                'label'    => esc_html__( 'Explain Icon Color', 'finanzia' )
            ]);
        $widget->end_controls_section();
    }
}
