<?php
/**
 * Plugin Name: Theme Core Options
 * Description: Theme Core Options
 * Plugin URI:  https://cmssuperheroes.com/
 * Version:     1.1.9
 * Author:      CMSSuperHeroes
 * Author URI:  https://cmssuperheroes.com/
 * Text Domain: theme-core-options
 */

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

define('TCO_TEXT_DOMAIN', 'theme-core-options');
define('TCO_PATH', __DIR__);
define('TCO_URL', plugin_dir_url(__FILE__));
define('TCO_TEMPLATE_PATH', 'theme-core-options' . DIRECTORY_SEPARATOR);

final class Theme_Core_Options
{
    const BUTTON_SET_FIELD = 'button-set';
    const CODE_EDITOR_FIELD = 'code-editor';
    const COLOR_FIELD = 'color';
    const RGBA_COLOR_FIELD = 'rgba-color';
    const DIMENSIONS_FIELD = 'dimensions';
    const HEADING_FIELD = 'heading';
    const IMAGE_SELECT_FIELD = 'image-select';
    const LINK_COLOR_FIELD = 'link-color';
    const MEDIA_FIELD = 'media';
    const RADIO_FIELD = 'radio';
    const SELECT_FIELD = 'select';
    const SLIDER_FIELD = 'slider';
    const SPACING_FIELD = 'spacing';
    const SWITCH_FIELD = 'switch';
    const TEXT_FIELD = 'text';
    const TEXTAREA_FIELD = 'textarea';
    const TYPOGRAPHY_FIELD = 'typography';
    const REPEATER_FIELD = 'repeater';
    const BACKGROUND_FIELD = 'background';
    const ICON_PICKER_FIELD = 'icon-picker';
    const COLOR_SET_FIELD = 'color-set';

    private static $_instance = null;
    public $menu_page;
    public $scss;
    public $theme_options;
    public $page_options;
    public $tax_options;
    public $user_options;
    public $woocommerce_attribute_options;
    public $ajax_handle;

    public static function instance()
    {

        if (is_null(self::$_instance)) {
            self::$_instance = new self();
        }

        return self::$_instance;

    }

    public function __construct()
    {
        add_action('plugins_loaded', [$this, 'plugins_loaded']);
        add_action('init', [$this, 'i18n']);
        add_action('init', [$this, 'init']);

        add_action('wp_enqueue_scripts', [$this, 'enqueue']);
        add_action('admin_enqueue_scripts', [$this, 'admin_enqueue']);
    }

    public function plugins_loaded()
    {
        require_once(__DIR__ . '/inc/helpers/template.php');
        require_once(__DIR__ . '/inc/helpers/common.php');
    }

    public function i18n()
    {
        load_plugin_textdomain(TCO_TEXT_DOMAIN);
    }

    public function init()
    {
        if (!class_exists('TCOMenuPage')) {
            require_once TCO_PATH . '/inc/classes/class-menu-page.php';
            $this->menu_page = new TCOMenuPage();
        }

        if (!class_exists('TCOScss')) {
            if(false){
                require_once TCO_PATH . '/inc/classes/class-scss.php';
                $this->scss = new TCOScss();
                $this->scss->compile();
            }
        }

        if (!class_exists('TCOThemeOptions')) {
            require_once TCO_PATH . '/inc/classes/class-theme-options.php';
            $enable_theme_options_args_sample = apply_filters('enable_theme_options_args_sample', false);
            if ($enable_theme_options_args_sample) {
                require_once TCO_PATH . '/inc/helpers/theme-options-sample.php';
            }
            $this->theme_options = new TCOThemeOptions();
        }

        if (!class_exists('TCOPageOptions')) {
            require_once TCO_PATH . '/inc/classes/class-page-options.php';
            $enable_page_options_args_sample = apply_filters('enable_page_options_args_sample', false);
            if ($enable_page_options_args_sample) {
                require_once TCO_PATH . '/inc/helpers/page-options-sample.php';
            }
            $this->page_options = new TCOPageOptions();
        }

        if (!class_exists('TCOTaxOptions')) {
            require_once TCO_PATH . '/inc/classes/class-tax-options.php';
            $enable_tax_options_args_sample = apply_filters('enable_tax_options_args_sample', false);
            if ($enable_tax_options_args_sample) {
                require_once TCO_PATH . '/inc/helpers/tax-options-sample.php';
            }
            $this->tax_options = new TCOTaxOptions();
        }

        if (!class_exists('TCOUserOptions')) {
            require_once TCO_PATH . '/inc/classes/class-user-options.php';
            $enable_user_options_args_sample = apply_filters('enable_user_options_args_sample', false);
            if ($enable_user_options_args_sample) {
                require_once TCO_PATH . '/inc/helpers/user-options-sample.php';
            }
            $this->user_options = new TCOUserOptions();
        }

        if (!class_exists('TCOWoocommerceAttributeOptions')) {
            require_once TCO_PATH . '/inc/classes/class-woocommerce-attribute-options.php';
            $enable_woocommmerce_attribute_options_args_sample = apply_filters('enable_woocommmerce_attribute_options_args_sample', false);
            if ($enable_woocommmerce_attribute_options_args_sample) {
                require_once TCO_PATH . '/inc/helpers/woocommerce-attribute-options-sample.php';
            }
            $this->woocommerce_attribute_options = new TCOWoocommerceAttributeOptions();
        }

        if (!class_exists('TCOAjaxHandle')) {
            require_once TCO_PATH . '/inc/classes/class-ajax-handle.php';
            $this->ajax_handle = new TCOAjaxHandle();
        }
        // added by Chinh Duong Manh
        require_once TCO_PATH . '/inc/theme/theme.php';
    }

    public function enqueue()
    {
        /* Styles */

        /* Scripts */
    }

    public function admin_enqueue()
    {
        global $pagenow;

        // Add the color picker css file
        wp_enqueue_style('wp-color-picker');

        /* Icon Picker */
        wp_enqueue_style('jquery.fonticonpicker.min.css', TCO_URL . 'assets/lib/iconpicker/css/jquery.fonticonpicker.min.css', array(), 'all');
        wp_enqueue_style('jquery.fonticonpicker.grey.min.css', TCO_URL . 'assets/lib/iconpicker/themes/grey-theme/jquery.fonticonpicker.grey.min.css', array(), 'all');
        wp_enqueue_script('jquery.fonticonpicker.js', TCO_URL . 'assets/lib/iconpicker/jquery.fonticonpicker.js', array('jquery'));
        /* Icon Picker */

        wp_enqueue_style('fontawesome-css', TCO_URL . 'assets/lib/fontawesome/css/all.css', [], '5.15.3');
        wp_enqueue_style('tco-bootstrap-css', TCO_URL . 'assets/css/bootstrap.css', [], '4.5.0');
        wp_enqueue_style('select2-css', TCO_URL . 'assets/css/select2.min.css', [], '4.0.12');
        wp_enqueue_style('tco-admin-css', TCO_URL . 'assets/css/admin/main.css', [], '1.0.0');
        wp_enqueue_style('tco-plugin-css', TCO_URL . 'assets/css/admin/plugin.css', [], '1.0.0');

        wp_enqueue_media();
        // Add the color picker js file
        wp_enqueue_script('webfont', 'https://ajax.googleapis.com/ajax/libs/webfont/1.6.26/webfont.js');
        wp_enqueue_script('wp-color-picker');
        wp_enqueue_script('wp-color-picker-alpha', TCO_URL . 'assets/lib/wp-color-picker-alpha/dist/wp-color-picker-alpha.min.js', ['jquery', 'wp-color-picker'], '3.0.0');
        wp_enqueue_script('select2-js', TCO_URL . 'assets/js/select2.min.js', ['jquery'], '4.0.12');
        wp_enqueue_script('underscore', TCO_URL . 'assets/js/underscore.min.js', [], '1.11.0');

        wp_enqueue_script('tco-helper', TCO_URL . 'assets/js/helper.js', ['jquery'], '1.0.0');
        wp_enqueue_script('tco-template', TCO_URL . 'assets/js/template.js', ['jquery'], '1.0.0');
        wp_enqueue_script('tco-tabs', TCO_URL . 'assets/js/tabs.js', ['jquery'], '1.0.0');
        wp_enqueue_script('tco-form', TCO_URL . 'assets/js/form.js', ['jquery'], '1.0.0');
        wp_enqueue_script('tco-repeater', TCO_URL . 'assets/js/repeater.js', ['jquery'], '1.0.0');
        wp_enqueue_script('tco-accordion', TCO_URL . 'assets/js/accordion.js', ['jquery'], '1.0.0');
        wp_enqueue_script('tco-admin-js', TCO_URL . 'assets/js/admin/main.js', ['jquery'], '1.0.0');

        if (isset($_GET['page']) && $_GET['page'] == TCOMenuPage::MAIN_PAGE_SLUG) {
            wp_enqueue_script('tco-theme-options-js', TCO_URL . 'assets/js/admin/theme-options.js', ['jquery'], '1.0.0');
        }

        if (in_array($pagenow, ['post.php', 'post-new.php'])) {
            wp_enqueue_script('tco-page-options-js', TCO_URL . 'assets/js/admin/page-options.js', ['jquery'], '1.0.0');
        }

        if (in_array($pagenow, ['edit-tags.php', 'term.php'])) {
            wp_enqueue_script('tco-tax-options-js', TCO_URL . 'assets/js/admin/tax-options.js', ['jquery'], '1.0.0');
        }

        if (in_array($pagenow, ['user-new.php', 'profile.php'])) {
            wp_enqueue_script('tco-user-options-js', TCO_URL . 'assets/js/admin/user-options.js', ['jquery'], '1.0.0');
        }

        if (isset($_GET['page']) && $_GET['page'] == 'product_attributes') {
            wp_enqueue_script('tco-woocommerce-attribute-options-js', TCO_URL . 'assets/js/admin/woocommerce-attribute-options.js', ['jquery'], '1.0.0');
        }

        $theme = wp_get_theme();
        $theme_logo = apply_filters('tco_theme_logo', '');
        $google_font = TCO_PATH . '/inc/helpers/googlefonts.php';
        $fonts = include $google_font;
        $std_fonts = [
            "Arial, Helvetica, sans-serif" => "Arial, Helvetica, sans-serif",
            "'Arial Black', Gadget, sans-serif" => "'Arial Black', Gadget, sans-serif",
            "'Bookman Old Style', serif" => "'Bookman Old Style', serif",
            "'Comic Sans MS', cursive" => "'Comic Sans MS', cursive",
            "Courier, monospace" => "Courier, monospace",
            "Garamond, serif" => "Garamond, serif",
            "Georgia, serif" => "Georgia, serif",
            "Impact, Charcoal, sans-serif" => "Impact, Charcoal, sans-serif",
            "'Lucida Console', Monaco, monospace" => "'Lucida Console', Monaco, monospace",
            "'Lucida Sans Unicode', 'Lucida Grande', sans-serif" => "'Lucida Sans Unicode', 'Lucida Grande', sans-serif",
            "'MS Sans Serif', Geneva, sans-serif" => "'MS Sans Serif', Geneva, sans-serif",
            "'MS Serif', 'New York', sans-serif" => "'MS Serif', 'New York', sans-serif",
            "'Palatino Linotype', 'Book Antiqua', Palatino, serif" => "'Palatino Linotype', 'Book Antiqua', Palatino, serif",
            "Tahoma,Geneva, sans-serif" => "Tahoma, Geneva, sans-serif",
            "'Times New Roman', Times,serif" => "'Times New Roman', Times, serif",
            "'Trebuchet MS', Helvetica, sans-serif" => "'Trebuchet MS', Helvetica, sans-serif",
            "Verdana, Geneva, sans-serif" => "Verdana, Geneva, sans-serif",
        ];
        $default_font_weights = [
            '400' => 'Normal 400',
            '700' => 'Bold 700',
            '400italic' => 'Normal 400 Italic',
            '700italic' => 'Bold 700 Italic'
        ];

        $font_awesome_icons = TCO_PATH . '/inc/helpers/font-awesome-icons.php';
        $default_icons = include $font_awesome_icons;
        $icon_picker_options = apply_filters('tco_icon_picker_options', $default_icons);

        wp_localize_script('tco-admin-js', 'theme_core_options_configs', [
            'ajax_url' => admin_url('admin-ajax.php'),
            'home_url' => home_url(),
            'theme_name' => $theme->get('Name'),
            'theme_version' => $theme->get('Version'),
            'theme_logo' => $theme_logo,
            'google_fonts' => $fonts,
            'std_fonts' => $std_fonts,
            'default_font_weights' => $default_font_weights,
            'icon_picker_options' => $icon_picker_options,
        ]);
    }
}

$GLOBALS['theme_core_options'] = Theme_Core_Options::instance();