<?php
/* Category */
add_filter('tco_category_tax_options_args', 'tco_category_tax_options_args_sample', 9);
function tco_category_tax_options_args_sample()
{
    $args = [
        'general' => [
            'title' => esc_html__('General', TCO_TEXT_DOMAIN),
            'fields' => [
                'post_content_padding' => [
                    'type' => Theme_Core_Options::SPACING_FIELD,
                    'title' => esc_html__('Content Padding', TCO_TEXT_DOMAIN),
                    'subtitle' => esc_html__('Content site paddings.', TCO_TEXT_DOMAIN),
                    'description' => esc_html__('Default: Theme Option.', TCO_TEXT_DOMAIN),
                    'right' => false,
                    'left' => false,
                    'mode' => 'padding',
                    'output' => [
                        '.single-post #content'
                    ],
                ],
                'show_sidebar_post' => [
                    'type' => Theme_Core_Options::SWITCH_FIELD,
                    'title' => esc_html__('Custom Sidebar', TCO_TEXT_DOMAIN),
                ],
                'sidebar_post_pos' => [
                    'type' => Theme_Core_Options::BUTTON_SET_FIELD,
                    'title' => esc_html__('Sidebar Position', TCO_TEXT_DOMAIN),
                    'options' => array(
                        'left' => esc_html__('Left', TCO_TEXT_DOMAIN),
                        'right' => esc_html__('Right', TCO_TEXT_DOMAIN),
                        'none' => esc_html__('Disabled', TCO_TEXT_DOMAIN)
                    ),
                    'default' => 'right',
                    'required' => [
                        'show_sidebar_post',
                        '=',
                        1,
                    ]
                ],
            ],
        ],
    ];

    return $args;
}

/* Category */
?>