<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 *
 */
class TCOWoocommerceAttributeOptions
{
    function __construct()
    {
        $this->init();
    }

    function init()
    {
        $options_args = apply_filters('tco_woocommerce_attribute_options_args', []);
        update_option('tco_woocommerce_attribute_options_args', $options_args);
        if(is_array($options_args) && count($options_args) > 0){
            add_action('woocommerce_after_add_attribute_fields', [$this, 'add_custom_fields']);
            add_action('woocommerce_after_edit_attribute_fields', [$this, 'add_custom_fields']);
        }
        add_action('woocommerce_attribute_added', [$this, 'save_options']);
        add_action('woocommerce_attribute_updated', [$this, 'save_options']);
        add_action('woocommerce_attribute_deleted', [$this, 'delete_options']);
    }

    public function add_custom_fields()
    {
        $edit = isset($_GET['edit']) ? absint($_GET['edit']) : 0;
        $attribute = wc_get_attribute($edit);
        tco_get_template_file_e('woocommerce_attribute_custom_fields.php', ['attribute' => $attribute]);
    }

    function get_options_args()
    {
        $options_args = get_option('tco_woocommerce_attribute_options_args', []);

        return $options_args;
    }

    function get_options($id = 0)
    {
        $attribute = wc_get_attribute($id);
        $options = [];
        if ($attribute) {
            $options = get_option("tco_woocommerce_attribute_options_{$attribute->id}", []);
        }
        return $options;
    }

    function set_options($options, $id = 0)
    {
        $attribute = wc_get_attribute($id);
        if ($attribute) {
            update_option("tco_woocommerce_attribute_options_{$attribute->id}", $options);
        }
    }

    function save_options($id)
    {
        unset($_POST['attribute_label']);
        unset($_POST['attribute_name']);
        unset($_POST['attribute_public']);
        unset($_POST['attribute_orderby']);
        unset($_POST['_wpnonce']);
        unset($_POST['_wp_http_referer']);
        unset($_POST['tco_woocommerce_attribute_id']);

        $attribute = wc_get_attribute($id);
        if ($attribute) {
            update_option("tco_woocommerce_attribute_options_{$attribute->id}", $_POST);
        }
    }

    function delete_options($id)
    {
        $attribute = wc_get_attribute($id);
        if ($attribute) {
            delete_option("tco_woocommerce_attribute_options_{$attribute->id}");
        }
    }
}