<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 *
 */
class TCOThemeOptions
{
    const DEFAULT_THEME_OPTIONS_ARGS_NAME = 'tco_theme_options_args';
    const DEFAULT_THEME_OPTIONS_NAME = 'tco_theme_options';

    protected $theme_options_args_name;
    protected $theme_options_name;

    function __construct()
    {
        $this->theme_options_args_name = apply_filters('tco_theme_options_args_name', self::DEFAULT_THEME_OPTIONS_ARGS_NAME);
        $this->theme_options_name = apply_filters('tco_theme_options_name', self::DEFAULT_THEME_OPTIONS_NAME);

        $this->init();
    }

    function init()
    {
        $theme_options_args = apply_filters('tco_theme_options_args', []);
        update_option($this->theme_options_args_name, $theme_options_args);

        add_action('wp_head', [$this, 'generate_css']);
    }

    function get_theme_options_args_name()
    {
        return $this->theme_options_args_name;
    }

    function get_theme_options_name()
    {
        return $this->theme_options_name;
    }

    function get_theme_options_args()
    {
        return get_option($this->theme_options_args_name, []);
    }

    function get_theme_options()
    {
        return get_option($this->theme_options_name, []);
    }

    function get_theme_option($option_name, $default = false)
    {
        $options = $this->get_theme_options();

        if (empty($options) || !isset($options[$option_name]) || empty($options[$option_name])) {
            return $default;
        }

        if (is_array($options[$option_name]) && is_array($default)) {
            foreach ($options[$option_name] as $key => $value) {
                if (isset($default[$key]) && empty($value)) {
                    $options[$option_name][$key] = $default[$key];
                }
            }
        }

        return $options[$option_name];
    }

    function set_theme_options($theme_options)
    {
        update_option($this->theme_options_name, $theme_options);
    }

    function generate_css()
    {
        $theme_options_args = $this->get_theme_options_args();
        if (!empty($theme_options_args)) {
            foreach ($theme_options_args as $tabKey => $tabArgs) {
                if (!empty($tabArgs['sections'])) {
                    $sections = $tabArgs['sections'];
                    foreach ($sections as $sectionId => $sectionArgs) {
                        if (!empty($sectionArgs['fields'])) {
                            $fields = $sectionArgs['fields'];
                            foreach ($fields as $fieldId => $fieldArgs) {
                                if (isset($fieldArgs['output']) && !empty($fieldArgs['output'])) {
                                    $output = $fieldArgs['output'];
                                    switch ($fieldArgs['type']) {
                                        case Theme_Core_Options::TYPOGRAPHY_FIELD :
                                            $enableFontFamily = true;
                                            $enableFontBackup = true;
                                            $enableFontStyle = true;
                                            $enableFontSubsets = true;
                                            $enableLetterSpacing = false;
                                            $enableFontSize = true;
                                            $enableColor = true;
                                            $enableLineHeight = true;
                                            if (isset($fieldArgs['font_family'])) {
                                                $enableFontFamily = $fieldArgs['font_family'];
                                            }
                                            if (isset($fieldArgs['font_backup'])) {
                                                $enableFontBackup = $fieldArgs['font_backup'];
                                            }
                                            if (isset($fieldArgs['font_style'])) {
                                                $enableFontStyle = $fieldArgs['font_style'];
                                            }
                                            if (isset($fieldArgs['font_subsets'])) {
                                                $enableFontSubsets = $fieldArgs['font_subsets'];
                                            }
                                            if (isset($fieldArgs['letter_spacing'])) {
                                                $enableLetterSpacing = $fieldArgs['letter_spacing'];
                                            }
                                            if (isset($fieldArgs['font_size'])) {
                                                $enableFontSize = $fieldArgs['font_size'];
                                            }
                                            if (isset($fieldArgs['color'])) {
                                                $enableColor = $fieldArgs['color'];
                                            }
                                            if (isset($fieldArgs['line_height'])) {
                                                $enableLineHeight = $fieldArgs['line_height'];
                                            }

                                            $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : null;
                                            $value = $this->get_theme_option($fieldId, $default);
                                            $font_family = isset($value['font_family']) && !empty($value['font_family']) ? $value['font_family'] : '';
                                            $font_family = str_replace('\\', '', $font_family);
                                            $font_backup = isset($value['font_backup']) && !empty($value['font_backup']) ? $value['font_backup'] : '';
                                            $font_backup = str_replace('\\', '', $font_backup);
                                            $font_style = isset($value['font_style']) && !empty($value['font_style']) ? $value['font_style'] : '';
                                            $font_subsets = isset($value['font_subsets']) && !empty($value['font_subsets']) ? $value['font_subsets'] : '';
                                            $font_size = isset($value['font_size']) && !empty($value['font_size']) ? $value['font_size'] : '';
                                            $letter_spacing = isset($value['letter_spacing']) && !empty($value['letter_spacing']) ? $value['letter_spacing'] : '';
                                            $line_height = isset($value['line_height']) && !empty($value['line_height']) ? $value['line_height'] : '';
                                            $color = isset($value['color']) && !empty($value['color']) ? $value['color'] : '';
                                            $google_font = TCO_PATH . '/inc/helpers/googlefonts.php';
                                            $fonts = include $google_font;

                                            $styles = '';
                                            $link = '';
                                            if (!empty($font_family) && $enableFontFamily) {
                                                // Build Styles
                                                $styles .= 'font-family: ' . $font_family;
                                                if (!empty($font_backup) && $enableFontBackup) {
                                                    $styles .= ', ' . $font_backup;
                                                }
                                                $styles .= ';';
                                                if (!empty($font_style) && $enableFontStyle) {
                                                    if (false !== strpos($font_style, 'italic')) {
                                                        $styles .= 'font-style: italic;';
                                                        $font_weight = str_replace('italic', '', $font_style);
                                                        $styles .= 'font-weight: ' . $font_weight . ';';
                                                    } else {
                                                        $styles .= 'font-style: normal;';
                                                        $styles .= 'font-weight: ' . $font_style . ';';
                                                    }
                                                }

                                                if (isset($fonts[$font_family])) {
                                                    $font_family = preg_replace('/\s+/', '+', $font_family);
                                                    $link = 'https://fonts.googleapis.com/css?family=' . $font_family;
                                                    if (!empty($font_style) && $enableFontStyle) {
                                                        $link .= ':' . preg_replace('/\-/', ' ', $font_style);
                                                    }
                                                    if (!empty($font_subsets) && $enableFontSubsets) {
                                                        $link .= '&subset=' . $font_subsets;
                                                    }
                                                }
                                            }
                                            if (!empty($letter_spacing) && $enableLetterSpacing) {
                                                $styles .= 'letter-spacing: ' . $letter_spacing . 'px;';
                                            }
                                            if (!empty($font_size) && $enableFontSize) {
                                                $styles .= 'font-size: ' . $font_size . 'px;';
                                            }
                                            if (!empty($line_height) && $enableLineHeight) {
                                                $styles .= 'line-height: ' . $line_height . 'px;';
                                            }
                                            if (!empty($color) && $enableColor) {
                                                $styles .= 'color: ' . $color . ';';
                                            }
                                            if (is_string($output)) {
                                                $output = [$output];
                                            }
                                            ob_start();
                                            if (!empty($styles)):
                                                ?>
                                                <style id="<?php echo esc_attr($fieldId . '-' . getMiliseconds()); ?>">
                                                    <?php
                                                        if(is_array($output)){
                                                            foreach ($output as $selector){
                                                                echo $selector . ' { ' . $styles . ' } ';
                                                            }
                                                        }
                                                    ?>
                                                </style>
                                                <?php if (!empty($link)): ?>
                                                <link rel="stylesheet"
                                                      id="<?php echo esc_attr($fieldId . '-fonts-googleapis-' . getMiliseconds()); ?>"
                                                      href="<?php echo $link; ?>">
                                            <?php endif; ?>
                                            <?php
                                            endif;
                                            $dynamic_css = ob_get_clean();
                                            echo $dynamic_css;
                                            break;

                                        case Theme_Core_Options::SPACING_FIELD :
                                            $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : null;
                                            $value = $this->get_theme_option($fieldId, $default);
                                            $top = isset($value['top']) && !empty($value['top']) ? $value['top'] : '';
                                            $right = isset($value['right']) && !empty($value['right']) ? $value['right'] : '';
                                            $bottom = isset($value['bottom']) && !empty($value['bottom']) ? $value['bottom'] : '';
                                            $left = isset($value['left']) && !empty($value['left']) ? $value['left'] : '';
                                            $unit = isset($value['unit']) && !empty($value['unit']) ? $value['unit'] : 'px';
                                            $mode = isset($fieldArgs['mode']) && !empty($fieldArgs['mode']) ? $fieldArgs['mode'] : 'padding';

                                            $styles = '';
                                            if (!empty($top)) {
                                                $styles .= $mode . '-top: ' . $top . $unit . ';';
                                            }
                                            if (!empty($right)) {
                                                $styles .= $mode . '-right: ' . $right . $unit . ';';
                                            }
                                            if (!empty($bottom)) {
                                                $styles .= $mode . '-bottom: ' . $bottom . $unit . ';';
                                            }
                                            if (!empty($left)) {
                                                $styles .= $mode . '-left: ' . $left . $unit . ';';
                                            }
                                            ob_start();
                                            if (!empty($styles)):
                                                ?>
                                                <style id="<?php echo esc_attr($fieldId . '-' . getMiliseconds()); ?>">
                                                    <?php
                                                        if(is_array($output)){
                                                            foreach ($output as $selector){
                                                                echo $selector . ' { ' . $styles . ' } ';
                                                            }
                                                        }
                                                    ?>
                                                </style>
                                            <?php
                                            endif;
                                            $dynamic_css = ob_get_clean();
                                            echo $dynamic_css;
                                            break;

                                        case Theme_Core_Options::COLOR_FIELD :
                                            $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : null;
                                            $value = $this->get_theme_option($fieldId, $default);
                                            ob_start();
                                            if (!empty($value) && is_string($value)):
                                                ?>
                                                <style id="<?php echo esc_attr($fieldId . '-' . getMiliseconds()); ?>">
                                                    <?php
                                                        if(is_array($output)){
                                                            foreach ($output as $attr => $selector){
                                                                echo $selector . ' { ' . $attr . ': ' . $value . ' } ';
                                                            }
                                                        }
                                                    ?>
                                                </style>
                                            <?php
                                            endif;
                                            $dynamic_css = ob_get_clean();
                                            echo $dynamic_css;
                                            break;

                                        case Theme_Core_Options::COLOR_SET_FIELD :
                                            $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : [];
                                            $value = $this->get_theme_option($fieldId, []);
                                            ob_start();
                                            if (isset($fieldArgs['options']) && !empty($fieldArgs['options']) && is_array($fieldArgs['options'])) {
                                                foreach ($fieldArgs['options'] as $optionIndex => $optionLabel) {
                                                    $optionValue = '';
                                                    if (!isset($value[$optionIndex])) {
                                                        if (isset($default[$optionIndex])) {
                                                            $optionValue = $default[$optionIndex];
                                                        }
                                                    } else {
                                                        $optionValue = $value[$optionIndex];
                                                    }
                                                    if (!empty($optionValue)):
                                                        ?>
                                                        <style id="<?php echo esc_attr($fieldId . '-' . $optionIndex . '-' . getMiliseconds()); ?>">
                                                            <?php
                                                                if(is_array($output) && isset($output[$optionIndex]) && !empty($output[$optionIndex])){
                                                                    foreach ($output[$optionIndex] as $attr => $selector){
                                                                        echo $selector . ' { ' . $attr . ': ' . $optionValue . ' } ';
                                                                    }
                                                                }
                                                            ?>
                                                        </style>
                                                    <?php
                                                    endif;
                                                }
                                            }
                                            $dynamic_css = ob_get_clean();
                                            echo $dynamic_css;
                                            break;

                                        case Theme_Core_Options::BACKGROUND_FIELD :
                                            $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : null;
                                            $value = $this->get_theme_option($fieldId, $default);
                                            $bgColor = isset($value['background-color']) && !empty($value['background-color']) ? $value['background-color'] : '';
                                            $bgRepeat = isset($value['background-repeat']) && !empty($value['background-repeat']) ? $value['background-repeat'] : '';
                                            $bgClip = isset($value['background-clip']) && !empty($value['background-clip']) ? $value['background-clip'] : '';
                                            $bgOrigin = isset($value['background-origin']) && !empty($value['background-origin']) ? $value['background-origin'] : '';
                                            $bgSize = isset($value['background-size']) && !empty($value['background-size']) ? $value['background-size'] : '';
                                            $bgAttachment = isset($value['background-attachment']) && !empty($value['background-attachment']) ? $value['background-attachment'] : '';
                                            $bgPosition = isset($value['background-position']) && !empty($value['background-position']) ? $value['background-position'] : '';
                                            $bgImage = isset($value['background-image']) && !empty($value['background-image']) ? $value['background-image'] : '';
                                            $styles = '';
                                            if (!empty($bgColor)) {
                                                $styles .= 'background-color: ' . $bgColor . ';';
                                            }
                                            if (!empty($bgImage)) {
                                                $styles .= 'background-image: url("' . $bgImage . '");';
                                            }
                                            if (!empty($bgRepeat)) {
                                                $styles .= 'background-repeat: ' . $bgRepeat . ';';
                                            }
                                            if (!empty($bgClip)) {
                                                $styles .= 'background-clip: ' . $bgClip . ';';
                                            }
                                            if (!empty($bgOrigin)) {
                                                $styles .= 'background-origin: ' . $bgOrigin . ';';
                                            }
                                            if (!empty($bgSize)) {
                                                $styles .= 'background-size: ' . $bgSize . ';';
                                            }
                                            if (!empty($bgAttachment)) {
                                                $styles .= 'background-attachment: ' . $bgAttachment . ';';
                                            }
                                            if (!empty($bgPosition)) {
                                                $styles .= 'background-position: ' . $bgPosition . ';';
                                            }
                                            if (is_string($output)) {
                                                $output = [$output];
                                            }
                                            ob_start();
                                            if (!empty($styles)):
                                                ?>
                                                <style id="<?php echo esc_attr($fieldId . '-' . getMiliseconds()); ?>">
                                                    <?php
                                                        if(is_array($output)){
                                                            foreach ($output as $selector){
                                                                echo $selector . ' { ' . $styles . ' } ';
                                                            }
                                                        }
                                                    ?>
                                                </style>
                                            <?php
                                            endif;
                                            $dynamic_css = ob_get_clean();
                                            echo $dynamic_css;
                                            break;
                                    }
                                }
                            }
                        }
                    }
                } else if (!empty($tabArgs['fields'])) {
                    $fields = $tabArgs['fields'];
                    foreach ($fields as $fieldId => $fieldArgs) {
                        if (isset($fieldArgs['output']) && !empty($fieldArgs['output'])) {
                            $output = $fieldArgs['output'];
                            switch ($fieldArgs['type']) {
                                case Theme_Core_Options::TYPOGRAPHY_FIELD :
                                    $enableFontFamily = true;
                                    $enableFontBackup = true;
                                    $enableFontStyle = true;
                                    $enableFontSubsets = true;
                                    $enableLetterSpacing = false;
                                    $enableFontSize = true;
                                    $enableColor = true;
                                    $enableLineHeight = true;
                                    if (isset($fieldArgs['font_family'])) {
                                        $enableFontFamily = $fieldArgs['font_family'];
                                    }
                                    if (isset($fieldArgs['font_backup'])) {
                                        $enableFontBackup = $fieldArgs['font_backup'];
                                    }
                                    if (isset($fieldArgs['font_style'])) {
                                        $enableFontStyle = $fieldArgs['font_style'];
                                    }
                                    if (isset($fieldArgs['font_subsets'])) {
                                        $enableFontSubsets = $fieldArgs['font_subsets'];
                                    }
                                    if (isset($fieldArgs['letter_spacing'])) {
                                        $enableLetterSpacing = $fieldArgs['letter_spacing'];
                                    }
                                    if (isset($fieldArgs['font_size'])) {
                                        $enableFontSize = $fieldArgs['font_size'];
                                    }
                                    if (isset($fieldArgs['color'])) {
                                        $enableColor = $fieldArgs['color'];
                                    }
                                    if (isset($fieldArgs['line_height'])) {
                                        $enableLineHeight = $fieldArgs['line_height'];
                                    }

                                    $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : null;
                                    $value = $this->get_theme_option($fieldId, $default);
                                    $font_family = isset($value['font_family']) && !empty($value['font_family']) ? $value['font_family'] : '';
                                    $font_family = str_replace('\\', '', $font_family);
                                    $font_backup = isset($value['font_backup']) && !empty($value['font_backup']) ? $value['font_backup'] : '';
                                    $font_backup = str_replace('\\', '', $font_backup);
                                    $font_style = isset($value['font_style']) && !empty($value['font_style']) ? $value['font_style'] : '';
                                    $font_subsets = isset($value['font_subsets']) && !empty($value['font_subsets']) ? $value['font_subsets'] : '';
                                    $letter_spacing = isset($value['letter_spacing']) && !empty($value['letter_spacing']) ? $value['letter_spacing'] : '';
                                    $font_size = isset($value['font_size']) && !empty($value['font_size']) ? $value['font_size'] : '';
                                    $line_height = isset($value['line_height']) && !empty($value['line_height']) ? $value['line_height'] : '';
                                    $color = isset($value['color']) && !empty($value['color']) ? $value['color'] : '';
                                    $google_font = TCO_PATH . '/inc/helpers/googlefonts.php';
                                    $fonts = include $google_font;

                                    $styles = '';
                                    $link = '';
                                    if (!empty($font_family) && $enableFontFamily) {
                                        // Build Styles
                                        $styles .= 'font-family: ' . $font_family;
                                        if (!empty($font_backup) && $enableFontBackup) {
                                            $styles .= ', ' . $font_backup;
                                        }
                                        $styles .= ';';
                                        if (!empty($font_style) && $enableFontStyle) {
                                            if (false !== strpos($font_style, 'italic')) {
                                                $styles .= 'font-style: italic;';
                                                $font_weight = str_replace('italic', '', $font_style);
                                                $styles .= 'font-weight: ' . $font_weight . ';';
                                            } else {
                                                $styles .= 'font-style: normal;';
                                                $styles .= 'font-weight: ' . $font_style . ';';
                                            }
                                        }

                                        if (isset($fonts[$font_family])) {
                                            $font_family = preg_replace('/\s+/', '+', $font_family);
                                            $link = 'https://fonts.googleapis.com/css?family=' . $font_family;
                                            if (!empty($font_style) && $enableFontStyle) {
                                                $link .= ':' . preg_replace('/\-/', ' ', $font_style);
                                            }
                                            if (!empty($font_subsets) && $enableFontSubsets) {
                                                $link .= '&subset=' . $font_subsets;
                                            }
                                        }
                                    }
                                    if (!empty($letter_spacing) && $enableLetterSpacing) {
                                        $styles .= 'letter-spacing: ' . $letter_spacing . 'px;';
                                    }
                                    if (!empty($font_size) && $enableFontSize) {
                                        $styles .= 'font-size: ' . $font_size . 'px;';
                                    }
                                    if (!empty($line_height) && $enableLineHeight) {
                                        $styles .= 'line-height: ' . $line_height . 'px;';
                                    }
                                    if (!empty($color) && $enableColor) {
                                        $styles .= 'color: ' . $color . ';';
                                    }
                                    if (is_string($output)) {
                                        $output = [$output];
                                    }
                                    ob_start();
                                    ?>
                                    <style id="<?php echo esc_attr(Theme_Core_Options::TYPOGRAPHY_FIELD . '-' . getMiliseconds()); ?>">
                                        <?php
                                            if(is_array($output)){
                                                foreach ($output as $selector){
                                                    echo $selector . ' { ' . $styles . ' } ';
                                                }
                                            }
                                        ?>
                                    </style>
                                    <?php
                                    $dynamic_css = ob_get_clean();
                                    echo $dynamic_css;
                                    break;

                                case Theme_Core_Options::SPACING_FIELD :
                                    $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : null;
                                    $value = $this->get_theme_option($fieldId, $default);
                                    $top = isset($value['top']) && !empty($value['top']) ? $value['top'] : '';
                                    $right = isset($value['right']) && !empty($value['right']) ? $value['right'] : '';
                                    $bottom = isset($value['bottom']) && !empty($value['bottom']) ? $value['bottom'] : '';
                                    $left = isset($value['left']) && !empty($value['left']) ? $value['left'] : '';
                                    $unit = isset($value['unit']) && !empty($value['unit']) ? $value['unit'] : 'px';
                                    $mode = isset($fieldArgs['mode']) && !empty($fieldArgs['mode']) ? $fieldArgs['mode'] : 'padding';

                                    $styles = '';
                                    if (!empty($top)) {
                                        $styles .= $mode . '-top: ' . $top . $unit . ';';
                                    }
                                    if (!empty($right)) {
                                        $styles .= $mode . '-right: ' . $right . $unit . ';';
                                    }
                                    if (!empty($bottom)) {
                                        $styles .= $mode . '-bottom: ' . $bottom . $unit . ';';
                                    }
                                    if (!empty($left)) {
                                        $styles .= $mode . '-left: ' . $left . $unit . ';';
                                    }
                                    ob_start();
                                    ?>
                                    <style id="<?php echo esc_attr($fieldId . '-' . getMiliseconds()); ?>">
                                        <?php
                                            if(is_array($output)){
                                                foreach ($output as $selector){
                                                    echo $selector . ' { ' . $styles . ' } ';
                                                }
                                            }
                                        ?>
                                    </style>
                                    <?php
                                    $dynamic_css = ob_get_clean();
                                    echo $dynamic_css;
                                    break;

                                case Theme_Core_Options::COLOR_FIELD :
                                    $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : null;
                                    $value = $this->get_theme_option($fieldId, $default);
                                    ob_start();
                                    if (!empty($value)):
                                        ?>
                                        <style id="<?php echo esc_attr($fieldId . '-' . getMiliseconds()); ?>">
                                            <?php
                                                if(is_array($output)){
                                                    foreach ($output as $attr => $selector){
                                                        echo $selector . ' { ' . $attr . ': ' . $value . ' } ';
                                                    }
                                                }
                                            ?>
                                        </style>
                                    <?php
                                    endif;
                                    $dynamic_css = ob_get_clean();
                                    echo $dynamic_css;
                                    break;

                                case Theme_Core_Options::COLOR_SET_FIELD :
                                    $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : [];
                                    $value = $this->get_theme_option($fieldId, []);
                                    ob_start();
                                    if (isset($fieldArgs['options']) && !empty($fieldArgs['options']) && is_array($fieldArgs['options'])) {
                                        foreach ($fieldArgs['options'] as $optionIndex => $optionLabel) {
                                            $optionValue = '';
                                            if (!isset($value[$optionIndex])) {
                                                if (isset($default[$optionIndex])) {
                                                    $optionValue = $default[$optionIndex];
                                                }
                                            } else {
                                                $optionValue = $value[$optionIndex];
                                            }
                                            if (!empty($optionValue)):
                                                ?>
                                                <style id="<?php echo esc_attr($fieldId . '-' . $optionIndex . '-' . getMiliseconds()); ?>">
                                                    <?php
                                                        if(is_array($output) && isset($output[$optionIndex]) && !empty($output[$optionIndex])){
                                                            foreach ($output[$optionIndex] as $attr => $selector){
                                                                echo $selector . ' { ' . $attr . ': ' . $optionValue . ' } ';
                                                            }
                                                        }
                                                    ?>
                                                </style>
                                            <?php
                                            endif;
                                        }
                                    }
                                    $dynamic_css = ob_get_clean();
                                    echo $dynamic_css;
                                    break;

                                case Theme_Core_Options::BACKGROUND_FIELD :
                                    $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : null;
                                    $value = $this->get_theme_option($fieldId, $default);
                                    $bgColor = isset($value['background-color']) && !empty($value['background-color']) ? $value['background-color'] : '';
                                    $bgRepeat = isset($value['background-repeat']) && !empty($value['background-repeat']) ? $value['background-repeat'] : '';
                                    $bgClip = isset($value['background-clip']) && !empty($value['background-clip']) ? $value['background-clip'] : '';
                                    $bgOrigin = isset($value['background-origin']) && !empty($value['background-origin']) ? $value['background-origin'] : '';
                                    $bgSize = isset($value['background-size']) && !empty($value['background-size']) ? $value['background-size'] : '';
                                    $bgAttachment = isset($value['background-attachment']) && !empty($value['background-attachment']) ? $value['background-attachment'] : '';
                                    $bgPosition = isset($value['background-position']) && !empty($value['background-position']) ? $value['background-position'] : '';
                                    $bgImage = isset($value['background-image']) && !empty($value['background-image']) ? $value['background-image'] : '';
                                    $styles = '';
                                    if (!empty($bgColor)) {
                                        $styles .= 'background-color: ' . $bgColor . ';';
                                    }
                                    if (!empty($bgImage)) {
                                        $styles .= 'background-image: url(\'' . $bgImage . '\');';
                                    }
                                    if (!empty($bgRepeat)) {
                                        $styles .= 'background-repeat: ' . $bgRepeat . ';';
                                    }
                                    if (!empty($bgClip)) {
                                        $styles .= 'background-clip: ' . $bgClip . ';';
                                    }
                                    if (!empty($bgOrigin)) {
                                        $styles .= 'background-origin: ' . $bgOrigin . ';';
                                    }
                                    if (!empty($bgSize)) {
                                        $styles .= 'background-size: ' . $bgSize . ';';
                                    }
                                    if (!empty($bgAttachment)) {
                                        $styles .= 'background-attachment: ' . $bgAttachment . ';';
                                    }
                                    if (!empty($bgPosition)) {
                                        $styles .= 'background-position: ' . $bgPosition . ';';
                                    }
                                    if (is_string($output)) {
                                        $output = [$output];
                                    }
                                    ob_start();
                                    if (!empty($styles)):
                                        ?>
                                        <style id="<?php echo esc_attr($fieldId . '-' . getMiliseconds()); ?>">
                                            <?php
                                                if(is_array($output)){
                                                    foreach ($output as $selector){
                                                        echo $selector . ' { ' . $styles . ' } ';
                                                    }
                                                }
                                            ?>
                                        </style>
                                    <?php
                                    endif;
                                    $dynamic_css = ob_get_clean();
                                    echo $dynamic_css;
                                    break;
                            }
                        }
                    }
                }
            }
        }
    }
}