<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 *
 */
class TCOTaxOptions
{
    function __construct()
    {
        $this->init();
    }

    function init()
    {
        $taxonomies = get_taxonomies();
        $exclude_taxonomies = [
            'nav_menu',
            'link_category',
            'post_format',
            'wp_theme',
        ];
        foreach ($taxonomies as $taxonomy) {
            if (!in_array($taxonomy, $exclude_taxonomies)) {
                $tax_options_args = apply_filters("tco_{$taxonomy}_tax_options_args", []);
                update_option("tco_{$taxonomy}_tax_options_args", $tax_options_args);

                if (!empty($tax_options_args)) {
                    add_action("{$taxonomy}_add_form_fields", [$this, 'tax_custom_fields'], 10, 2);
                    add_action("{$taxonomy}_edit_form_fields", [$this, 'tax_custom_fields'], 10, 2);
                    add_action("saved_$taxonomy", [$this, 'saved_term'], 10, 3);
                }
            }
        }
    }

    public function tax_custom_fields($tag)
    {
        tco_get_template_file_e('tax_custom_fields.php', ['tag' => $tag]);
    }

    function get_tax_options_args($tax_name)
    {
        $page_options_args = get_option("tco_{$tax_name}_tax_options_args", []);

        return $page_options_args;
    }

    function get_tax_options($term_id = 0, $taxonomy = '')
    {
        $term = get_term_by('ID', $term_id, $taxonomy);
        $tax_options = [];
        if ($term) {
            $tax_options = get_term_meta($term->term_id, "tco_tax_options", true);
        }
        return $tax_options;
    }

    function saved_term($term_id, $tt_id, $taxonomy)
    {
        unset($_POST['tag_ID']);
        unset($_POST['taxonomy']);
        unset($_POST['action']);
        unset($_POST['name']);
        unset($_POST['slug']);
        unset($_POST['parent']);
        unset($_POST['description']);

        update_term_meta($term_id, "tco_tax_options", $_POST);
        foreach ($_POST as $key => $data) {
            update_term_meta($term_id, $key, $data);
        }
    }

    function get_tax_option($option_name, $default = false)
    {
        $id = get_the_ID();
        if (!is_archive() && is_home()) {
            if (!is_front_page()) {
                $page_for_posts = get_option('page_for_posts');
                $id = $page_for_posts;
            }
        }

        // Get page option for Shop Page
        if (class_exists('WooCommerce') && is_shop()) {
            $id = get_option('woocommerce_shop_page_id');
        }

        return $options = !empty($id) ? get_post_meta(intval($id), $option_name, true) : $default;
    }

    function set_page_options($page_options, $post_id = 0)
    {
        $post = get_post($post_id);
        if ($post && $post->ID && $post->post_type) {
            update_post_meta($post->ID, "tco_page_options", $page_options);
            foreach ($page_options as $key => $data) {
                update_post_meta($post->ID, $key, $data);
            }
        }
    }

    function generate_css($post_id = 0)
    {
        $page_options_args = $this->get_page_options_args();
        if (!empty($page_options_args)) {
            foreach ($page_options_args as $tabKey => $tabArgs) {
                if (!empty($tabArgs['sections'])) {
                    $sections = $tabArgs['sections'];
                    foreach ($sections as $sectionId => $sectionArgs) {
                        if (!empty($sectionArgs['fields'])) {
                            $fields = $sectionArgs['fields'];
                            foreach ($fields as $fieldId => $fieldArgs) {
                                if (isset($fieldArgs['output']) && !empty($fieldArgs['output'])) {
                                    $output = $fieldArgs['output'];
                                    switch ($fieldArgs['type']) {
                                        case Theme_Core_Options::TYPOGRAPHY_FIELD :
                                            $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : null;
                                            $value = $this->get_tax_option($fieldId, $default);
                                            $font_family = isset($value['font_family']) && !empty($value['font_family']) ? $value['font_family'] : '';
                                            $font_family = str_replace('\\', '', $font_family);
                                            $font_backup = isset($value['font_backup']) && !empty($value['font_backup']) ? $value['font_backup'] : '';
                                            $font_backup = str_replace('\\', '', $font_backup);
                                            $font_style = isset($value['font_style']) && !empty($value['font_style']) ? $value['font_style'] : '';
                                            $font_subsets = isset($value['font_subsets']) && !empty($value['font_subsets']) ? $value['font_subsets'] : '';
                                            $font_size = isset($value['font_size']) && !empty($value['font_size']) ? $value['font_size'] : '';
                                            $line_height = isset($value['line_height']) && !empty($value['line_height']) ? $value['line_height'] : '';
                                            $color = isset($value['color']) && !empty($value['color']) ? $value['color'] : '';
                                            $google_font = TCO_PATH . '/inc/helpers/googlefonts.php';
                                            $fonts = include $google_font;

                                            $styles = '';
                                            $link = '';
                                            if (!empty($font_family)) {
                                                // Build Styles
                                                $styles .= 'font-family: ' . $font_family;
                                                if (!empty($font_backup)) {
                                                    $styles .= ', ' . $font_backup;
                                                }
                                                $styles .= ';';
                                                if (!empty($font_style)) {
                                                    if (-1 !== strpos($font_style, 'italic')) {
                                                        $styles .= 'font-style: italic;';
                                                        $font_weight = str_replace('italic', '', $font_style);
                                                        $styles .= 'font-weight: ' . $font_weight . ';';
                                                    } else {
                                                        $styles .= 'font-style: normal;';
                                                        $styles .= 'font-weight: ' . $font_style . ';';
                                                    }
                                                }

                                                if (isset($fonts[$font_family])) {
                                                    $font_family = preg_replace('/\s+/', '+', $font_family);
                                                    $link = 'https://fonts.googleapis.com/css?family=' . $font_family;
                                                    if (!empty($font_style)) {
                                                        $link .= ':' . preg_replace('/\-/', ' ', $font_style);
                                                    }
                                                    if (!empty($font_subsets)) {
                                                        $link .= '&subset=' . $font_subsets;
                                                    }
                                                }
                                            }
                                            if (!empty($font_size)) {
                                                $styles .= 'font-size: ' . $font_size . 'px;';
                                            }
                                            if (!empty($line_height)) {
                                                $styles .= 'line-height: ' . $line_height . 'px;';
                                            }
                                            if (!empty($color)) {
                                                $styles .= 'color: ' . $color . ';';
                                            }
                                            if (is_string($output)) {
                                                $output = [$output];
                                            }
                                            ob_start();
                                            if (!empty($styles)):
                                                ?>
                                                <style id="<?php echo esc_attr($fieldId . '-' . getMiliseconds()); ?>">
                                                    <?php
                                                        if(is_array($output)){
                                                            foreach ($output as $selector){
                                                                echo $selector . ' { ' . $styles . ' } ';
                                                            }
                                                        }
                                                    ?>
                                                </style>
                                                <?php if (!empty($link)): ?>
                                                <link rel="stylesheet"
                                                      id="<?php echo esc_attr($fieldId . '-fonts-googleapis-' . getMiliseconds()); ?>"
                                                      href="<?php echo $link; ?>">
                                            <?php endif; ?>
                                            <?php
                                            endif;
                                            $dynamic_css = ob_get_clean();
                                            echo $dynamic_css;
                                            break;

                                        case Theme_Core_Options::SPACING_FIELD :
                                            $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : null;
                                            $value = $this->get_tax_option($fieldId, $default);
                                            $top = isset($value['top']) && !empty($value['top']) ? $value['top'] : '';
                                            $right = isset($value['right']) && !empty($value['right']) ? $value['right'] : '';
                                            $bottom = isset($value['bottom']) && !empty($value['bottom']) ? $value['bottom'] : '';
                                            $left = isset($value['left']) && !empty($value['left']) ? $value['left'] : '';
                                            $unit = isset($value['unit']) && !empty($value['unit']) ? $value['unit'] : 'px';
                                            $mode = isset($fieldArgs['mode']) && !empty($fieldArgs['mode']) ? $fieldArgs['mode'] : 'padding';

                                            $styles = '';
                                            if (!empty($top)) {
                                                $styles .= $mode . '-top: ' . $top . $unit . ';';
                                            }
                                            if (!empty($right)) {
                                                $styles .= $mode . '-right: ' . $right . $unit . ';';
                                            }
                                            if (!empty($bottom)) {
                                                $styles .= $mode . '-bottom: ' . $bottom . $unit . ';';
                                            }
                                            if (!empty($left)) {
                                                $styles .= $mode . '-left: ' . $left . $unit . ';';
                                            }
                                            ob_start();
                                            if (!empty($styles)):
                                                ?>
                                                <style id="<?php echo esc_attr($fieldId . '-' . getMiliseconds()); ?>">
                                                    <?php
                                                        if(is_array($output)){
                                                            foreach ($output as $selector){
                                                                echo $selector . ' { ' . $styles . ' } ';
                                                            }
                                                        }
                                                    ?>
                                                </style>
                                            <?php
                                            endif;
                                            $dynamic_css = ob_get_clean();
                                            echo $dynamic_css;
                                            break;

                                        case Theme_Core_Options::COLOR_FIELD :
                                            $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : null;
                                            $value = $this->get_tax_option($fieldId, $default);
                                            ob_start();
                                            if (!empty($value)):
                                                ?>
                                                <style id="<?php echo esc_attr($fieldId . '-' . getMiliseconds()); ?>">
                                                    <?php
                                                        if(is_array($output)){
                                                            foreach ($output as $attr => $selector){
                                                                echo $selector . ' { ' . $attr . ': ' . $value . ' } ';
                                                            }
                                                        }
                                                    ?>
                                                </style>
                                            <?php
                                            endif;
                                            $dynamic_css = ob_get_clean();
                                            echo $dynamic_css;
                                            break;
                                    }
                                }
                            }
                        }
                    }
                } else if (!empty($tabArgs['fields'])) {
                    $fields = $tabArgs['fields'];
                    foreach ($fields as $fieldId => $fieldArgs) {
                        if (isset($fieldArgs['output']) && !empty($fieldArgs['output'])) {
                            $output = $fieldArgs['output'];
                            switch ($fieldArgs['type']) {
                                case Theme_Core_Options::TYPOGRAPHY_FIELD :
                                    $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : null;
                                    $value = $this->get_tax_option($fieldId, $default);
                                    $font_family = isset($value['font_family']) && !empty($value['font_family']) ? $value['font_family'] : '';
                                    $font_backup = isset($value['font_backup']) && !empty($value['font_backup']) ? $value['font_backup'] : '';
                                    $font_style = isset($value['font_style']) && !empty($value['font_style']) ? $value['font_style'] : '';
                                    $font_subsets = isset($value['font_subsets']) && !empty($value['font_subsets']) ? $value['font_subsets'] : '';
                                    $font_size = isset($value['font_size']) && !empty($value['font_size']) ? $value['font_size'] : '';
                                    $line_height = isset($value['line_height']) && !empty($value['line_height']) ? $value['line_height'] : '';
                                    $color = isset($value['color']) && !empty($value['color']) ? $value['color'] : '';

                                    $styles = '';
                                    $link = '';
                                    if (!empty($font_family)) {
                                        // Build Styles
                                        $styles .= 'font-family: ' . $font_family;
                                        if (!empty($font_backup)) {
                                            $styles .= ', ' . $font_backup;
                                        }
                                        $styles .= ';';
                                        if (!empty($font_style)) {
                                            if (-1 !== strpos($font_style, 'italic')) {
                                                $styles .= 'font-style: italic;';
                                                $font_weight = str_replace('italic', '', $font_style);
                                                $styles .= 'font-weight: ' . $font_weight . ';';
                                            } else {
                                                $styles .= 'font-style: normal;';
                                                $styles .= 'font-weight: ' . $font_style . ';';
                                            }
                                        }
                                    }
                                    if (!empty($font_size)) {
                                        $styles .= 'font-size: ' . $font_size . 'px;';
                                    }
                                    if (!empty($line_height)) {
                                        $styles .= 'line-height: ' . $line_height . 'px;';
                                    }
                                    if (!empty($color)) {
                                        $styles .= 'color: ' . $color . ';';
                                    }
                                    if (is_string($output)) {
                                        $output = [$output];
                                    }
                                    ob_start();
                                    ?>
                                    <style id="<?php echo esc_attr(Theme_Core_Options::TYPOGRAPHY_FIELD . '-' . getMiliseconds()); ?>">
                                        <?php
                                            if(is_array($output)){
                                                foreach ($output as $selector){
                                                    echo $selector . ' { ' . $styles . ' } ';
                                                }
                                            }
                                        ?>
                                    </style>
                                    <?php
                                    $dynamic_css = ob_get_clean();
                                    echo $dynamic_css;
                                    break;

                                case Theme_Core_Options::SPACING_FIELD :
                                    $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : null;
                                    $value = $this->get_tax_option($fieldId, $default);
                                    $top = isset($value['top']) && !empty($value['top']) ? $value['top'] : '';
                                    $right = isset($value['right']) && !empty($value['right']) ? $value['right'] : '';
                                    $bottom = isset($value['bottom']) && !empty($value['bottom']) ? $value['bottom'] : '';
                                    $left = isset($value['left']) && !empty($value['left']) ? $value['left'] : '';
                                    $unit = isset($value['unit']) && !empty($value['unit']) ? $value['unit'] : 'px';
                                    $mode = isset($fieldArgs['mode']) && !empty($fieldArgs['mode']) ? $fieldArgs['mode'] : 'padding';

                                    $styles = '';
                                    if (!empty($top)) {
                                        $styles .= $mode . '-top: ' . $top . $unit . ';';
                                    }
                                    if (!empty($right)) {
                                        $styles .= $mode . '-right: ' . $right . $unit . ';';
                                    }
                                    if (!empty($bottom)) {
                                        $styles .= $mode . '-bottom: ' . $bottom . $unit . ';';
                                    }
                                    if (!empty($left)) {
                                        $styles .= $mode . '-left: ' . $left . $unit . ';';
                                    }
                                    ob_start();
                                    ?>
                                    <style id="<?php echo esc_attr($fieldId . '-' . getMiliseconds()); ?>">
                                        <?php
                                            if(is_array($output)){
                                                foreach ($output as $selector){
                                                    echo $selector . ' { ' . $styles . ' } ';
                                                }
                                            }
                                        ?>
                                    </style>
                                    <?php
                                    $dynamic_css = ob_get_clean();
                                    echo $dynamic_css;
                                    break;

                                case Theme_Core_Options::COLOR_FIELD :
                                    $default = isset($fieldArgs['default']) && !empty($fieldArgs['default']) ? $fieldArgs['default'] : null;
                                    $value = $this->get_tax_option($fieldId, $default);
                                    ob_start();
                                    if (!empty($value)):
                                        ?>
                                        <style id="<?php echo esc_attr($fieldId . '-' . getMiliseconds()); ?>">
                                            <?php
                                                if(is_array($output)){
                                                    foreach ($output as $attr => $selector){
                                                        echo $selector . ' { ' . $attr . ': ' . $value . ' } ';
                                                    }
                                                }
                                            ?>
                                        </style>
                                    <?php
                                    endif;
                                    $dynamic_css = ob_get_clean();
                                    echo $dynamic_css;
                                    break;
                            }
                        }
                    }
                }
            }
        }
    }
}