<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

/**
 *
 */
class TCOMenuPage
{

    const MAIN_PAGE_SLUG = 'theme-core-options';

    function __construct()
    {
        add_action('admin_menu', [$this, 'tco_add_menu']);
    }

    public function tco_add_menu()
    {
        global $theme_core_options;

        $theme_options_args = $theme_core_options->theme_options->get_theme_options_args();

        $page_parent = apply_filters('tco_page_parent', '');

        if (!empty($theme_options_args)) {
            if (!empty($page_parent)) {
                global $menu;
                $has_page_parent = false;
                foreach ((array)$menu as $parent_menu) {
                    if ($parent_menu[2] == $page_parent) {
                        $has_page_parent = true;
                    }
                }
                if ($has_page_parent) {
                    add_submenu_page($page_parent, __('Theme Options', TCO_TEXT_DOMAIN), __('Theme Options', TCO_TEXT_DOMAIN), 'manage_options', self::MAIN_PAGE_SLUG, [$this, 'tco_add_theme_options_page']);
                } else {
                    add_menu_page(__('Theme Options', TCO_TEXT_DOMAIN), __('Theme Options', TCO_TEXT_DOMAIN), 'manage_options', self::MAIN_PAGE_SLUG, [$this, 'tco_add_theme_options_page'], 'dashicons-admin-generic', 99);
                }
            } else {
                add_menu_page(__('Theme Options', TCO_TEXT_DOMAIN), __('Theme Options', TCO_TEXT_DOMAIN), 'manage_options', self::MAIN_PAGE_SLUG, [$this, 'tco_add_theme_options_page'], 'dashicons-admin-generic', 99);
            }
        }
    }

    public function tco_add_theme_options_page()
    {
        tco_get_template_file_e('pages/theme-options.php');
    }
}