(function ($) {
    "use strict";

    var TCO_REPEATER = 'TCORepeater';

    function TCORepeater(config, element) {
        let $element = $(element);

        $element.data(TCO_REPEATER, this);

        this.element = $element;

        this.init(config);
        this.render();
    }

    TCORepeater.prototype = {
        // id
        repeaterHeaderPreId: 'repeater-link-' + tcoHelper.getTimestamp() + '-',
        repeaterContentPreId: 'repeater-content-' + tcoHelper.getTimestamp() + '-',
        repeaterDuplicateId: 'repeater-duplicate-' + tcoHelper.getTimestamp() + '-',
        repeaterDeleteId: 'repeater-delete-' + tcoHelper.getTimestamp() + '-',

        repeatersArgs: {},

        repeaters: {},

        init: function (config) {
            $.extend(this, config);

            this.formatRepeater();
        },

        render: function () {
            let _this = this;
            let repeaterContainerTmpl = tcoTemplates.getTemplate('repeater-container');
            let repeaterContainerHtml = _.template(repeaterContainerTmpl)({
                config: _this
            });
            repeaterContainerHtml = $(repeaterContainerHtml);

            let btnAdd = repeaterContainerHtml.find('.btn-add');
            btnAdd.on('click', function () {
                _this.renderItem('', '', true);
            });

            _this.element.html(repeaterContainerHtml);

            let value = {};
            if (!tcoHelper.isEmpty(_this.repeatersArgs.value)) {
                if(typeof _this.repeatersArgs.value != 'object'){
                    value = {};
                }
                else{
                    value = _this.repeatersArgs.value;
                }
            } else if (!tcoHelper.isEmpty(_this.repeatersArgs.default)) {
                value = _this.repeatersArgs.default;
            }

            $.each(value, function (repeaterKey, repeaterValue) {
                _this.renderItem(repeaterKey, repeaterValue);
            });

            return repeaterContainerHtml;
        },

        renderItem: function (repeaterKey, repeaterValue, active) {
            let _this = this;
            let repeaterContainerHtml = _this.element.find('.cms-repeater');
            let repeaterItemsEl = repeaterContainerHtml.find('.cms-repeater-items');
            let fields = {};
            if (tcoHelper.isEmpty(repeaterKey)) {
                repeaterKey = 0;
                if (!tcoHelper.isEmpty(_this.repeaters)) {
                    $.each(_this.repeaters, function (_repeaterKey, _repeater) {
                        _repeaterKey = parseInt(_repeaterKey);
                        repeaterKey = _repeaterKey + 1;
                    });
                }
            }
            if (tcoHelper.isEmpty(repeaterValue)) {
                repeaterValue = {};
            }
            $.each(_this.repeatersArgs.fields, function (fieldId, fieldArgs) {
                let _fieldArgs = Object.assign({}, fieldArgs);
                let formattedFieldId = _this.repeatersArgs.id + '-' + repeaterKey + '-' + fieldId;
                _fieldArgs.name = _this.repeatersArgs.id + '[' + repeaterKey + ']' + '[' + fieldId + ']';
                if (!tcoHelper.isEmpty(repeaterValue[fieldId])) {
                    _fieldArgs.value = repeaterValue[fieldId];
                }
                if (!tcoHelper.isEmpty(_fieldArgs.required)) {
                    let _required = _fieldArgs.required.slice();
                    let formattedRequiredFieldId = _required[0];
                    formattedRequiredFieldId = _this.repeatersArgs.id + '-' + repeaterKey + '-' + formattedRequiredFieldId;
                    _required[0] = formattedRequiredFieldId;
                    _fieldArgs.required = _required;
                }
                fields[formattedFieldId] = _fieldArgs;
            });

            let repeaterItemTmpl = tcoTemplates.getTemplate('repeater-item');
            let repeaterConfig = {
                repeaterKey: repeaterKey,
                repeaterTitle: '#' + repeaterKey,
                repeaterHeaderPreId: _this.repeaterHeaderPreId,
                repeaterContentPreId: _this.repeaterContentPreId,
                repeaterDuplicateId: _this.repeaterDuplicateId,
                repeaterDeleteId: _this.repeaterDeleteId,
            };
            let repeaterItemHtml = _.template(repeaterItemTmpl)({
                config: repeaterConfig
            });
            repeaterItemHtml = $(repeaterItemHtml);
            repeaterItemsEl.append(repeaterItemHtml);
            let repeaterHeader = repeaterItemHtml.find('#' + _this.repeaterHeaderPreId + repeaterKey);
            let repeaterContent = repeaterItemHtml.find('#' + _this.repeaterContentPreId + repeaterKey);
            let btnDuplicate = repeaterItemHtml.find('#' + _this.repeaterDuplicateId + repeaterKey);
            let btnDelete = repeaterItemHtml.find('#' + _this.repeaterDeleteId + repeaterKey);

            repeaterContent.tcoForm({
                fieldsArgs: fields
            });

            if (active === true) {
                repeaterHeader.addClass('active');
                repeaterContent.addClass('active');
            }
            repeaterHeader.on('click', function (e) {
                e.preventDefault();

                if (repeaterHeader.hasClass('active')) {
                    repeaterHeader.removeClass('active');
                    repeaterContent.removeClass('active');
                } else {
                    repeaterHeader.addClass('active');
                    repeaterContent.addClass('active');
                }
            });

            btnDuplicate.on('click', function (e) {
                e.preventDefault();

                let data = repeaterContent.find(':input').serializeObject();
                _this.renderItem('', data[_this.repeatersArgs.id][repeaterKey], true);
            });

            btnDelete.on('click', function (e) {
                e.preventDefault();

                repeaterItemHtml.remove();
            });

            repeaterConfig.repeaterItemEl = repeaterItemHtml;
            _this.addRepeater(repeaterKey, repeaterConfig);
        },

        formatRepeater: function () {
            // let _this = this;
            // let repeaterItemTmpl = tcoTemplates.getTemplate('repeater-item');
            // _this.repeaters = {};
            //
            // let count = 0;
            // $.each(_this.repeatersArgs, function (repeaterKey, repeaterArgs) {
            // 	count++;
            //
            // 	// Repeater Config
            // 	repeaterArgs.repeaterKey = repeaterKey;
            // 	repeaterArgs.active = count === 1;
            // 	let repeaterConfig = {
            // 		active: count === 1,
            // 		repeaterKey: repeaterKey,
            // 		repeaterArgs: repeaterArgs,
            // 		repeaterHeaderPreId: _this.repeaterHeaderPreId,
            // 		repeaterContentPreId: _this.repeaterContentPreId,
            // 	};
            //
            // 	// Repeater Link
            // 	let repeaterItemHtml = _.template(repeaterItemTmpl)({
            //         config: repeaterConfig
            //     });
            //     repeaterItemHtml = $(repeaterItemHtml);
            //
            //     let repeaterHeader = repeaterItemHtml.find('#' + _this.repeaterHeaderPreId + repeaterKey);
            //     let repeaterContent = repeaterItemHtml.find('#' + _this.repeaterContentPreId + repeaterKey);
            //
            //     // Build repeaterContentHtml
            //     if(!tcoHelper.isEmpty(repeaterArgs.fields)){
            //         repeaterContent.tcoForm({
            //             fieldsArgs: repeaterArgs.fields
            //         });
            //     }
            //
            //     // Events
            //     repeaterHeader.on('click', function (e) {
            //     	e.preventDefault();
            //
            //     	let activeRepeater = _this.getActiveRepeater();
            //     	let repeater = _this.getRepeater(repeaterKey);
            //
            //     	activeRepeater.active = false;
            //     	_this.updateRepeater(activeRepeater.repeaterKey, activeRepeater);
            //     	activeRepeater.repeaterItemEl.find('#' + _this.repeaterHeaderPreId + activeRepeater.repeaterKey).removeClass('active');
            //     	activeRepeater.repeaterItemEl.find('#' + _this.repeaterContentPreId + activeRepeater.repeaterKey).removeClass('active');
            //
            //     	repeater.active = true;
            //     	_this.updateRepeater(repeaterKey, repeater);
            //     	repeater.repeaterItemEl.find('#' + _this.repeaterHeaderPreId + repeater.repeaterKey).addClass('active');
            //     	repeater.repeaterItemEl.find('#' + _this.repeaterContentPreId + repeater.repeaterKey).addClass('active');
            //     });
            //
            //     repeaterArgs.repeaterItemEl = repeaterItemHtml;
            //     _this.addRepeater(repeaterKey, repeaterArgs);
            // });
        },

        addRepeater: function (repeaterKey, repeaterArgs) {
            this.repeaters[repeaterKey] = repeaterArgs;
        },

        updateRepeater: function (repeaterKey, repeaterArgs) {
            this.repeaters[repeaterKey] = repeaterArgs;
        },

        getRepeater: function (repeaterKey) {
            return this.repeaters[repeaterKey];
        },

        getActiveRepeater: function () {
            let _this = this;
            let activeRepeater = {};
            $.each(_this.repeaters, function (repeaterKey, repeaterArgs) {
                if (repeaterArgs.active === true) {
                    activeRepeater = repeaterArgs;
                }
            });

            return activeRepeater;
        },
    };

    $.fn.tcoRepeater = function (config) {
        let result = this;

        this.each(function () {
            let $element = $(this),
                instance = $element.data(TCO_REPEATER);

            if (instance) {
                instance.init(config);
                instance.render();

                result = instance;
            } else {
                result = new TCORepeater(config, $element);
            }
        });

        return result;
    };
}(jQuery));