(function ($) {
    "use strict";

    var TCO_FORM = 'TCOForm';

    function TCOForm(config, element) {
        let $element = $(element);

        $element.data(TCO_FORM, this);

        this.element = $element;

        this.init(config);
        this.render();
    }

    TCOForm.prototype = {
        fieldsArgs: {},

        id: tcoHelper.getTimestamp(),

        fields: {},

        requiredFields: {},

        init: function (config) {
            $.extend(this, config);

            this.formatFields();
        },

        render: function () {
            let _this = this;
            let formContainerTmpl = tcoTemplates.getTemplate('form-container');
            let formContainerHtml = _.template(formContainerTmpl)({
                config: _this
            });
            formContainerHtml = $(formContainerHtml);

            tcoHelper.waitFor(function () {
                return !tcoHelper.isEmpty(_this.fields);
            }, function () {
                $.each(_this.fields, function (fieldId, fieldArgs) {
                    _this.relateRequiredFields(fieldId);
                    formContainerHtml.append(fieldArgs.fieldEl);
                });
            }, 'Wait for format fieldsArgs!', 300);

            _this.element.html(formContainerHtml);

            _this.element.find('.select2').select2();

            return formContainerHtml;
        },

        formatFields: function () {
            let _this = this;
            let fieldsArgs = _this.fieldsArgs;
            _this.fields = {};
            _this.requiredFields = {};
            $.each(fieldsArgs, function (fieldId, fieldArgs) {
                if (tcoHelper.isEmpty(fieldArgs.name)) {
                    fieldArgs.name = fieldId;
                }
                if (tcoHelper.isEmpty(fieldArgs.value) && !tcoHelper.isEmpty(window[fieldId])) {
                    fieldArgs.value = window[fieldId];
                }
                if ($.isArray(fieldArgs.required) && fieldArgs.required.length === 3) {
                    let requiredFieldId = fieldArgs.required[0];
                    let condition = fieldArgs.required[1];
                    let conditionValue = fieldArgs.required[2];
                    let requiredField = _this.fields[requiredFieldId];
                    if (!tcoHelper.isEmpty(requiredField)) {
                        if (tcoHelper.isEmpty(_this.requiredFields[requiredFieldId]) || !$.isArray(_this.requiredFields[requiredFieldId])) {
                            _this.requiredFields[requiredFieldId] = [];
                            _this.requiredFields[requiredFieldId].push([fieldId, condition, conditionValue]);
                        } else {
                            _this.requiredFields[requiredFieldId].push([fieldId, condition, conditionValue]);
                        }
                    }
                }

                let fieldTmpl = tcoTemplates.getTemplate('field-' + fieldArgs.type);
                if (!tcoHelper.isEmpty(fieldTmpl)) {
                    let fieldHtml = _.template(fieldTmpl)({
                        fieldId: fieldId,
                        fieldArgs: fieldArgs,
                    });
                    fieldHtml = $(fieldHtml);
                    if (!tcoHelper.isEmpty(fieldArgs.value)) {
                        fieldHtml.data('value', fieldArgs.value);
                    } else if (!tcoHelper.isEmpty(fieldArgs.default)) {
                        fieldHtml.data('value', fieldArgs.default);
                    }

                    switch (fieldArgs.type) {
                        case 'text':

                            break;

                        case 'textarea':

                            break;

                        case 'select':
                            // Event
                            let selectEl = fieldHtml.find('#' + fieldId);
                            if (!tcoHelper.isEmpty(fieldArgs.args)) {
                                let data = fieldArgs.args;
                                data.action = 'get_posts';

                                $.ajax({
                                    url: theme_core_options_configs.ajax_url,
                                    type: 'POST',
                                    beforeSend: function () {

                                    },
                                    data: data
                                }).done(function (res) {
                                    if (res.success) {
                                        let value = '';
                                        if (!tcoHelper.isEmpty(fieldArgs.value)) {
                                            value = fieldArgs.value;
                                        }
                                        else if (!tcoHelper.isEmpty(fieldArgs.default)) {
                                            value = fieldArgs.default;
                                        }
                                        $.each(res.data, function (key, postData) {
                                            let option = $('<option>').attr('value', postData.ID).text(postData.post_title);
                                            if(!tcoHelper.isEmpty(value) && value == postData.ID){
                                                option.attr('selected', 'selected');
                                            }
                                            selectEl.append(option);
                                        });
                                    } else {
                                        console.log(res.message);
                                    }
                                }).fail(function (res) {
                                    console.log(res);
                                }).always(function () {

                                });
                            }
                            selectEl.on('change', function () {
                                fieldHtml.data('value', $(this).val());
                                fieldHtml.trigger('change');
                            });

                            break;

                        case 'media':
                            // Event
                            let imgIdEl = fieldHtml.find('#' + fieldId + '-id');
                            let imgUrlEl = fieldHtml.find('#' + fieldId + '-url');
                            let imgContainer = fieldHtml.find('#' + fieldId + '-image-container');
                            let uploadBtn = fieldHtml.find('#' + fieldId + '-media');
                            let resetBtn = fieldHtml.find('#reset-' + fieldId);
                            uploadBtn.on('click', function (e) {
                                e.preventDefault();

                                // Create a new media frame
                                let frame = wp.media({
                                    title: 'Upload Image',
                                    button: {
                                        text: 'Select'
                                    },

                                    multiple: false  // Set to true to allow multiple files to be selected
                                });

                                // When an image is selected in the media frame...
                                frame.on('select', function () {
                                    // Get media attachment details from the frame state
                                    var attachment = frame.state().get('selection').first().toJSON();

                                    // Send the attachment URL to our custom image input field.
                                    imgContainer.attr('href', attachment.url);
                                    imgContainer.html('<img src="' + attachment.url + '" alt="" style="max-width:100%;"/>');

                                    // Send the attachment id to our hidden input
                                    imgIdEl.val(attachment.id);

                                    // Send the attachment url to our url input
                                    imgUrlEl.val(attachment.url);
                                });

                                // Finally, open the modal on click
                                frame.open();
                            });
                            resetBtn.on('click', function (e) {
                                e.preventDefault();

                                imgContainer.html('');
                                imgIdEl.val('');
                                imgUrlEl.val('');
                            });

                            break;

                        case 'background':
                            let bgColorInputEl = fieldHtml.find('#' + fieldId + '-background-color');
                            let bgRepeatEl = fieldHtml.find('#' + fieldId + '-background-repeat');
                            let bgClipEl = fieldHtml.find('#' + fieldId + '-background-clip');
                            let bgOriginEl = fieldHtml.find('#' + fieldId + '-background-origin');
                            let bgSizeEl = fieldHtml.find('#' + fieldId + '-background-size');
                            let bgAttachmentEl = fieldHtml.find('#' + fieldId + '-background-attachment');
                            let bgPositionEl = fieldHtml.find('#' + fieldId + '-background-position');
                            let bgImgUrlEl = fieldHtml.find('#' + fieldId + '-background-image');
                            let bgUploadBtn = fieldHtml.find('#' + fieldId + '-upload-image');
                            let bgResetBtn = fieldHtml.find('#reset-' + fieldId);
                            let bgPreview = fieldHtml.find('#' + fieldId + '-background-preview');

                            bgColorInputEl.wpColorPicker({
                                change: function (event, ui) {
                                    let color = ui.color.to_s('hex');
                                    bgPreview.css('background-color', color);
                                    bgPreview.show();
                                },
                                clear: function (event) {
                                    bgPreview.removeCss('background-color');
                                    if (tcoHelper.isEmpty(bgImgUrlEl.val())) {
                                        bgPreview.hide();
                                    }
                                }
                            });

                            bgRepeatEl.on('change', function () {
                                let val = $(this).val();
                                if (tcoHelper.isEmpty(val)) {
                                    bgPreview.removeCss('background-repeat');
                                }
                                else {
                                    bgPreview.css('background-repeat', val);
                                }
                            });

                            bgClipEl.on('change', function () {
                                let val = $(this).val();
                                if (tcoHelper.isEmpty(val)) {
                                    bgPreview.removeCss('background-clip');
                                }
                                else {
                                    bgPreview.css('background-clip', val);
                                }
                            });

                            bgOriginEl.on('change', function () {
                                let val = $(this).val();
                                if (tcoHelper.isEmpty(val)) {
                                    bgPreview.removeCss('background-origin');
                                }
                                else {
                                    bgPreview.css('background-origin', val);
                                }
                            });

                            bgSizeEl.on('change', function () {
                                let val = $(this).val();
                                if (tcoHelper.isEmpty(val)) {
                                    bgPreview.removeCss('background-size');
                                }
                                else {
                                    bgPreview.css('background-size', val);
                                }
                            });

                            bgAttachmentEl.on('change', function () {
                                let val = $(this).val();
                                if (tcoHelper.isEmpty(val)) {
                                    bgPreview.removeCss('background-attachment');
                                }
                                else {
                                    bgPreview.css('background-attachment', val);
                                }
                            });

                            bgPositionEl.on('change', function () {
                                let val = $(this).val();
                                if (tcoHelper.isEmpty(val)) {
                                    bgPreview.removeCss('background-position');
                                }
                                else {
                                    bgPreview.css('background-position', val);
                                }
                            });

                            bgUploadBtn.on('click', function (e) {
                                e.preventDefault();

                                // Create a new media frame
                                let frame = wp.media({
                                    title: 'Upload Image',
                                    button: {
                                        text: 'Select'
                                    },
                                    multiple: false  // Set to true to allow multiple files to be selected
                                });

                                // When an image is selected in the media frame...
                                frame.on('select', function () {
                                    // Get media attachment details from the frame state
                                    var attachment = frame.state().get('selection').first().toJSON();

                                    // Send the attachment URL to our custom image input field.
                                    bgPreview.css('background-image', 'url("' + attachment.url + '")');
                                    bgPreview.show();

                                    // Send the attachment url to our url input
                                    bgImgUrlEl.val(attachment.url);
                                });

                                // Finally, open the modal on click
                                frame.open();
                            });
                            bgResetBtn.on('click', function (e) {
                                e.preventDefault();

                                bgPreview.removeCss('background-image');
                                bgImgUrlEl.val('');
                                if (tcoHelper.isEmpty(bgColorInputEl.val())) {
                                    bgPreview.hide();
                                }
                            });

                            break;

                        case 'switch':
                            // Event
                            let switchInputEl = fieldHtml.find('#' + fieldId);
                            let switchCheckboxEl = fieldHtml.find('#' + fieldId + '-checkbox');
                            switchCheckboxEl.on('change', function (e) {
                                e.preventDefault();

                                if ($(this).is(":checked")) {
                                    switchInputEl.val(1);
                                } else {
                                    switchInputEl.val(0);
                                }

                                fieldHtml.data('value', switchInputEl.val());
                                fieldHtml.trigger('change');
                            });

                            break;

                        case 'radio':
                            let radioEl = fieldHtml.find('[name="' + fieldId + '"]');
                            radioEl.on('click', function () {
                                fieldHtml.data('value', $(this).val());
                                fieldHtml.trigger('change');
                            });

                            break;

                        case 'image-select':
                            let imageSelectEl = fieldHtml.find('[name="' + fieldId + '"]');
                            imageSelectEl.on('click', function () {
                                fieldHtml.data('value', $(this).val());
                                fieldHtml.trigger('change');
                            });

                            break;

                        case 'button-set':
                            let btnSetInputEl = fieldHtml.find('[name="' + fieldId + '"]');
                            btnSetInputEl.on('change', function (e) {
                                e.preventDefault();

                                let btnSetInputCheckedEl = fieldHtml.find('[name="' + fieldId + '"]:checked');

                                fieldHtml.data('value', btnSetInputCheckedEl.val());
                                fieldHtml.trigger('change');
                            });
                            break;

                        case 'color':
                            // Event
                            let colorInputEl = fieldHtml.find('#' + fieldId);
                            colorInputEl.wpColorPicker();

                            break;

                        case 'color-set':
                            // Event
                            let colorSetInputEl = fieldHtml.find('.color-set-item');
                            colorSetInputEl.wpColorPicker();

                            break;

                        case 'rgba-color':
                            // Event
                            let rgbaColorInputEl = fieldHtml.find('#' + fieldId);
                            rgbaColorInputEl.wpColorPicker();

                            break;

                        case 'link-color':
                            // Event
                            let colorInputEls = fieldHtml.find('.link-color');
                            colorInputEls.wpColorPicker();

                            break;

                        case 'dimensions':

                            break;

                        case 'slider':
                            let rangeInputEl = fieldHtml.find('#' + fieldId);
                            let rangeValueEl = fieldHtml.find('#' + fieldId + '-value');
                            rangeInputEl.on('input', function () {
                                rangeValueEl.html(this.value);
                            });
                            break;

                        case 'spacing':

                            break;

                        case 'typography':
                            // Event
                            let fontFamilyInputEl = fieldHtml.find('#' + fieldId + '-font-family');
                            let fontBackupInputEl = fieldHtml.find('#' + fieldId + '-font-backup');
                            let fontStyleInputEl = fieldHtml.find('#' + fieldId + '-font-style');
                            let fontSubsetsInputEl = fieldHtml.find('#' + fieldId + '-font-subsets');
                            let fontSizeInputEl = fieldHtml.find('#' + fieldId + '-font-size');
                            let letterSpacingInputEl = fieldHtml.find('#' + fieldId + '-letter-spacing');
                            let lineHeightInputEl = fieldHtml.find('#' + fieldId + '-line-height');
                            let _colorInputEl = fieldHtml.find('#' + fieldId + '-color');
                            let previewEl = fieldHtml.find('.typography-preview');

                            _colorInputEl.wpColorPicker({
                                change: function (e, ui) {
                                    e = null;
                                    $(this).val(ui.color.toString());

                                    previewEl.trigger('change');
                                },
                                clear: function (e, ui) {
                                    console.log(e);
                                    console.log(ui);
                                    // e = null;
                                    // $( this ).val( ui.color.toString() );

                                    previewEl.trigger('change');
                                },
                            });

                            fontFamilyInputEl.on('change.select2', function () {
                                let fontFamily = $(this).val();
                                let fontStyle = fontStyleInputEl.val();
                                let fontSubsets = fontSubsetsInputEl.val();

                                fontStyleInputEl.select2('destroy');
                                fontStyleInputEl.html('');
                                fontStyleInputEl.append($('<option>').attr({
                                    value: ''
                                }).text(''));

                                fontSubsetsInputEl.select2('destroy');
                                fontSubsetsInputEl.html('');
                                fontSubsetsInputEl.append($('<option>').attr({
                                    value: ''
                                }).text(''));

                                if (!tcoHelper.isEmpty(theme_core_options_configs.google_fonts[fontFamily])) {
                                    let fontData = theme_core_options_configs.google_fonts[fontFamily];
                                    let variants = fontData.variants;
                                    let subsets = fontData.subsets;
                                    if (!tcoHelper.isEmpty(variants)) {
                                        $.each(variants, function (index, variant) {
                                            let option = $('<option>').attr({
                                                value: variant.id
                                            }).text(variant.name);
                                            if (fontStyle == variant.id) {
                                                option.prop('selected', true);
                                            }
                                            fontStyleInputEl.append(option);
                                        });
                                    }
                                    if (!tcoHelper.isEmpty(subsets)) {
                                        $.each(subsets, function (index, subset) {
                                            let option = $('<option>').attr({
                                                value: subset.id
                                            }).text(subset.name);
                                            if (fontSubsets == subset.id) {
                                                option.prop('selected', true);
                                            }
                                            fontSubsetsInputEl.append(option);
                                        });
                                    }
                                } else if (!tcoHelper.isEmpty(theme_core_options_configs.std_fonts[fontFamily])) {
                                    $.each(theme_core_options_configs.default_font_weights, function (value, name) {
                                        let option = $('<option>').attr({
                                            value: value
                                        }).text(name);
                                        if (fontStyle == value) {
                                            option.prop('selected', true);
                                        }
                                        fontStyleInputEl.append(option);
                                    });

                                    let option = $('<option>').attr({
                                        value: 'latin'
                                    }).text('Latin');
                                    if (fontSubsets == 'latin') {
                                        option.prop('selected', true);
                                    }
                                    fontSubsetsInputEl.append(option);
                                }

                                fontStyleInputEl.select2();
                                fontSubsetsInputEl.select2();

                                fontStyleInputEl.on('change.select2', function () {
                                    previewEl.trigger('change');
                                });

                                fontSubsetsInputEl.on('change.select2', function () {
                                    previewEl.trigger('change');
                                });

                                previewEl.trigger('change');
                            });

                            fontBackupInputEl.on('change.select2', function () {
                                previewEl.trigger('change');
                            });

                            fontStyleInputEl.on('change.select2', function () {
                                previewEl.trigger('change');
                            });

                            fontSubsetsInputEl.on('change.select2', function () {
                                previewEl.trigger('change');
                            });

                            letterSpacingInputEl.on('input', function () {
                                previewEl.trigger('change');
                            });

                            fontSizeInputEl.on('input', function () {
                                previewEl.trigger('change');
                            });

                            lineHeightInputEl.on('input', function () {
                                previewEl.trigger('change');
                            });

                            previewEl.on('change', function () {
                                let fontFamily = fontFamilyInputEl.val();
                                let fontBackup = fontBackupInputEl.val();
                                let fontStyle = fontStyleInputEl.val();
                                let fontSubsets = fontSubsetsInputEl.val();
                                let letterSpacing = letterSpacingInputEl.val();
                                let fontSize = fontSizeInputEl.val();
                                let lineHeight = lineHeightInputEl.val();
                                let color = _colorInputEl.val();
                                let styles = '';
                                let link = '';
                                if (!tcoHelper.isEmpty(fontFamily)) {
                                    // Build Styles
                                    styles += 'font-family: ' + fontFamily;
                                    if (!tcoHelper.isEmpty(fontBackup)) {
                                        styles += ', ' + fontBackup;
                                    }
                                    styles += ';';
                                    if (!tcoHelper.isEmpty(fontStyle)) {
                                        if (-1 !== fontStyle.indexOf('italic')) {
                                            styles += 'font-style: italic;';
                                            let fontWeight = fontStyle.replace('italic', '');
                                            styles += 'font-weight: ' + fontWeight + ';';
                                        } else {
                                            styles += 'font-style: normal;';
                                            styles += 'font-weight: ' + fontStyle + ';';
                                        }
                                    }

                                    // Build Link
                                    if (!tcoHelper.isEmpty(theme_core_options_configs.google_fonts[fontFamily])) {
                                        // Replace spaces with "+" sign.
                                        fontFamily = fontFamily.replace(/\s+/g, '+');
                                        link = fontFamily;
                                        if (!tcoHelper.isEmpty(fontStyle)) {
                                            link += ':' + fontStyle.replace(/\-/g, ' ');
                                        }
                                        if (!tcoHelper.isEmpty(fontSubsets)) {
                                            link += '&subset=' + fontSubsets;
                                        }
                                        WebFont.load({google: {families: [link]}});
                                    }
                                }
                                if (!tcoHelper.isEmpty(letterSpacing)) {
                                    styles += 'letter-spacing: ' + letterSpacing + 'px;';
                                }
                                if (!tcoHelper.isEmpty(fontSize)) {
                                    styles += 'font-size: ' + fontSize + 'px;';
                                }
                                if (!tcoHelper.isEmpty(lineHeight)) {
                                    styles += 'line-height: ' + lineHeight + ';';
                                } else {
                                    if (!tcoHelper.isEmpty(fontSize)) {
                                        styles += 'line-height: ' + fontSize + 'px;';
                                    }
                                }
                                if (!tcoHelper.isEmpty(color)) {
                                    styles += 'color: ' + color + ';';
                                }
                                $(this).attr('style', styles);
                            });

                            previewEl.trigger('change');

                            break;

                        case 'repeater':
                            let repeaterWrapper = fieldHtml.find('#' + fieldId);
                            repeaterWrapper.tcoRepeater({
                                repeatersArgs: {
                                    id: fieldId,
                                    fields: fieldArgs.fields,
                                    default: fieldArgs.default,
                                    value: fieldArgs.value,
                                }
                            });
                            break;

                        case 'icon-picker':
                            let iconPickerEl = fieldHtml.find('#' + fieldId);
                            iconPickerEl.fontIconPicker();

                            break;
                    }

                    fieldHtml.on('change', function () {
                        _this.relateRequiredFields(fieldId);
                    });

                    fieldArgs.fieldEl = fieldHtml;
                    _this.addField(fieldId, fieldArgs);
                }
            });
        },

        relateRequiredFields: function (fieldId) {
            let _this = this;
            let fieldArgs = _this.fields[fieldId];
            let isVisible = fieldArgs.fieldEl.css('display') != 'none';
            let value = fieldArgs.fieldEl.data('value');
            if (!tcoHelper.isEmpty(_this.requiredFields[fieldId]) && $.isArray(_this.requiredFields[fieldId])) {
                $.each(_this.requiredFields[fieldId], function (key, required) {
                    let requiredFieldId = required[0];
                    let condition = required[1];
                    let conditionValue = required[2];
                    let requiredField = _this.fields[requiredFieldId];
                    if (!tcoHelper.isEmpty(requiredField)) {
                        switch (condition) {
                            case '=':
                                if(typeof conditionValue == 'string'){
                                    if (value == conditionValue) {
                                        requiredField.fieldEl.show();
                                    } else {
                                        requiredField.fieldEl.hide();
                                    }
                                }
                                else if($.isArray(conditionValue)){
                                    if ($.inArray(value, conditionValue) !== -1) {
                                        requiredField.fieldEl.show();
                                    } else {
                                        requiredField.fieldEl.hide();
                                    }
                                }
                                break;
                            case '!=':
                                if(typeof conditionValue == 'string'){
                                    if (value != conditionValue) {
                                        requiredField.fieldEl.show();
                                    } else {
                                        requiredField.fieldEl.hide();
                                    }
                                }
                                else if($.isArray(conditionValue)){
                                    if ($.inArray(value, conditionValue) === -1) {
                                        requiredField.fieldEl.show();
                                    } else {
                                        requiredField.fieldEl.hide();
                                    }
                                }
                                break;
                        }
                        if (!isVisible) {
                            requiredField.fieldEl.hide();
                        }
                        _this.relateRequiredFields(requiredFieldId);
                    }
                });
            }
        },

        addField: function (fieldId, fieldArgs) {
            this.fields[fieldId] = fieldArgs;
        },

        updateField: function (fieldId, fieldArgs) {
            this.fields[fieldId] = fieldArgs;
        },

        getField: function (fieldId) {
            return this.fields[fieldId];
        },
    };

    $.fn.tcoForm = function (config) {
        let result = this;

        this.each(function () {
            let $element = $(this),
                instance = $element.data(TCO_FORM);

            if (instance) {
                instance.init(config);
                instance.render();

                result = instance;
            } else {
                result = new TCOForm(config, $element);
            }
        });

        return result;
    };
}(jQuery));