(function($) {
    "use strict";

    $(document).ready(function() {
        var term_id = $('[name="tag_ID"]').val();
        var taxName = $('[name="taxonomy"]').val();
        var taxOptionsArgs = null;
        var taxOptions = null;

        $.ajax({
            url: theme_core_options_configs.ajax_url,
            type: 'POST',
            beforeSend: function() {

            },
            data: {
                action: 'get_tax_options_args',
                tax_name: taxName
            }
        }).done(function(res) {
            if (res.success) {
                taxOptionsArgs = res.data;
            } else {
                console.log(res.message);
            }
        }).fail(function(res) {
            console.log(res);
        }).always(function() {

        });

        $.ajax({
            url: theme_core_options_configs.ajax_url,
            type: 'POST',
            beforeSend: function() {

            },
            data: {
                action: 'get_tax_options',
                term_id: term_id,
                tax_name: taxName,
            }
        }).done(function(res) {
            if (res.success) {
                taxOptions = res.data;
            } else {
                console.log(res.message);
            }
        }).fail(function(res) {
            console.log(res);
        }).always(function() {

        });

        tcoHelper.waitFor(function() {
            return taxOptionsArgs != null && taxOptions != null && tcoTemplates.ready;
        }, function() {

            if (!tcoHelper.isEmpty(taxOptionsArgs)) {
                // Set Theme Options to Window Object
                $.each(taxOptions, function(optId, optVal) {
                    window[optId] = optVal;
                });

                let taxOptionsTabs = $('#tax-options').tcoTabs({
                    tabsArgs: taxOptionsArgs
                });
                let taxOptionsActionsTmpl = tcoTemplates.getTemplate('theme-options-actions');
                let taxOptionsActionsHtml = _.template(taxOptionsActionsTmpl)({});
                taxOptionsActionsHtml = $(taxOptionsActionsHtml);
                let taxOptionsInfoTmpl = tcoTemplates.getTemplate('theme-options-info');
                let taxOptionsInfoHtml = _.template(taxOptionsInfoTmpl)({});
                taxOptionsInfoHtml = $(taxOptionsInfoHtml);
                // taxOptionsTabs.setTabsContentHeader(taxOptionsActionsHtml.clone());
                // taxOptionsTabs.setTabsContentFooter(taxOptionsActionsHtml.clone());
                // taxOptionsTabs.setTabsHeader(taxOptionsInfoHtml);

                let maxHeight = 0;
                $.each(taxOptionsTabs.element.find('.cms-tab-content'), function (index, item) {
                    if ($(item).outerHeight() > maxHeight) {
                        maxHeight = $(item).outerHeight();
                    }
                });
                taxOptionsTabs.element.find('.cms-tabs-content').css('min-height', maxHeight + 'px');

                // Event
                let saveBtn = taxOptionsTabs.element.find('.btn-save-options');
                let resetSectionBtn = taxOptionsTabs.element.find('.btn-reset-section');
                let resetBtn = taxOptionsTabs.element.find('.btn-reset');
                let loaderTmpl = tcoTemplates.getTemplate('loader-2');

                saveBtn.on('click', function(e) {
                    e.preventDefault();

                    if (!confirm("Are you sure you want to save the changes?")) {
                        return false;
                    }

                    let data = taxOptionsTabs.element.find(':input').serializeArray();
                    let formData = new FormData();
                    $.each(data, function(index, item) {
                        formData.append(item['name'], item['value']);
                    });
                    formData.append('action', 'save_tax_options');
                    formData.append('post_id', postId);
                    $.ajax({
                        url: theme_core_options_configs.ajax_url,
                        type: "POST",
                        beforeSend: function() {
                            if ($('.loader-2').length === 0) {
                                taxOptionsTabs.element.prepend(loaderTmpl);
                            }
                        },
                        data: formData,
                        contentType: false,
                        processData: false,
                    }).done(function(res) {
                        if (res.success) {

                        }
                    }).fail(function(res) {

                    }).always(function() {
                        $('.loader-2').remove();
                    });
                });
                resetSectionBtn.on('click', function (e) {
                    e.preventDefault();

                    if (!confirm("Are you sure you want to reset data of this section?")) {
                        return false;
                    }

                    let activeTab = taxOptionsTabs.getActiveTab();
                    if (!tcoHelper.isEmpty(activeTab)) {
                        if (!tcoHelper.isEmpty(activeTab.sections)) {
                            $.each(activeTab.sections, function (sectionId, sectionArgs) {
                                if (!tcoHelper.isEmpty(sectionArgs.fields)) {
                                    $.each(sectionArgs.fields, function (fieldId, fieldArgs) {
                                        delete fieldArgs['value'];
                                        window[fieldId] = fieldArgs['default'];
                                    });
                                }
                            });
                            activeTab.tabContentEl.tcoAccordion({
                                accordionsArgs: activeTab.sections
                            });
                        }
                        else if (!tcoHelper.isEmpty(activeTab.fields)) {
                            $.each(activeTab.fields, function (fieldId, fieldArgs) {
                                delete fieldArgs['value'];
                                window[fieldId] = fieldArgs['default'];
                            });
                            console.log(activeTab.fields);
                            activeTab.tabContentEl.tcoForm({
                                fieldsArgs: activeTab.fields
                            });
                        }
                    }
                });
                resetBtn.on('click', function (e) {
                    e.preventDefault();

                    if (!confirm("Are you sure you want to reset data of all sections?")) {
                        return false;
                    }

                    let tabs = taxOptionsTabs.tabs;
                    if (!tcoHelper.isEmpty(tabs)) {
                        $.each(tabs, function (tabId, tabArgs) {
                            if (!tcoHelper.isEmpty(tabArgs)) {
                                if (!tcoHelper.isEmpty(tabArgs.sections)) {
                                    $.each(tabArgs.sections, function (sectionId, sectionArgs) {
                                        if (!tcoHelper.isEmpty(sectionArgs.fields)) {
                                            $.each(sectionArgs.fields, function (fieldId, fieldArgs) {
                                                delete fieldArgs['value'];
                                                window[fieldId] = fieldArgs['default'];
                                            });
                                        }
                                    });
                                    tabArgs.tabContentEl.tcoAccordion({
                                        accordionsArgs: tabArgs.sections
                                    });
                                }
                                else if (!tcoHelper.isEmpty(tabArgs.fields)) {
                                    $.each(tabArgs.fields, function (fieldId, fieldArgs) {
                                        delete fieldArgs['value'];
                                        window[fieldId] = fieldArgs['default'];
                                    });
                                    console.log(tabArgs.fields);
                                    tabArgs.tabContentEl.tcoForm({
                                        fieldsArgs: tabArgs.fields
                                    });
                                }
                            }
                        });
                    }
                });
            }
        }, 'Wait for get Taxonomy Options Args!');
    });
}(jQuery));