<?php
if (!function_exists('swa_events_manager_export')) {
    function swa_events_manager_export($file)
    {
        global $wp_filesystem;
        global $wpdb;
        $results = $wpdb->get_results('SELECT option_name, option_value FROM ' . $wpdb->options . " WHERE option_name LIKE 'dbem_%' OR option_name LIKE 'emp_%' OR option_name LIKE 'em_%'", ARRAY_A);

        $options = array();
        foreach ($results as $result) $options[$result['option_name']] = $result['option_value'];

        $wp_filesystem->put_contents($file . 'events-manager-options.json', json_encode($options), FS_CHMOD_FILE);
    }
}

if (!function_exists('swa_events_manager_import')) {
    function swa_events_manager_import($file)
    {
        if(!file_exists($file . 'events-manager-options.json')){
            return;
        }

        $options = json_decode(file_get_contents($file . 'events-manager-options.json'), true);

        if( is_array($options) ){
            foreach( $options as $k => $v ){
                if( preg_match('/^(?:db)emp?_/', $k) ){
                    update_option($k, $v);
                }
            }
        }

        return;
    }
}
?>