(function($) {
    "user strict";

    $(window).on("elementor:init", function() {
        var CMSPostsControlView = elementor.modules.controls.BaseData.extend({
            onReady: function() {
                var self = this;
                var selectEls = $(this.ui.select);
                var post_type = this.model.attributes.post_type;
                var return_value = this.model.attributes.return_value;
                var value = this.getControlValue();
                $.each(selectEls, function(index, selectEl) {
                    selectEl = $(selectEl);
                    var data = {
                        post_type: post_type,
                        return_value: return_value,
                    };
                    data.action = 'etc_get_posts_by_slugs';
                    // var action = 'etc_get_posts_by_slugs';
                    if (return_value == 'ID' || return_value == 'id') {
                        data.action = 'etc_get_posts_by_ids';
                        data.post_id = value;
                    } else {
                        data.post_name = value;
                    }

                    // append current value
                    $.ajax({
                        url: cms_posts_control_config.ajax_url,
                        type: "POST",
                        beforeSend: function() {

                        },
                        data: data,
                    }).done(function(res) {
                        if (res.success) {
                            $.each(res.data, function(index, value) {
                                if (return_value == 'ID' || return_value == 'id') {
                                    var newOption = new Option(value.post_title, value.id, true, true);
                                } else {
                                    var newOption = new Option(value.post_title, value.post_name, true, true);
                                }

                                selectEl.append(newOption);
                            });
                        }
                    }).fail(function(res) {

                    }).always(function() {

                    });

                    // save value on change
                    selectEl.on('change', function() {
                        self.saveValue();
                    });

                    selectEl.select2({
                        ajax: {
                            url: cms_posts_control_config.ajax_url,
                            dataType: "json",
                            delay: 250,
                            type: "POST",
                            data: function(params) {
                                return {
                                    action: "etc_posts_control_get_posts",
                                    s: params.term, // search term
                                    page: params.page,
                                    post_type: (post_type),
                                };
                            },
                            processResults: function(res, params) {
                                let data = {};
                                if (res.success) {
                                    data = res.data;
                                }
                                // parse the results into the format expected by Select2
                                // since we are using custom formatting functions we do not need to
                                // alter the remote JSON data, except to indicate that infinite
                                // scrolling can be used
                                params.page = params.page || 1;

                                let items = data.posts;
                                $.each(items, function(index, item) {
                                    if (return_value == 'ID' || return_value == 'id') {
                                        item.id = item.id;
                                    } else {
                                        item.id = item.post_name;
                                    }

                                    item.text = item.post_title;
                                    items[index] = item;
                                });

                                return {
                                    results: items,
                                    pagination: {
                                        more: params.page * 10 < data.total,
                                    },
                                };
                            },
                            cache: true,
                        },
                        minimumInputLength: 3,
                        allowClear: true,
                    });
                });
            },

            saveValue: function() {
                var selectEls = $(this.ui.select);
                this.setValue(selectEls.val());
            },

            onBeforeDestroy: function() {
                // $(this.ui.select).select2('destroy');
                // this.saveValue();
            },
        });

        elementor.addControlView("cms_posts", CMSPostsControlView);
    });
})(jQuery);